/*
 * Decompiled with CFR 0.152.
 */
package noppes.animalbikes;

import com.google.common.base.Charsets;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import noppes.animalbikes.AnimalBikes;
import noppes.animalbikes.constants.EnumPackets;

public class Server {
    public static boolean sendData(EntityPlayerMP player, EnumPackets enu, Object ... obs) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            if (!Server.fillBuffer(buffer, enu, obs)) {
                return false;
            }
            AnimalBikes.Channel.sendTo(new FMLProxyPacket(buffer, "AnimalBikes"), player);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void sendAssociatedData(Entity entity, EnumPackets enu, Object ... obs) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            if (!Server.fillBuffer(buffer, enu, obs)) {
                return;
            }
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 60.0);
            AnimalBikes.Channel.sendToAllAround(new FMLProxyPacket(buffer, "AnimalBikes"), point);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void sendToAll(EnumPackets enu, Object ... obs) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            if (!Server.fillBuffer(buffer, enu, obs)) {
                return;
            }
            AnimalBikes.Channel.sendToAll(new FMLProxyPacket(buffer, "AnimalBikes"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean fillBuffer(ByteBuf buffer, Enum enu, Object ... obs) throws IOException {
        buffer.writeInt(enu.ordinal());
        for (Object ob : obs) {
            if (ob == null) continue;
            if (ob instanceof Map) {
                Map map = (Map)ob;
                buffer.writeInt(map.size());
                for (String key : map.keySet()) {
                    int value = (Integer)map.get(key);
                    buffer.writeInt(value);
                    Server.writeString(buffer, key);
                }
                continue;
            }
            if (ob instanceof List) {
                List list = (List)ob;
                buffer.writeInt(list.size());
                for (String s : list) {
                    Server.writeString(buffer, s);
                }
                continue;
            }
            if (ob instanceof Enum) {
                buffer.writeInt(((Enum)ob).ordinal());
                continue;
            }
            if (ob instanceof Integer) {
                buffer.writeInt(((Integer)ob).intValue());
                continue;
            }
            if (ob instanceof Boolean) {
                buffer.writeBoolean(((Boolean)ob).booleanValue());
                continue;
            }
            if (ob instanceof String) {
                Server.writeString(buffer, (String)ob);
                continue;
            }
            if (ob instanceof Float) {
                buffer.writeFloat(((Float)ob).floatValue());
                continue;
            }
            if (ob instanceof Long) {
                buffer.writeLong(((Long)ob).longValue());
                continue;
            }
            if (ob instanceof Double) {
                buffer.writeDouble(((Double)ob).doubleValue());
                continue;
            }
            if (!(ob instanceof NBTTagCompound)) continue;
            Server.writeNBT(buffer, (NBTTagCompound)ob);
        }
        if (buffer.array().length >= Short.MAX_VALUE) {
            System.err.println("Packet " + enu + " was too big to be send");
            return false;
        }
        return true;
    }

    public static void writeNBT(ByteBuf buffer, NBTTagCompound compound) throws IOException {
        byte[] bytes = CompressedStreamTools.func_74798_a((NBTTagCompound)compound);
        buffer.writeShort((int)((short)bytes.length));
        buffer.writeBytes(bytes);
    }

    public static NBTTagCompound readNBT(ByteBuf buffer) throws IOException {
        byte[] bytes = new byte[buffer.readShort()];
        buffer.readBytes(bytes);
        return CompressedStreamTools.func_152457_a((byte[])bytes, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
    }

    public static void writeString(ByteBuf buffer, String s) {
        byte[] bytes = s.getBytes(Charsets.UTF_8);
        buffer.writeShort((int)((short)bytes.length));
        buffer.writeBytes(bytes);
    }

    public static String readString(ByteBuf buffer) {
        try {
            byte[] bytes = new byte[buffer.readShort()];
            buffer.readBytes(bytes);
            return new String(bytes, Charsets.UTF_8);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static void doExplosion(World world, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        for (Object ob : world.field_73010_i) {
            EntityPlayerMP player = (EntityPlayerMP)ob;
            S27PacketExplosion packet = new S27PacketExplosion(explosion.field_77284_b, explosion.field_77285_c, explosion.field_77282_d, explosion.field_77280_f, explosion.field_77281_g, (Vec3)explosion.func_77277_b().get(player));
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }
}

