﻿#NoEnv
#SingleInstance, Force
FileEncoding , UTF-8
folderPath := A_ScriptDir "\案记"
Length := StrLen(folderPath) + 2

; 定义热键 Ctrl+Alt+F
^!f::
  
  ; 取得用户输入的关键词
  InputBox, keyword, , 请输入你要查找的关键词, , ,145
  
  ; 遍历文件夹下所有txt文件，并筛选包含关键词的文件名
  Loop Files, %folderPath%\*.txt, R
  {
    FileRead, fileContent, %A_LoopFileLongPath%
    if InStr(fileContent, keyword)
    {
      setpath := SubStr(A_LoopFileLongPath, Length)
      setpath := SubStr(setpath, 1, -3)
      setpath := StrReplace(setpath, "￥￥" , ":\")
      setpath := StrReplace(setpath, "￥" , "\")
      foundFiles .="""" . setpath . """" . " | "
    }
  }
  
  ; 输出所有包含关键词的txt文件名
  if foundFiles =
  {
    MsgBox, , 未找到匹配的txt文件, 在文件夹 %folderPath% 中未找到包含关键词 %keyword% 的txt文件。
    return
  }
  else
  {
    foundFiles := RTrim(foundFiles, OmitChars := " |")
    ;MsgBox, , 包含关键词的txt文件名, 在文件夹 %folderPath% 中找到以下包含关键词 %keyword% 的txt文件:`n`n%foundFiles%
    winactivate,ahk_class EVERYTHING
    winwaitactive,ahk_class EVERYTHING
    clipboard:=foundFiles
    sleep,100
    ControlFocus ,Edit1, ahk_class EVERYTHING
    sleep,50
    sendinput,^a
    sendinput,^v
    foundFiles:=""
    return
  }