---
order: 10
title: Internationalization
---

The default language of `antd@2.x` is currently English. If you wish to use other languages, follow the instructions below.

## ConfigProvider

`antd` provides a React Component [ConfigProvider](/components/config-provider) for configuring antd locale text globally.

```jsx
import { ConfigProvider } from 'antd';
import frFR from 'antd/lib/locale/fr_FR';

return (
  <ConfigProvider locale={frFR}>
    <App />
  </ConfigProvider>
);
```

You can see the complete configuration here: [ConfigProvider](/components/config-provider).

Note: `fr_FR` is the filename, the following table also follows the same rules.

The following languages are currently supported:

### Supported languages:

| Language                 | Filename |
| ------------------------ | -------- |
| Arabic                   | ar_EG    |
| Azerbaijani              | az_AZ    |
| Bulgarian                | bg_BG    |
| Belarusian               | by_BY    |
| Catalan                  | ca_ES    |
| Czech                    | cs_CZ    |
| Danish                   | da_DK    |
| German                   | de_DE    |
| Greek                    | el_GR    |
| English (United Kingdom) | en_GB    |
| English                  | en_US    |
| Spanish                  | es_ES    |
| Estonian                 | et_EE    |
| Persian                  | fa_IR    |
| Finnish                  | fi_FI    |
| French (Belgium)         | fr_BE    |
| French (France)          | fr_FR    |
| Irish (Ireland)          | ga_IE    |
| Galician (Spain)         | gl_ES    |
| Hebrew                   | he_IL    |
| Hindi                    | hi_IN    |
| Croatian                 | hr_HR    |
| Hungarian                | hu_HU    |
| Armenian                 | hy_AM    |
| Indonesian               | id_ID    |
| Italian                  | it_IT    |
| Icelandic                | is_IS    |
| Japanese                 | ja_JP    |
| Kurdish (Kurmanji)       | kmr_IQ   |
| Kannada                  | kn_IN    |
| Kazakh                   | kk_KZ    |
| Korean                   | ko_KR    |
| Lithuanian               | lt_LT    |
| Latvian                  | lv_LV    |
| Macedonian               | mk_MK    |
| Mongolian                | mn_MN    |
| Malay (Malaysia)         | ms_MY    |
| Norwegian                | nb_NO    |
| Nepal                    | ne_NP    |
| Dutch (Belgium)          | nl_BE    |
| Dutch                    | nl_NL    |
| Polish                   | pl_PL    |
| Portuguese (Brazil)      | pt_BR    |
| Portuguese               | pt_PT    |
| Romanian                 | ro_RO    |
| Russian                  | ru_RU    |
| Slovak                   | sk_SK    |
| Serbian                  | sr_RS    |
| Slovenian                | sl_SI    |
| Swedish                  | sv_SE    |
| Tamil                    | ta_IN    |
| Thai                     | th_TH    |
| Turkish                  | tr_TR    |
| Ukrainian                | uk_UA    |
| Vietnamese               | vi_VN    |
| Chinese (Simplified)     | zh_CN    |
| Chinese (Traditional)    | zh_HK    |
| Chinese (Traditional)    | zh_TW    |

See more usage at [ConfigProvider](/components/config-provider).

## Adding new language

If your language is not in above list, feel free to create a locale package based on the [en_US](https://github.com/ant-design/ant-design/blob/master/components/locale/en_US.tsx) lanugage pack and send us a pull request. For reference, you can refer to the pull request of adding the [Azerbaijani](https://github.com/ant-design/ant-design/pull/21387) language as a sample.
