---
order: 9
title: Third-Party Libraries
---

`antd` is built to implement [a set of high-quality React UI components](/components/overview) which follow Ant Design specification. It is impossible to include all useful components in one package, so we also recommend that using other great third-party libraries in React community.

| Category | Recommended Components |
| --- | --- |
| Visualization and charts | [AntV Data Visualization](https://antv.vision/en) [🔥 AntV Charting Library](https://g2plot.antv.vision/en) [BizCharts](https://github.com/alibaba/BizCharts) [recharts](https://github.com/recharts/recharts/) [viser](https://viserjs.github.io/) |
| React Hooks Library | [ahooks](https://github.com/alibaba/hooks) |
| Router | [react-router](https://github.com/ReactTraining/react-router) |
| Layout | [@rebass/grid](https://github.com/rebassjs/grid) [react-blocks](http://whoisandy.github.io/react-blocks/) [react-flexbox-grid](https://github.com/roylee0704/react-flexbox-grid) |
| Drag and drop | [react-beautiful-dnd](https://github.com/atlassian/react-beautiful-dnd/) [react-dnd](https://github.com/gaearon/react-dnd) [react-sortable-hoc](https://github.com/clauderic/react-sortable-hoc) |
| Code Editor | [react-codemirror2](https://github.com/scniro/react-codemirror2) [react-monaco-editor](https://github.com/superRaytin/react-monaco-editor) |
| Rich Text Editor | [react-quill](https://github.com/zenoamaro/react-quill) [braft-editor](https://github.com/margox/braft-editor) |
| JSON Viewer | [react-json-view](https://github.com/mac-s-g/react-json-view) |
| Color Picker | [rc-color-picker](https://github.com/react-component/color-picker) [react-color](http://casesandberg.github.io/react-color/) |
| Media Query | [react-responsive](https://github.com/contra/react-responsive) [react-media](https://github.com/ReactTraining/react-media) |
| Copy to clipboard | [react-copy-to-clipboard](https://github.com/nkbt/react-copy-to-clipboard) |
| Document head manager | [react-helmet](https://github.com/nfl/react-helmet) [react-helmet-async](https://github.com/staylor/react-helmet-async) |
| Icons | [react-fontawesome](https://github.com/FortAwesome/react-fontawesome) [react-icons](https://github.com/gorangajic/react-icons) |
| QR Code | [qrcode.react](https://github.com/zpao/qrcode.react) |
| Visual Graph Editor | [GGEditor](https://github.com/gaoli/GGEditor) |
| Top Progress Bar | [nprogress](https://github.com/rstacruz/nprogress) |
| i18n | [react-intl](https://github.com/yahoo/react-intl) |
| Code highlight | [react-syntax-highlighter](https://github.com/conorhastings/react-syntax-highlighter) |
| Markdown renderer | [react-markdown](https://remarkjs.github.io/react-markdown/) |
| Infinite Scroll | [react-virtualized](https://github.com/bvaughn/react-virtualized) [antd-table-infinity](https://github.com/Leonard-Li777/antd-table-infinity) |
| Map | [react-google-maps](https://github.com/tomchentw/react-google-maps) [google-map-react](https://github.com/istarkov/google-map-react) [react-amap](https://github.com/ElemeFE/react-amap) |
| Video | [react-player](https://github.com/CookPete/react-player) [video-react](https://github.com/video-react/video-react) [video.js](http://docs.videojs.com/tutorial-react.html) |
| Context Menu | [react-contextmenu](https://github.com/vkbansal/react-contextmenu/) [react-contexify](https://github.com/fkhadra/react-contexify) |
| Emoji | [emoji-mart](https://github.com/missive/emoji-mart) |
| Split View | [react-split-pane](https://github.com/tomkp/react-split-pane) |
| Image Crop | [antd-img-crop](https://github.com/nanxiaobei/antd-img-crop) [react-image-crop](https://github.com/DominicTobias/react-image-crop) |
| Trend Lines | [react-sparklines](https://github.com/borisyankov/react-sparklines) |
| Keywords highlight | [react-highlight-words](https://github.com/bvaughn/react-highlight-words) |
| Text Loop | [react-text-loop](https://github.com/braposo/react-text-loop) |
| Animation | [react-move](https://github.com/react-tools/react-move) [Ant Motion](https://motion.ant.design/components/tween-one) [react-spring](https://www.react-spring.io) |

## Products we are using ✨

There are some products to recommend for developer/designer/product manager.

| Category          | Recommended Products                                                  |
| ----------------- | --------------------------------------------------------------------- |
| Documentation     | [🐦 Yuque](https://www.yuque.com/?chInfo=ch_antd)                     |
| Icon              | [Iconfont](https://www.iconfont.cn/)                                  |
| Sketch plugin     | [Kitchen](https://kitchen.alipay.com)                                 |
| Online Playground | [codesandbox](https://codesandbox.io/) [codepen](https://codepen.io/) |
| Image Compressor  | [tinypng](https://tinypng.com/)                                       |
| Charts Dictionary | [图之典](http://tuzhidian.com/)                                       |

<style>
.markdown table td:first-child {
  width: 20%;
  font-weight: 500;
  background: #fcfcfc;
}
.markdown table td > a:not(:last-child) {
  margin-right: 18px;
}
.markdown table td > a:not(:last-child)::after {
  position: absolute;
  margin: 0 6px 0 8px;
  color: #bbb;
  content: '|';
  pointer-events: none;
}
</style>
