local assets =
{
    Asset("ANIM", "anim/swap_shadowcirclet.zip"),
		Asset("ATLAS", "images/inventoryimages/shadowcirclet.xml"),
	Asset("IMAGE", "images/inventoryimages/shadowcirclet.tex"),
}


local function BarrierGone(inst)

	    if inst._fx ~= nil then
        if inst._fx:IsValid() then
            inst._fx:Remove()
        end
        inst._fx = nil
    end

end

local function ResistanceGone(inst)
		    inst.components.equippable.dapperness = -TUNING.DAPPERNESS_TINY
	inst.components.armor:SetAbsorption(0.7)
				inst:RemoveTag("shadowbarrier")
end

local function OnBlocked(owner, data)
    local helmet = owner.components.inventory:GetEquippedItem(EQUIPSLOTS.HEAD)
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
	
	if data.attacker and data.attacker:HasTag("shadow") and not helmet:HasTag("shadowbarrier") then
helmet.components.armor:SetAbsorption(.90)

		    helmet.components.equippable.dapperness = -TUNING.DAPPERNESS_SMALL
  owner._fx = SpawnPrefab("forcefieldfx")
    owner._fx.entity:SetParent(owner.entity)
            owner._fx.entity:AddFollower()
     owner._fx.AnimState:SetMultColour(0.1, 0.1, 0.1, .5)
	    owner._fx.Light:Enable(false)
            owner._fx.Follower:FollowSymbol(owner.GUID, "swap_hat", 0, 70, 0)
			helmet:AddTag("shadowbarrier")
			owner:DoTaskInTime(20, BarrierGone)
			helmet:DoTaskInTime(20, ResistanceGone)
	end
	
	
		if data.attacker and data.attacker:HasTag("shadowchesspiece") and not helmet:HasTag("shadowbarrier") then
helmet.components.armor:SetAbsorption(.95)


  owner._fx = SpawnPrefab("forcefieldfx")
    owner._fx.entity:SetParent(owner.entity)
            owner._fx.entity:AddFollower()
     owner._fx.AnimState:SetMultColour(0.3, 0.2, 0.2, .8)
	    owner._fx.Light:Enable(false)
            owner._fx.Follower:FollowSymbol(owner.GUID, "swap_hat", 0, 70, 0)
			helmet:AddTag("shadowbarrier")
			owner:DoTaskInTime(30, BarrierGone)
			helmet:DoTaskInTime(30, ResistanceGone)
	end
	
end


local function OnTakeDamage(inst, damage_amount)





end





local function onequip(inst, owner)
        owner.AnimState:Show("HAT")
        owner.AnimState:Hide("HAIR_HAT")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
 --    -   if owner:HasTag("player") then
   --         owner.AnimState:Hide("HEAD")
    --        owner.AnimState:Show("HEAD_HAT")
   --     end	
		
    owner.AnimState:OverrideSymbol("swap_hat", "swap_shadowcirclet", "swap_hat")
    inst:ListenForEvent("blocked", OnBlocked, owner)
	inst:ListenForEvent("attacked", OnBlocked, owner)

end

local function onunequip(inst, owner)
        if owner:HasTag("player") then
            owner.AnimState:Show("HEAD")
            owner.AnimState:Hide("HEAD_HAT")
        end

        owner.AnimState:ClearOverrideSymbol("swap_hat")

        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAIR_HAT")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")

    owner.AnimState:ClearOverrideSymbol("swap_hat")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
	inst:RemoveEventCallback("attacked", OnBlocked, owner)
	
	    if owner._fx ~= nil then
        if owner._fx:IsValid() then
            owner._fx:Remove()
        end
        owner._fx = nil
    end
	

	inst.components.armor:SetAbsorption(0.7)
		    inst.components.equippable.dapperness = - TUNING.DAPPERNESS_TINY
end

local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("swap_shadowcirclet")
    inst.AnimState:SetBuild("swap_shadowcirclet")
    inst.AnimState:PlayAnimation("anim")

    inst:AddTag("waterproofer")
    inst.foleysound = "dontstarve/movement/foley/nightarmour"

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")




    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "shadowcirclet"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/shadowcirclet.xml"

    inst:AddComponent("armor")
    inst.components.armor:InitCondition(3000, 0.7)

    inst.components.armor.ontakedamage = OnTakeDamage




    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
		    inst.components.equippable.dapperness = - TUNING.DAPPERNESS_TINY
    		
	
	inst:AddTag("waterproofer")
    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0.01)



    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    MakeHauntableLaunch(inst)



    return inst
end

return Prefab("shadowcirclet", fn, assets)



