local assets=
{
    Asset("ANIM", "anim/idleshadowstuff.zip"),
    Asset("ANIM", "anim/swap_shadowtrident.zip"),
 
		Asset("ATLAS", "images/inventoryimages/shadowtrident.xml"),
	Asset("IMAGE", "images/inventoryimages/shadowtrident.tex"),
}

prefabs = {
}

local function onfinished(inst)
    inst:Remove()
end

    local function OnEquip(inst, owner)

        owner.AnimState:OverrideSymbol("swap_object", "swap_shadowtrident", "swap_shadowtrident")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end
	
 
    local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end


local function onattack(inst, attacker, target)

if target:HasTag("shadow") or target:HasTag("shadowchesspiece") then
 if target:HasTag("epic") then
 
			if attacker.components.combat.damagemultiplier then			
			 target.components.health:DoDelta(-attacker.components.combat.damagemultiplier * 90)
			elseif not attacker.components.combat.damagemultiplier then
			target.components.health:DoDelta(-90)
			end
	 target.components.combat:SuggestTarget(attacker) 
	 
	 else
	 			if attacker.components.combat.damagemultiplier then			
			 target.components.health:DoDelta(-attacker.components.combat.damagemultiplier * 60)
			elseif not attacker.components.combat.damagemultiplier then
			target.components.health:DoDelta(-60)
			end
	 target.components.combat:SuggestTarget(attacker) 
	 
	 
	 end
	 
else


				if attacker.components.combat.damagemultiplier then			
			 target.components.health:DoDelta(-attacker.components.combat.damagemultiplier * 30)
			elseif not attacker.components.combat.damagemultiplier then
			target.components.health:DoDelta(-30)
			end
	 target.components.combat:SuggestTarget(attacker)
end

	end


	
	
local function fn(sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
	inst.entity:AddNetwork()
     
    anim:SetBank("idleshadowstuff")
    anim:SetBuild("idleshadowstuff")
    anim:PlayAnimation("trident")

    inst:AddTag("sharp")
        inst:AddTag("shadow")

      if not TheWorld.ismastersim then
        return inst
    end



	inst.entity:SetPristine()

	
    inst:AddComponent("inspectable")
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(1)
		inst.components.weapon:SetRange(1.2)
	inst.components.weapon:SetOnAttack(onattack)


	inst:AddTag("waterproofer")
    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0.01)
     
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "shadowtrident"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/shadowtrident.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	    inst.components.equippable.dapperness = TUNING.CRAZINESS_SMALL
	
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(200)
    inst.components.finiteuses:SetUses(200)
    inst.components.finiteuses:SetOnFinished(onfinished)

            MakeHauntableLaunch(inst)
 
    return inst
end

return  Prefab("common/inventory/shadowtrident", fn, assets, prefabs)