local assets=
{ 
    Asset("ANIM", "anim/amyhammer.zip"),
    Asset("ANIM", "anim/swap_amyhammer.zip"), 

    Asset("ATLAS", "images/inventoryimages/amyhammer.xml"),
    Asset("IMAGE", "images/inventoryimages/amyhammer.tex"),
}

local prefabs = 
{
}

    local function OnEquip(inst, owner) 
        --owner.AnimState:OverrideSymbol("swap_object", "swap_amyhammers", "purplestaff")
        owner.AnimState:OverrideSymbol("swap_object", "swap_amyhammer", "amyhammer")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
    end

local function fn()
	
    local inst = CreateEntity()
	
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
	
    MakeInventoryPhysics(inst)
    
	
    inst:AddTag("hammer")
    inst.AnimState:SetBank("amyhammer")
    inst.AnimState:SetBuild("amyhammer")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")
    inst:AddTag("pointy")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(100)
	inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.HAMMER, 2.5)
	inst.components.tool:SetAction(ACTIONS.MINE, 1.5)
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "amyhammer"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/amyhammer.xml"
    
inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	inst.components.inventoryitem.onputininventoryfn = function(inst, owner)
		if owner and owner:HasTag("player") and owner.prefab ~= "amyrose" then
			inst:DoTaskInTime(0.1, function()
				owner.components.inventory:DropItem(inst)
				owner.components.talker:Say("I don't think Amy would like that!")
			end)
		end
	end 
    return inst
end

return  Prefab("common/inventory/amyhammer", fn, assets, prefabs)