/**
 * @default obj 默认 Response 数据
 */
const obj = {
  id: 'uuid', // 此次请求的唯一id 已有
  action: 'end', // start 开始请求 end 请求结束 1111 已有
  error: '', // 请求异常信息 string
  request: {}, // 请求对象信息
  resTime: 'HH:mm:ss', // 响应的时间  时:分:秒
  resMillisecond: '', // 请求花费时间 毫秒ms
  resHeader: {}, // 响应头信息
  resBody: '', // 响应体
  resBodyPath: '', // 响应体地址  已有
  resCode: {
    code: 404, // 当response为undefined 默认为502
    status: 'Not Found', // 502 为无效网关
  },
  resBodySize: '20', // 响应体 大小 单位 M 已有
  resBodyType: 'text', // image 为图片格式（可以预览） ｜ other 为需要下载的格式 ｜ text 为可以在实时响应里的格式响应

  language: 'html', // 下载响应体时文件的后缀 已有

  assertions: [], // 断言数组 （待定）

  cookies: [], // 响应返回的cookie 已有
  netWork: {
    agrent: 'Desktop Agent', // Desktop-Agent 桌面代理 ｜Cloud-Agent 远端服务器代理 已有
    addresses: { // 请求地址信息
      local: { // 发送地址信息
        address: '', // 地址 client.localAddress
        family: '', // 网际协议版本
        port: '', // 端口号 client.localPort
      },
      remote: { // 请求远端地址信息  clinet._peername
        address: '', // 地址
        family: '', // 网际协议版本 client.remoteFamily
        port: '', // 端口号
      },
    },
  },
  code: '200', // 200 成功 非200 都失败 已有
};
module.exports = obj;
