/* eslint-disable no-unused-expressions */
const dayjs = require('dayjs');
const FormData = require('form-data');
const url = require('url');
const gotSend = require('got');
const fs = require('fs');

const cloneDeepObj = require('./default');
const writeFileFlow = require('./utils');

const ruleType = (data) => {
  const d = Object.prototype.toString.call(data);
  return d.substr(8, d.length - 9);
};
process.on('message', async (messageData) => {
  const startTime = new Date().getTime();
  const requestData = JSON.parse(messageData);
  const { data, _cache_dir } = requestData;
  const {
    id, request, mode, sendType, form,
  } = JSON.parse(data);
  if (request.form !== undefined) {
    request.form = new URLSearchParams(request.form);
  }
  // const request = JSON.parse(data);
  if (mode === 'multipart/form-data') {
    const tempForm = new FormData();
    if (ruleType(request.body) === 'Array') {
      request.body && request.body.forEach((item) => {
        if (ruleType(item.value) === 'Array') {
          item.value.forEach((item1) => {
            try {
              tempForm.append(item.key, fs.createReadStream(item1));
            } catch (error) {
              console.log('240', error);
            }
          });
        } else {
          tempForm.append(item.key, item.value);
        }
      });
    } else {
      request.body && Object.keys(request.body).forEach((key) => {
        const value = request.body[key];
        if (ruleType(value) === 'Array') {
          value.forEach((item1) => {
            try {
              tempForm.append(key, fs.createReadStream(item1));
            } catch (error) {
              console.log('255', error);
            }
          });
        } else {
          tempForm.append(key, request.body[key]);
        }
      });
      request.files && Object.keys(request.files).forEach((key) => {
        const value = request.files[key];
        if (value instanceof Array) {
          value.forEach((item1) => {
            try {
              tempForm.append(key, fs.createReadStream(item1.path));
            } catch (error) {
              console.log(error);
            }
          });
        } else {
          tempForm.append(key, fs.createReadStream(value.path));
        }
      });
    }
    request.body = tempForm;
  }
  let Response = null;
  const responseObj = {
    id,
    resTime: dayjs(new Date().getTime()).format('HH:mm:ss'),
  };
  try {
    Response = await gotSend({
      ...request,
      methodRewriting: false,
    });
  } catch (err) {
    if (err.response) {
      Response = err.response;
    }
    cloneDeepObj.errors = err;
    cloneDeepObj.error = err.message;
  }
  if (Response === null) {
    const stringData = JSON.stringify({
      ...cloneDeepObj,
      ...responseObj,
      resMillisecond: new Date().getTime() - startTime,
      action: 'end',
      request,
      code: -1,
      sendType,
    });
    process.send(stringData);
  } else {
    try {
      writeFileFlow(Response, _cache_dir, false).then((res) => {
        const responseData = JSON.stringify({
          ...cloneDeepObj,
          ...responseObj,
          code: 200,
          sendType,
          ...res,
        });
        process.send(responseData);
      }).catch((err) => {
        process.send(data);
        const responseData = JSON.stringify({
          ...cloneDeepObj,
          ...responseObj,
          sendType,
          code: -1,
        });
        process.send(responseData);
      });
    } catch (err) {
      const responseData = JSON.stringify({
        ...cloneDeepObj,
        request,
        action: 'end',
        code: -1,
        sendType,
      });
      process.send(responseData);
    }
  }
});
