/* eslint-disable camelcase */
/* eslint-disable no-underscore-dangle */
/* eslint-disable no-shadow */
const {
  app,
  BrowserWindow,
  Menu,
  screen,
  ipcMain,
} = require('electron');
const path = require('path');
// const fs = require('fs');
const child_process = require('child_process');
const url = require('url');

let mainWindow = null;
const env = process.env.NODE_ENV || 'development';

let _is_downloading = false;
let _cache_dir = '';
let child = null;
let eventBus = null;
process.env.ELECTRON_DISABLE_SECURITY_WARNINGS = 'true';
app.allowRendererProcessReuse = true;

function createWindow() {
  // 自适应分辨率
  const _size = screen.getPrimaryDisplay().workAreaSize;
  let _width = parseInt(_size.width * 0.82, 10);
  const _height = parseInt(_size.height * 0.82, 10);

  const _min_width = parseInt(_size.width * 0.5, 10);
  const _min_height = parseInt(_size.height * 0.55, 10);
  if (process.env.LOCALAPPDATA) {
    _cache_dir = process.env.LOCALAPPDATA;
  } else {
    _cache_dir = app.getPath('userData');
  }
  if (_width % 2 !== 0) {
    _width += 1; // 宽度为偶数
  }
  mainWindow = new BrowserWindow({
    width: 1300,
    minWidth: _min_width,
    height: _height,
    minHeight: _min_height,
    frame: false,
    titleBarStyle: 'hidden',
    // show: false,
    backgroundColor: 'red',
    enableRemoteModule: true,
    webSecurity: false,
    webPreferences: {
      contextIsolation: false,
      webSecurity: false,
      nativeWindowOpen: true,
      enableRemoteModule: true,
      nodeIntegration: true, // 注入node模块
      preload: path.join(__dirname, 'preload.js'),
    },
  });
  // mainWindow.once('ready-to-show', () => {
  //   // mainWindow.maximize();
  //   mainWindow.show();
  // });

  // if (env === 'development') {
  //   mainWindow.loadURL('http://localhost:3000');
  //   mainWindow.webContents.openDevTools();
  // } else {
  // console.log(path.join(__dirname, './build1/index.html'));
  mainWindow.loadURL(url.format({
    pathname: path.join(__dirname, './build1/index.html'),
    protocol: 'file:',
    slashes: true,
    httpReferrer: 'https://www.apipost.cn/',
    userAgent: `Apipost client ${process.platform} Runtime/+https://www.apipost.cn/`,
  }));
  mainWindow.on('closed', () => {
    app.quit();
  });
  // mainWindow.webContents.openDevTools();
  // }
  child = child_process.fork(path.join(__dirname, './gotSend.js'));
  child.on('message', (msg) => {
    eventBus.sender.send('proxy-response', msg);
    // eventBus = null;
  });
  child.on('error', (err) => {
    console.log(err);
  });
  // 升级弹窗;
  mainWindow.webContents.session.on('will-download', (event, item) => {
    if (!_is_downloading) {
      _is_downloading = true;
      const _url = item.getURL(); // protocol
      if (_url) {
        let _urls = null;

        try {
          _urls = new URL(_url);
        } catch (e) {
          _urls = null;
        }

        if (_urls && _urls.origin.indexOf('apipost.cn') > -1) {
          // 定义缓存目录

          // 获取更新包基本信息
          let _update_patch = item.getFilename();

          if (typeof _update_patch !== 'string') {
            _update_patch = '';
          }

          let filePath = path.join(app.getPath('downloads'), item.getFilename());
          const _index = _update_patch.lastIndexOf('.');
          const _ext = _update_patch.substring(_index + 1);

          // 根据更新方式获取不同的下载路径
          if (_ext === 'zip') { // 增量更新
            filePath = path.resolve(path.dirname(app.getAppPath()), 'app.asar.unpacked', 'plugins.patch.zip');
          } else { // 全量更新
            filePath = path.resolve(_cache_dir, 'install', item.getFilename());
          }
          item.setSavePath(filePath);

          const _getTotalBytes = item.getTotalBytes();
          const downloadBytes = item.getReceivedBytes();
          // 监听当前下载状态
          item.on('updated', (event, state) => {
            if (state !== 'progressing') {
              _is_downloading = false;
              mainWindow.webContents.send('down-fail', { path: filePath });
            } else if (mainWindow && !mainWindow.isDestroyed()) {
              const sendObj = JSON.stringify({
                name: item.getFilename(),
                path: filePath,
                type: _ext,
                procress: (item.getReceivedBytes() / _getTotalBytes).toFixed(2),
                receive: item.getReceivedBytes(),
                total: _getTotalBytes,
              });
              mainWindow.webContents.send('down-process', sendObj);
            } else {
              mainWindow.webContents.send('down-fail', { path: filePath });
            }
          });
          // 监听当前完成状态
          item.once('done', (event, state) => {
            _is_downloading = false;
            if (state === 'completed') {
              // 完成之后需要将相应的数据传递到fe 项目
              if (mainWindow && !mainWindow.isDestroyed()) {
                mainWindow.webContents.send('down-done', {
                  name: item.getFilename(),
                  path: filePath,
                  type: _ext,
                  receive: item.getReceivedBytes(),
                  total: _getTotalBytes,
                  procress: 1,
                });
              } else {
                mainWindow.webContents.send('down-fail', { path: filePath });
              }
            } else {
              mainWindow.webContents.send('down-fail', { path: filePath });
            }
          });
        }
      }
    }
  });
  const _template = [
    {
      label: 'ApiPost',
      role: 'windowMenu',
      submenu: [
        {
          label: '检查更新',
          click() {
            mainWindow.webContents.send('action', 'checkUpdate');
          },
          accelerator: 'CmdOrCtrl+U',
        },
        {
          type: 'separator',
        },
        {
          label: '退出',
          role: 'quit',
          accelerator: 'CmdOrCtrl+Q',
        },
      ],
    },
    {
      label: '编辑',
      submenu: [
        {
          label: '撤销',
          accelerator: 'CmdOrCtrl+Z',
          role: 'undo',
        },
        {
          label: '重做',
          accelerator: 'Shift+CmdOrCtrl+Z',
          role: 'redo',
        },
        {
          type: 'separator',
        },
        {
          label: '复制',
          accelerator: 'CmdOrCtrl+C',
          role: 'copy',
        },
        {
          label: '剪切',
          accelerator: 'CmdOrCtrl+X',
          role: 'cut',
        },
        {
          label: '粘贴',
          accelerator: 'CmdOrCtrl+V',
          role: 'paste',
        },
        {
          type: 'separator',
        },
        {
          label: '全选',
          accelerator: 'CmdOrCtrl+A',
          role: 'selectAll',
        },
      ],
    },
    {
      label: '关于',
      role: 'help',
      submenu: [
        {
          label: '关于',
          click() {
            mainWindow.webContents.send('action',
              'about');
          },
        },
      ],
    },
  ];

  const _menu = Menu.buildFromTemplate(_template);
  Menu.setApplicationMenu(_menu);
}

const gotTheLock = app.requestSingleInstanceLock();
if (!gotTheLock) {
  app.quit();
} else {
  app.on('ready', createWindow);
}

ipcMain.on('window-all-closed', () => {
  app.quit();
  app.exit(0);
});

ipcMain.on('restart', (event, data) => {
  app.exit(0);
});
// 监听与渲染进程的通信
ipcMain.on('reqaction', (event, arg) => {
  switch (arg.action) {
    case 'updateInstallDownload':
      if (!_is_downloading) {
        mainWindow.webContents.downloadURL(arg.url);
      }
      break;
    case 'silentUpdateInstallDownload':
      if (!_is_downloading) {
        mainWindow.webContents.downloadURL(`https://www.apipost.cn/update_check.php?do=silentUpdateInstallDownload&client=${arg.client}&version=${arg.version}&platform=${process.platform}&arch=${process.arch}`);
      }
      break;
    default:
      break;
  }
});

ipcMain.on('new_win', (e, arg) => {
  // 创建子页面
  let main_new_win = new BrowserWindow({
    width: 840,
    minWidth: 840,
    height: 550,
    minHeight: 350,
    frame: false,
    titleBarStyle: 'hidden',
    // show: false,
    // backgroundColor: '#f7f7f7',
    enableRemoteModule: true,
    webSecurity: false,
    webPreferences: {
      contextIsolation: false,
      // webSecurity: false,
      nativeWindowOpen: true,
      enableRemoteModule: true,
      nodeIntegration: true, // 注入node模块
      preload: path.join(__dirname, 'preload.js'),
    },
  });
  // main_new_win.webContents.openDevTools();
  // main_new_win.loadURL('http://www.baidu.com');
  // main_new_win.loadURL(path.join(__dirname, 'index.html', '#', 'console'));
  // 控制台路径
  // main_new_win.loadFile(path.join(__dirname, './build1/index.html?a=1'));
  // main_new_win.loadURL('localhost:3000');
  // main_new_win.loadURL('https://beta6-api.apipost.cn/#/console');
  // main_new_win.webContents.send('consoleList', { a: 1 }); // 发送消息
  // main_new_win.on('ready-to-show', function () {
  //   main_new_win.webContents.send('data', { a: 1 }); // 发送消息
  //   main_new_win.show(); // 初始化后再显示
  // });
  // e.reply('send-message-to-renderer', '这是来自主进程的问候');
  main_new_win.on('closed', () => { main_new_win = null; });
});

ipcMain.on('proxy-send', async (event, data) => {
  eventBus = event;
  child.send(JSON.stringify(
    {
      data,
      _cache_dir,
    },
  ));
});
app.on('activate', () => {
  try {
    if (mainWindow === null) createWindow();
  } catch (error) {}
});
