#!/usr/bin/env node
'use strict';

Object.defineProperty(exports, "__esModule", {
	value: true
});
exports.variants = exports.run = undefined;

var _chalk = require('chalk');

var _chalk2 = _interopRequireDefault(_chalk);

var _minimist = require('minimist');

var _minimist2 = _interopRequireDefault(_minimist);

var _child_process = require('child_process');

var _readline = require('readline');

var _readline2 = _interopRequireDefault(_readline);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const COLORS = ['blue', 'magenta', 'cyan', 'yellow', 'gray', 'green', 'white'];
const RE = () => /^pkg:\/\/(.*)$/;
const RE_WATCH = () => /^pkg\*:\/\/(.*)$/;
const RE_ANY = () => /^pkg\*?:\/\/(.*)$/;

let currColor = -1;

function run(variant) {
	const variantName = RE_ANY().exec(variant)[1];
	const color = _chalk2.default[COLORS[currColor = ++currColor % COLORS.length]];
	const proc = (0, _child_process.spawn)('npm', ['run', variant], { cwd: process.cwd() });
	function track(stream, tag) {
		const lines = _readline2.default.createInterface({ input: stream });
		lines.on('line', l => console.log(color(`(${variantName}${tag ? `:${_chalk2.default.red(tag)}` : ''})`), l.replace(/\r?\n$/m, '')));
	}
	track(proc.stdout);
	track(proc.stderr, 'err');
	proc.on('exit', code => {
		console.log(color(`(${variantName}:exit) - ${code}`));
		if (code != 0) process.exitCode = 1;
	});
}

function variants(regexp = RE()) {
	const pkg = require(`${process.cwd()}/package.json`);
	return Object.keys(pkg.scripts || {}).filter(script => {
		regexp.lastMatch = 0;
		return regexp.test(script);
	});
}

function main() {
	const args = (0, _minimist2.default)(process.argv.slice(2));
	if (args.h || args.help) return console.log(require('./help').trim());
	if (args.v || args.version) return console.log('pkgbuild', require('../package.json').version);

	variants(args.w || args.watch ? RE_WATCH() : RE()).filter(v => args._.length > 0 ? args._.includes(v) : v).forEach(v => run(v));
}

exports.run = run;
exports.variants = variants;

if (require.main == module) main();