const child_process = require('child_process');
const fs = require('fs');
const path = require('path');
const mime = require('mime');

/**
 *
 * @param {*} response  got 返回的详细数据
 * @param {*} dirnamePath 用户电脑上的安全存储地址
 * @param {*} isReturnFilePath 是否需要返回文件地址
 * @returns
 */
const codeError = {
  '-1': 'got error ',
  '-2': 'fs 写入文件错误',
  '-3': 'got 请求不存在ResponseBofy',
  '-4': '执行类型错误',
};
const readFIle = (filePath) => new Promise((reslove, reject) => {
  fs.readFile(filePath, 'utf-8', (err, data) => {
    if (!err) {
      try {
        const d = JSON.parse(data);
        reslove('json');
      } catch {
        reslove(null);
      }
    }
    console.log(err, data, 110, 'application/octex-stream');
  });
});
const windowAUthFIle = async (dittarget, filePath) => {
  let filetype = 'other';
  console.log(dittarget, 'dittarget', filePath, 'filePath');
  const [contentType] = dittarget;
  if (dittarget.indexOf('text/html') > 0) {
    filetype = 'text';
  } else if (dittarget.indexOf('image') > 0) {
    filetype = 'image';
  } else if (dittarget.indexOf('pdf') > 0) {
    filetype = pdf;
  } else {
    const d = await readFIle(filePath);
    if (d !== null) {
      filetype = 'text';
    }
  }

  return new Promise((reslove) => {
    reslove(filetype);
  });
};
const AP = {
  IMG_EXTS: ['png', 'jpg', 'jpeg', 'gif', 'bmp', 'ico'], // 图片的格式
  ATTACHMENT_EXTS: ['rar', 'zip', 'mp3', 'mp4', 'wav', 'xls', 'xlsx', 'dbf', 'mht', 'mhtml', 'et', 'dif', 'wps', 'wpt', 'doc', 'docx', 'ppt', 'rtf', 'dot', 'dotx', 'docm', 'dotm', 'pps', 'exe', 'ppsx', 'gz', 'tar', 'flv', 'bin'], // 无法预览的格式
};

const ResponseBody = async (response) => {
  const content_type = response.headers['content-type'];
  console.log(content_type, 'content_type');
  const ResloveObj = {
    resBodySize: response.body.byteLength / 1024,
    resBodyType: null,
  };
  const ext = mime.getExtension(content_type);
  console.log(ext);
  if (AP.IMG_EXTS.includes(ext)) {
    const base64Img = response.body.toString('base64');
    ResloveObj.resBodyType = 'image';
    ResloveObj.resBodyBase64 = `data:image/png;base64,${base64Img}`;
  } else if (AP.ATTACHMENT_EXTS.includes(ext)) {
    // TODO: 下载文件
    ResloveObj.resBodyType = 'other';
    ResloveObj.response.responseBody = '';
  } else if (ext === 'pdf') {
    ResloveObj.resBodyType = 'pdf';
    const base64Img = response.body.toString('base64');
    ResloveObj.resBodyBase64 = `data:application/pdf;base64,${base64Img}`;
  } else {
    ResloveObj.resBodyType = 'text';
  }
  return new Promise((reslove) => {
    reslove(ResloveObj);
  });
};
const base64 = (responseData) => {
  const bytes = new Uint8Array(responseData);
  let data = '';
  const len = bytes.byteLength;
  for (let i = 0; i < len; i++) {
    data += String.fromCharCode(bytes[i]);
  }
  image.src = `data:image/png;base64,${window.btoa(data)}`;
};
const writeFileFlow = async (response, dirnamePath, isReturnFilePath = true) => {
  const abbbb = Math.random();
  const lastFilePath = path.join(dirnamePath, `./${abbbb}`);
  return new Promise(async (reslove) => {
    try {
      const cookies = await ResponseCookie(response);
      const NetWork = await netWork(response, isReturnFilePath);
      const {
        headers, request, timings, statusCode, statusMessage,
      } = response;
      const { end, start } = timings;
      const resMillisecond = end - start;
      const responseObj = {
        action: 'end',
        resHeader: headers,
        request,
        resBody: JSON.stringify(response.body),
        resMillisecond,
        resCode: {
          code: statusCode,
          status: statusMessage,
        },
        cookies,
        netWork: NetWork,
      };
      if (!isReturnFilePath) {
        const res = await ResponseBody(response);
        reslove({ ...responseObj, ...res });
      } else if (response && response.body) {
        fs.writeFile(lastFilePath, response.body, async (err, content) => {
          if (!err) {
            const res = await shellFileDoc(lastFilePath, response, dirnamePath, isReturnFilePath);
            reslove({
              ...responseObj,
              ...res,
            });
          } else {
            reslove({
              code: -1,
            });
          }
        });
      } else {
        reslove({
          code: -1,
        });
      }
    } catch (err) {
      console.log(err, 'writefile');
      reslove({
        code: -1,
      });
    }
  });
};
const netWork = (response, isReturnFilePath) => new Promise((reslove, reject) => {
  const {
    client,
  } = response;
  const {
    _peername,
  } = client;
  function ifaces() {
    const os = require('os');
    const iptable = [];
    const ifaces = os.networkInterfaces();

    for (const dev in ifaces) {
      ifaces[dev].forEach((details, alias) => {
        if (details.family == 'IPv4' && dev.substr(0, 2) != 'lo' && !details.internal) {
          iptable.push(details.address);
        }
      });
    }

    return iptable;
  }
  const address = {
    remote: {
      ..._peername,
    },
    local: {
      address: ifaces()[0],
      prot: 10066,
      family: 'IPv4',
    },
  };
  reslove({
    agent: isReturnFilePath ? 'Desktop Agent' : 'Cloud Agent',
    address,
  });
});
/** ··
 *
 * @param {*} mkdirPath 写入用户电脑的安全地址路径，需要创建 HTML｜IMAGE 等不同类型的文件夹
 * @param {*} filePath 写入用户地址，带后缀
 * @param {*} response got 返回所有数据
 * @returns
 */
const fileConversion = (mkdirPath, filePath, response) => {
  try {
    return new Promise(async (resolve, reject) => {
      try {
        fs.accessSync(mkdirPath);
      } catch (err) {
        try {
          fs.mkdirSync(mkdirPath);
        } catch (error) {
        }
      }
      fs.writeFile(filePath, response.body, (err) => {
        if (err) {
          // reject(err)
          console.log(err);
          resolve('');
        } else {
          resolve(filePath);
        }
      });
    });
  } catch (ee) {
    console.log(ee);
  }
};
const authFIle = (dilTarget) => {
  const [doc, type] = dilTarget;
  const downloadFIle = ['rar', 'zip', 'mp3', 'mp4', 'wav', 'xls', 'xlsx', 'dbf', 'mht', 'mhtml', 'et', 'dif', 'wps', 'wpt', 'doc', 'docx', 'ppt', 'rtf', 'dot', 'dotx', 'docm', 'dotm', 'pps', 'exe', 'ppsx', 'gz', 'tar', 'flv', 'bin']; // 无法预览的格式
  const downloadIndex = downloadFIle.findIndex((it) => it === type.toLowerCase());
  let authType = 'text';
  if (type === 'image') {
    authType = 'image';
  }
  if (doc.toLowerCase() === 'pdf') {
    authType = 'pdf';
  }
  if (downloadIndex > -1) {
    authType = 'other';
  }
  return new Promise((reslove, reject) => {
    reslove(authType);
  });
};
/**
 *
 * @param {*} filePath shell 写入的目标地址，用shell 执行，返回文件的类型，例如 HTML、IMAGE
 * @param {*} response got返回数据
 * @param {*} catch_dir 用户安全地址
 * @param {*} isReturnFilePath 是否需要执行写入
 * @returns
 */
const shellFileDoc = async (filePath, response, catch_dir, isReturnFilePath) => {
  const execShell = `file '${filePath}'`;
  console.log(filePath, 'filePath');
  return new Promise((reslove) => {
    const ResloveObj = {
      resBodySize: response.body.byteLength / 1024,
      language: '',
      resBodyType: null,
    };
    // linux 执行脚本
    child_process.exec(execShell, async (error, stdout, stderr) => {
      if (!error) {
        const dil = stdout.split(':')[1];
        const dilTarget = dil.substr(1, dil.length).split(' ');
        const authFile = await authFIle(dilTarget);
        if (authFile === 'image') {
          var base64Img = response.body.toString('base64');
          ResloveObj.resBodyBase64 = `data:image/png;base64,${base64Img}`;
        }
        if (authFile === 'pdf') {
          var base64Img = response.body.toString('base64');
          ResloveObj.resBodyBase64 = `data:application/pdf;base64,${base64Img}`;
        }
        fs.unlink(filePath, (err) => {
          if (err) console.log('删除失败');
        });
        ResloveObj.resBodyType = authFile;
        reslove({ ...ResloveObj });

        // console.log(ResloveObj,'mac返回');
      } else {
        const pathss = path.join(__dirname);
        // windows 执行脚本
        child_process.exec(`"${pathss}\\checkfileType.exe" -file ${filePath}`, async (errrr, student, stderr) => {
          console.log(errrr, student, '1231231231');
          if (!errrr) {
            console.log(222);
          }
          console.log(student);
          try {
            const AUthFIle = await windowAUthFIle(student, filePath);
            console.log(AUthFIle, '123123123');
            let lowerCase = '';
            if (AUthFIle === 'image') {
              const [contentType] = dittarget;
              lowerCase = contentType.split('/')[1];
            }
            ResloveObj.resBodyType = AUthFIle;
            if (AUthFIle === 'pdf') {
              const base64Img = response.body.toString('base64');
              ResloveObj.resBodyBase64 = `data:application/pdf;base64,${base64Img}`;
            }
            ResloveObj.resBodyType = AUthFIle;

            reslove({
              ...ResloveObj,
            });
          } catch (err1) {
            console.log(err1, 'exe error');
            reslove({ ...ResloveObj });
          }
        });
      }
    });
  });
};

/**
 *
 * @param {*} response got请求返回值
 * @returns responseCookies
 */
const ResponseCookie = (response) => {
  const responseCookies = [];
  const { request } = response;
  return new Promise((reslove, reject) => {
    try {
      response.headers && response.headers['set-cookie'].forEach((cookieStr) => {
        const arr = cookieStr.split('; ');
        const newCookie = {};
        for (let index = 0; index < arr.length; index++) {
          const item = arr[index].trim();
          switch (item.toLowerCase()) {
            case 'hostonly':
              newCookie.hostOnly = true;
              break;
            case 'secure':
              newCookie.secure = true;
              break;
            case 'httponly':
              newCookie.httpOnly = true;
              break;
            default:
              break;
          }
          const indexof = item.indexOf('=');

          // 默认第一个为key value
          if (index == 0) {
            newCookie.key = indexof == -1 ? item : item.substr(0, indexof);
            newCookie.value = indexof == -1 ? '' : item.substr(indexof + 1, item.length - 1 - indexof);
            continue;
          }
          if (indexof != -1 && indexof < item.length - 1) {
            const proprety = item.substr(0, indexof).toLowerCase();
            let provalue = item.substr(indexof + 1, item.length - 1 - indexof);
            if (proprety == 'domain') {
              provalue.substr(0, 1) == '.' ? provalue = provalue.substr(1, provalue.length) : '';
            }
            newCookie[proprety] = provalue;
          }
        }

        if (!newCookie.hasOwnProperty('domain')) {
          const url = request.requestUrl.split('//')[1];
          let newdomain = url.split('/')[0];
          newdomain = newdomain.split(':')[0];
          newCookie.domain = newdomain;
        }
        if (!newCookie.hasOwnProperty('path')) {
          newCookie.path = '/';
        } else {
          // 给用户处理不正常path
          if (newCookie.path.indexOf('/') != 0) {
            const url = request.url.split('//')[1];
            let urlarr = url.split('/');
            if (urlarr.length > 2) {
              urlarr.shift();
              urlarr.pop();
              urlarr = urlarr.map((s) => `/${s}`);
              newCookie.path = urlarr.join('');
            } else {
              newCookie.path = '/';
            }
          }
        }
        if (newCookie.hasOwnProperty('domain') && newCookie.hasOwnProperty('key')
          && newCookie.hasOwnProperty('value') && newCookie.hasOwnProperty('path')) {
          for (const property in newCookie) {
            if (property == 'max-age') {
              let nowData = new Date().getTime();
              nowData += newCookie[property] * 1000;
              newCookie.expires = new Date(nowData);
            }
          }
          // 过期删除
          if (newCookie.expires != undefined) {
            if (new Date(newCookie.expires) <= new Date()) { } else {
              responseCookies.push(newCookie);
            }
          } else {
            responseCookies.push(newCookie);
          }
        }
      });
    } catch (err) {
      // reject(err)
      reslove([]);
    }
    reslove(responseCookies);
  });
};

module.exports = writeFileFlow;
