/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jf.dexlib2.writer.TypeListSection;
import org.jf.dexlib2.writer.builder.BaseBuilderPool;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;
import org.jf.dexlib2.writer.builder.BuilderTypeList;
import org.jf.dexlib2.writer.builder.BuilderTypePool;
import org.jf.dexlib2.writer.builder.BuilderTypeReference;
import org.jf.dexlib2.writer.builder.DexBuilder;

class BuilderTypeListPool
extends BaseBuilderPool
implements TypeListSection<BuilderTypeReference, BuilderTypeList> {
    private final ConcurrentMap<List<? extends CharSequence>, BuilderTypeList> internedItems = Maps.newConcurrentMap();

    public BuilderTypeListPool(DexBuilder dexBuilder) {
        super(dexBuilder);
    }

    public BuilderTypeList internTypeList(List<? extends CharSequence> types) {
        if (types == null || types.size() == 0) {
            return BuilderTypeList.EMPTY;
        }
        BuilderTypeList ret = (BuilderTypeList)this.internedItems.get(types);
        if (ret != null) {
            return ret;
        }
        BuilderTypeList typeList = new BuilderTypeList(ImmutableList.copyOf(Iterables.transform(types, new Function<CharSequence, BuilderTypeReference>(){

            @Override
            public BuilderTypeReference apply(CharSequence input) {
                return ((BuilderTypePool)BuilderTypeListPool.this.dexBuilder.typeSection).internType(input.toString());
            }
        })));
        ret = this.internedItems.putIfAbsent(typeList, typeList);
        return ret == null ? typeList : ret;
    }

    @Override
    public int getNullableItemOffset(BuilderTypeList key) {
        return key == null || key.size() == 0 ? 0 : key.offset;
    }

    @Override
    public Collection<? extends BuilderTypeReference> getTypes(BuilderTypeList key) {
        return key == null ? BuilderTypeList.EMPTY : key.types;
    }

    @Override
    public int getItemOffset(BuilderTypeList key) {
        return key.offset;
    }

    @Override
    public Collection<? extends Map.Entry<? extends BuilderTypeList, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderTypeList>(this.internedItems.values()){

            @Override
            protected int getValue(BuilderTypeList key) {
                return key.offset;
            }

            @Override
            protected int setValue(BuilderTypeList key, int value) {
                int prev = key.offset;
                key.offset = value;
                return prev;
            }
        };
    }
}

