/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.DexBackedOdexFile;
import org.jf.dexlib2.dexbacked.OatFile;
import org.jf.dexlib2.dexbacked.ZipDexContainer;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.util.ExceptionWithContext;

public final class DexFileFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiDexContainer.DexEntry<? extends DexBackedDexFile> loadDexEntry(File file, String dexEntry, boolean exactMatch, Opcodes opcodes) throws IOException {
        if (!file.exists()) {
            throw new DexFileNotFoundException("Container file %s does not exist", file.getName());
        }
        try {
            ZipDexContainer container = new ZipDexContainer(file, opcodes);
            return new DexEntryFinder(file.getPath(), container).findEntry(dexEntry, exactMatch);
        }
        catch (ZipDexContainer.NotAZipFileException container) {
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
                OatFile oatFile = null;
                try {
                    oatFile = OatFile.fromInputStream(inputStream, new FilenameVdexProvider(file));
                }
                catch (OatFile.NotAnOatFileException notAnOatFileException) {
                    // empty catch block
                }
                if (oatFile != null) {
                    if (oatFile.isSupportedVersion() == 0) {
                        throw new UnsupportedOatVersionException(oatFile);
                    }
                    List<DexBackedDexFile> oatDexFiles = oatFile.getDexFiles();
                    if (oatDexFiles.size() == 0) {
                        throw new DexFileNotFoundException("Oat file %s contains no dex files", file.getName());
                    }
                    MultiDexContainer.DexEntry<? extends DexBackedDexFile> dexEntry2 = new DexEntryFinder(file.getPath(), oatFile).findEntry(dexEntry, exactMatch);
                    return dexEntry2;
                }
            }
            throw new UnsupportedFileTypeException("%s is not an apk or oat file.", file.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static MultiDexContainer<? extends DexBackedDexFile> loadDexContainer(File file, Opcodes opcodes) throws IOException {
        block14: {
            SingletonMultiDexContainer singletonMultiDexContainer;
            if (!file.exists()) {
                throw new DexFileNotFoundException("%s does not exist", file.getName());
            }
            ZipDexContainer zipDexContainer = new ZipDexContainer(file, opcodes);
            if (zipDexContainer.isZipFile()) {
                return zipDexContainer;
            }
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                DexBackedDexFile dexFile = DexBackedDexFile.fromInputStream(opcodes, inputStream);
                singletonMultiDexContainer = new SingletonMultiDexContainer(file.getPath(), dexFile);
            }
            catch (DexBackedDexFile.NotADexFile dexFile) {
                DexBackedOdexFile odexFile2222 = DexBackedOdexFile.fromInputStream(opcodes, inputStream);
                SingletonMultiDexContainer singletonMultiDexContainer2 = new SingletonMultiDexContainer(file.getPath(), odexFile2222);
                ((InputStream)inputStream).close();
                return singletonMultiDexContainer2;
                {
                    catch (DexBackedOdexFile.NotAnOdexFile odexFile2222) {
                        try {
                            OatFile oatFile = null;
                            try {
                                oatFile = OatFile.fromInputStream(inputStream, new FilenameVdexProvider(file));
                            }
                            catch (OatFile.NotAnOatFileException notAnOatFileException) {
                                // empty catch block
                            }
                            if (oatFile != null) {
                                if (oatFile.isSupportedVersion() == 0) {
                                    throw new UnsupportedOatVersionException(oatFile);
                                }
                                OatFile oatFile2 = oatFile;
                                return oatFile2;
                            }
                            break block14;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ((InputStream)inputStream).close();
                        }
                    }
                }
            }
            ((InputStream)inputStream).close();
            return singletonMultiDexContainer;
        }
        throw new UnsupportedFileTypeException("%s is not an apk, dex, odex or oat file.", file.getPath());
    }

    private DexFileFactory() {
    }

    private static boolean fullEntryMatch(String entry, String targetEntry) {
        if (entry.equals(targetEntry)) {
            return true;
        }
        if (entry.charAt(0) == '/') {
            entry = entry.substring(1);
        }
        if (targetEntry.charAt(0) == '/') {
            targetEntry = targetEntry.substring(1);
        }
        return entry.equals(targetEntry);
    }

    private static boolean partialEntryMatch(String entry, String targetEntry) {
        if (entry.equals(targetEntry)) {
            return true;
        }
        if (!entry.endsWith(targetEntry)) {
            return false;
        }
        char precedingChar = entry.charAt(entry.length() - targetEntry.length() - 1);
        char firstTargetChar = targetEntry.charAt(0);
        return firstTargetChar == ':' || firstTargetChar == '/' || firstTargetChar == '!' || precedingChar == ':' || precedingChar == '/' || precedingChar == '!';
    }

    public static class FilenameVdexProvider
    implements OatFile.VdexProvider {
        private final File vdexFile;
        private byte[] buf = null;
        private boolean loadedVdex = false;

        public FilenameVdexProvider(File oatFile) {
            File oatParent = oatFile.getAbsoluteFile().getParentFile();
            String baseName = Files.getNameWithoutExtension(oatFile.getAbsolutePath());
            this.vdexFile = new File(oatParent, baseName + ".vdex");
        }

        @Override
        public byte[] getVdex() {
            if (!this.loadedVdex) {
                File parentDirectory;
                File candidateFile = this.vdexFile;
                if (!candidateFile.exists() && (parentDirectory = candidateFile.getParentFile().getParentFile()) != null) {
                    candidateFile = new File(parentDirectory, this.vdexFile.getName());
                }
                if (candidateFile.exists()) {
                    try {
                        this.buf = ByteStreams.toByteArray(new FileInputStream(candidateFile));
                    }
                    catch (FileNotFoundException e) {
                        this.buf = null;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                this.loadedVdex = true;
            }
            return this.buf;
        }
    }

    private static class SingletonMultiDexContainer
    implements MultiDexContainer<DexBackedDexFile> {
        private final String entryName;
        private final DexBackedDexFile dexFile;

        public SingletonMultiDexContainer(String entryName, DexBackedDexFile dexFile) {
            this.entryName = entryName;
            this.dexFile = dexFile;
        }

        @Override
        public List<String> getDexEntryNames() {
            return ImmutableList.of(this.entryName);
        }

        @Override
        public MultiDexContainer.DexEntry<DexBackedDexFile> getEntry(final String entryName) {
            if (entryName.equals(this.entryName)) {
                return new MultiDexContainer.DexEntry<DexBackedDexFile>(){

                    @Override
                    public DexBackedDexFile getDexFile() {
                        return dexFile;
                    }

                    @Override
                    public MultiDexContainer<? extends DexBackedDexFile> getContainer() {
                        return this;
                    }
                };
            }
            return null;
        }
    }

    protected static class DexEntryFinder {
        private final String filename;
        private final MultiDexContainer<? extends DexBackedDexFile> dexContainer;

        public DexEntryFinder(String filename, MultiDexContainer<? extends DexBackedDexFile> dexContainer) {
            this.filename = filename;
            this.dexContainer = dexContainer;
        }

        public MultiDexContainer.DexEntry<? extends DexBackedDexFile> findEntry(String targetEntry, boolean exactMatch) throws IOException {
            if (exactMatch) {
                try {
                    MultiDexContainer.DexEntry<? extends DexBackedDexFile> entry = this.dexContainer.getEntry(targetEntry);
                    if (entry == null) {
                        throw new DexFileNotFoundException("Could not find entry %s in %s.", targetEntry, this.filename);
                    }
                    return entry;
                }
                catch (DexBackedDexFile.NotADexFile ex) {
                    throw new UnsupportedFileTypeException("Entry %s in %s is not a dex file", targetEntry, this.filename);
                }
            }
            ArrayList<String> fullMatches = Lists.newArrayList();
            ArrayList<MultiDexContainer.DexEntry<? extends DexBackedDexFile>> fullEntries = Lists.newArrayList();
            ArrayList<String> partialMatches = Lists.newArrayList();
            ArrayList<MultiDexContainer.DexEntry<? extends DexBackedDexFile>> partialEntries = Lists.newArrayList();
            for (String entry : this.dexContainer.getDexEntryNames()) {
                MultiDexContainer.DexEntry<? extends DexBackedDexFile> dexEntry;
                if (DexFileFactory.fullEntryMatch(entry, targetEntry)) {
                    fullMatches.add(entry);
                    dexEntry = this.dexContainer.getEntry(entry);
                    assert (dexEntry != null);
                    fullEntries.add(dexEntry);
                    continue;
                }
                if (!DexFileFactory.partialEntryMatch(entry, targetEntry)) continue;
                partialMatches.add(entry);
                dexEntry = this.dexContainer.getEntry(entry);
                assert (dexEntry != null);
                partialEntries.add(dexEntry);
            }
            if (fullEntries.size() == 1) {
                try {
                    MultiDexContainer.DexEntry dexEntry = (MultiDexContainer.DexEntry)fullEntries.get(0);
                    assert (dexEntry != null);
                    return dexEntry;
                }
                catch (DexBackedDexFile.NotADexFile ex) {
                    throw new UnsupportedFileTypeException("Entry %s in %s is not a dex file", fullMatches.get(0), this.filename);
                }
            }
            if (fullEntries.size() > 1) {
                throw new MultipleMatchingDexEntriesException(String.format("Multiple entries in %s match %s: %s", this.filename, targetEntry, Joiner.on(", ").join(fullMatches)), new Object[0]);
            }
            if (partialEntries.size() == 0) {
                throw new DexFileNotFoundException("Could not find a dex entry in %s matching %s", this.filename, targetEntry);
            }
            if (partialEntries.size() > 1) {
                throw new MultipleMatchingDexEntriesException(String.format("Multiple dex entries in %s match %s: %s", this.filename, targetEntry, Joiner.on(", ").join(partialMatches)), new Object[0]);
            }
            return (MultiDexContainer.DexEntry)partialEntries.get(0);
        }
    }

    public static class UnsupportedFileTypeException
    extends ExceptionWithContext {
        public UnsupportedFileTypeException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs), new Object[0]);
        }
    }

    public static class MultipleMatchingDexEntriesException
    extends ExceptionWithContext {
        public MultipleMatchingDexEntriesException(String message, Object ... formatArgs) {
            super(String.format(message, formatArgs), new Object[0]);
        }
    }

    public static class UnsupportedOatVersionException
    extends ExceptionWithContext {
        public final OatFile oatFile;

        public UnsupportedOatVersionException(OatFile oatFile) {
            super("Unsupported oat version: %d", oatFile.getOatVersion());
            this.oatFile = oatFile;
        }
    }

    public static class DexFileNotFoundException
    extends ExceptionWithContext {
        public DexFileNotFoundException(String message, Object ... formatArgs) {
            super(message, formatArgs);
        }

        public DexFileNotFoundException(Throwable cause, String message, Object ... formatArgs) {
            super(cause, message, formatArgs);
        }
    }
}

