/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.base.reference;

import com.google.common.collect.Ordering;
import org.jf.dexlib2.base.reference.BaseReference;
import org.jf.dexlib2.formatter.DexFormatter;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.util.CharSequenceUtils;
import org.jf.util.CollectionUtils;

public abstract class BaseMethodProtoReference
extends BaseReference
implements MethodProtoReference {
    @Override
    public int hashCode() {
        int hashCode = this.getReturnType().hashCode();
        return hashCode * 31 + this.getParameterTypes().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MethodProtoReference) {
            MethodProtoReference other = (MethodProtoReference)o;
            return this.getReturnType().equals(other.getReturnType()) && CharSequenceUtils.listEquals(this.getParameterTypes(), other.getParameterTypes());
        }
        return false;
    }

    @Override
    public int compareTo(MethodProtoReference o) {
        int res = this.getReturnType().compareTo(o.getReturnType());
        if (res != 0) {
            return res;
        }
        return CollectionUtils.compareAsIterable(Ordering.usingToString(), this.getParameterTypes(), o.getParameterTypes());
    }

    public String toString() {
        return DexFormatter.INSTANCE.getMethodProtoDescriptor(this);
    }
}

