/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.List;
import java.util.Set;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedMethod;
import org.jf.dexlib2.dexbacked.DexBackedMethodImplementation;
import org.jf.dexlib2.dexbacked.DexBuffer;
import org.jf.dexlib2.dexbacked.DexReader;
import org.jf.dexlib2.dexbacked.raw.HeaderItem;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.reference.DexBackedCallSiteReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedFieldReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodHandleReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodProtoReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedMethodReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedStringReference;
import org.jf.dexlib2.dexbacked.reference.DexBackedTypeReference;
import org.jf.dexlib2.dexbacked.util.FixedSizeList;
import org.jf.dexlib2.dexbacked.util.FixedSizeSet;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.util.DexUtil;

public class DexBackedDexFile
implements DexFile {
    private final DexBuffer dexBuffer;
    private final DexBuffer dataBuffer;
    private final Opcodes opcodes;
    private final int stringCount;
    private final int stringStartOffset;
    private final int typeCount;
    private final int typeStartOffset;
    private final int protoCount;
    private final int protoStartOffset;
    private final int fieldCount;
    private final int fieldStartOffset;
    private final int methodCount;
    private final int methodStartOffset;
    private final int classCount;
    private final int classStartOffset;
    private final int mapOffset;
    private final int hiddenApiRestrictionsOffset;
    private OptionalIndexedSection<String> stringSection = new OptionalIndexedSection<String>(){

        @Override
        public String get(int index) {
            int stringOffset = this.getOffset(index);
            int stringDataOffset = DexBackedDexFile.this.dexBuffer.readSmallUint(stringOffset);
            DexReader<? extends DexBuffer> reader = DexBackedDexFile.this.dataBuffer.readerAt(stringDataOffset);
            int utf16Length = reader.readSmallUleb128();
            return reader.readString(utf16Length);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.stringCount;
        }

        @Override
        public String getOptional(int index) {
            if (index == -1) {
                return null;
            }
            return this.get(index);
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid string index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.stringStartOffset + index * 4;
        }
    };
    private OptionalIndexedSection<String> typeSection = new OptionalIndexedSection<String>(){

        @Override
        public String get(int index) {
            int typeOffset = this.getOffset(index);
            int stringIndex = DexBackedDexFile.this.dexBuffer.readSmallUint(typeOffset);
            return (String)DexBackedDexFile.this.getStringSection().get(stringIndex);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.typeCount;
        }

        @Override
        public String getOptional(int index) {
            if (index == -1) {
                return null;
            }
            return this.get(index);
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid type index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.typeStartOffset + index * 4;
        }
    };
    private IndexedSection<DexBackedFieldReference> fieldSection = new IndexedSection<DexBackedFieldReference>(){

        @Override
        public DexBackedFieldReference get(int index) {
            return new DexBackedFieldReference(DexBackedDexFile.this, index);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.fieldCount;
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid field index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.fieldStartOffset + index * 8;
        }
    };
    private IndexedSection<DexBackedMethodReference> methodSection = new IndexedSection<DexBackedMethodReference>(){

        @Override
        public DexBackedMethodReference get(int index) {
            return new DexBackedMethodReference(DexBackedDexFile.this, index);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.methodCount;
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid method index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.methodStartOffset + index * 8;
        }
    };
    private IndexedSection<DexBackedMethodProtoReference> protoSection = new IndexedSection<DexBackedMethodProtoReference>(){

        @Override
        public DexBackedMethodProtoReference get(int index) {
            return new DexBackedMethodProtoReference(DexBackedDexFile.this, index);
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.protoCount;
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid proto index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.protoStartOffset + index * 12;
        }
    };
    private IndexedSection<DexBackedClassDef> classSection = new IndexedSection<DexBackedClassDef>(){

        @Override
        public DexBackedClassDef get(int index) {
            return new DexBackedClassDef(DexBackedDexFile.this, this.getOffset(index), DexBackedDexFile.this.readHiddenApiRestrictionsOffset(index));
        }

        @Override
        public int size() {
            return DexBackedDexFile.this.classCount;
        }

        @Override
        public int getOffset(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid class index %d, not in [0, %d)", index, this.size()));
            }
            return DexBackedDexFile.this.classStartOffset + index * 32;
        }
    };
    private IndexedSection<DexBackedCallSiteReference> callSiteSection = new IndexedSection<DexBackedCallSiteReference>(){

        @Override
        public DexBackedCallSiteReference get(int index) {
            return new DexBackedCallSiteReference(DexBackedDexFile.this, index);
        }

        @Override
        public int size() {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(7);
            if (mapItem == null) {
                return 0;
            }
            return mapItem.getItemCount();
        }

        @Override
        public int getOffset(int index) {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(7);
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid callsite index %d, not in [0, %d)", index, this.size()));
            }
            return mapItem.getOffset() + index * 4;
        }
    };
    private IndexedSection<DexBackedMethodHandleReference> methodHandleSection = new IndexedSection<DexBackedMethodHandleReference>(){

        @Override
        public DexBackedMethodHandleReference get(int index) {
            return new DexBackedMethodHandleReference(DexBackedDexFile.this, index);
        }

        @Override
        public int size() {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(8);
            if (mapItem == null) {
                return 0;
            }
            return mapItem.getItemCount();
        }

        @Override
        public int getOffset(int index) {
            MapItem mapItem = DexBackedDexFile.this.getMapItemForSection(8);
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(String.format("Invalid method handle index %d, not in [0, %d)", index, this.size()));
            }
            return mapItem.getOffset() + index * 8;
        }
    };

    protected DexBackedDexFile(Opcodes opcodes, byte[] buf, int offset, boolean verifyMagic) {
        this.dexBuffer = new DexBuffer(buf, offset);
        this.dataBuffer = new DexBuffer(buf, offset + this.getBaseDataOffset());
        int dexVersion = this.getVersion(buf, offset, verifyMagic);
        this.opcodes = opcodes == null ? this.getDefaultOpcodes(dexVersion) : opcodes;
        this.stringCount = this.dexBuffer.readSmallUint(56);
        this.stringStartOffset = this.dexBuffer.readSmallUint(60);
        this.typeCount = this.dexBuffer.readSmallUint(64);
        this.typeStartOffset = this.dexBuffer.readSmallUint(68);
        this.protoCount = this.dexBuffer.readSmallUint(72);
        this.protoStartOffset = this.dexBuffer.readSmallUint(76);
        this.fieldCount = this.dexBuffer.readSmallUint(80);
        this.fieldStartOffset = this.dexBuffer.readSmallUint(84);
        this.methodCount = this.dexBuffer.readSmallUint(88);
        this.methodStartOffset = this.dexBuffer.readSmallUint(92);
        this.classCount = this.dexBuffer.readSmallUint(96);
        this.classStartOffset = this.dexBuffer.readSmallUint(100);
        this.mapOffset = this.dexBuffer.readSmallUint(52);
        MapItem mapItem = this.getMapItemForSection(61440);
        this.hiddenApiRestrictionsOffset = mapItem != null ? mapItem.getOffset() : 0;
    }

    public int getBaseDataOffset() {
        return 0;
    }

    protected int getVersion(byte[] buf, int offset, boolean verifyMagic) {
        if (verifyMagic) {
            return DexUtil.verifyDexHeader(buf, offset);
        }
        return HeaderItem.getVersion(buf, offset);
    }

    protected Opcodes getDefaultOpcodes(int version) {
        return Opcodes.forDexVersion(version);
    }

    public DexBuffer getBuffer() {
        return this.dexBuffer;
    }

    public DexBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public DexBackedDexFile(Opcodes opcodes, byte[] buf, int offset) {
        this(opcodes, buf, offset, false);
    }

    public DexBackedDexFile(Opcodes opcodes, byte[] buf) {
        this(opcodes, buf, 0, true);
    }

    public static DexBackedDexFile fromInputStream(Opcodes opcodes, InputStream is) throws IOException {
        DexUtil.verifyDexHeader(is);
        byte[] buf = ByteStreams.toByteArray(is);
        return new DexBackedDexFile(opcodes, buf, 0, false);
    }

    @Override
    public Opcodes getOpcodes() {
        return this.opcodes;
    }

    public boolean supportsOptimizedOpcodes() {
        return false;
    }

    public Set<? extends DexBackedClassDef> getClasses() {
        return new FixedSizeSet<DexBackedClassDef>(){

            @Override
            public DexBackedClassDef readItem(int index) {
                return (DexBackedClassDef)DexBackedDexFile.this.getClassSection().get(index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.classCount;
            }
        };
    }

    public List<DexBackedStringReference> getStringReferences() {
        return new AbstractList<DexBackedStringReference>(){

            @Override
            public DexBackedStringReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getStringSection().size()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedStringReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getStringSection().size();
            }
        };
    }

    public List<DexBackedTypeReference> getTypeReferences() {
        return new AbstractList<DexBackedTypeReference>(){

            @Override
            public DexBackedTypeReference get(int index) {
                if (index < 0 || index >= DexBackedDexFile.this.getTypeSection().size()) {
                    throw new IndexOutOfBoundsException();
                }
                return new DexBackedTypeReference(DexBackedDexFile.this, index);
            }

            @Override
            public int size() {
                return DexBackedDexFile.this.getTypeSection().size();
            }
        };
    }

    public List<? extends Reference> getReferences(int referenceType) {
        switch (referenceType) {
            case 0: {
                return this.getStringReferences();
            }
            case 1: {
                return this.getTypeReferences();
            }
            case 3: {
                return this.getMethodSection();
            }
            case 2: {
                return this.getFieldSection();
            }
        }
        throw new IllegalArgumentException(String.format("Invalid reference type: %d", referenceType));
    }

    public List<MapItem> getMapItems() {
        final int mapSize = this.dataBuffer.readSmallUint(this.mapOffset);
        return new FixedSizeList<MapItem>(){

            @Override
            public MapItem readItem(int index) {
                int mapItemOffset = DexBackedDexFile.this.mapOffset + 4 + index * 12;
                return new MapItem(DexBackedDexFile.this, mapItemOffset);
            }

            @Override
            public int size() {
                return mapSize;
            }
        };
    }

    public MapItem getMapItemForSection(int itemType) {
        for (MapItem mapItem : this.getMapItems()) {
            if (mapItem.getType() != itemType) continue;
            return mapItem;
        }
        return null;
    }

    public OptionalIndexedSection<String> getStringSection() {
        return this.stringSection;
    }

    public OptionalIndexedSection<String> getTypeSection() {
        return this.typeSection;
    }

    public IndexedSection<DexBackedFieldReference> getFieldSection() {
        return this.fieldSection;
    }

    public IndexedSection<DexBackedMethodReference> getMethodSection() {
        return this.methodSection;
    }

    public IndexedSection<DexBackedMethodProtoReference> getProtoSection() {
        return this.protoSection;
    }

    public IndexedSection<DexBackedClassDef> getClassSection() {
        return this.classSection;
    }

    public IndexedSection<DexBackedCallSiteReference> getCallSiteSection() {
        return this.callSiteSection;
    }

    public IndexedSection<DexBackedMethodHandleReference> getMethodHandleSection() {
        return this.methodHandleSection;
    }

    protected DexBackedMethodImplementation createMethodImplementation(DexBackedDexFile dexFile, DexBackedMethod method, int codeOffset) {
        return new DexBackedMethodImplementation(dexFile, method, codeOffset);
    }

    private int readHiddenApiRestrictionsOffset(int classIndex) {
        if (this.hiddenApiRestrictionsOffset == 0) {
            return 0;
        }
        int offset = this.dexBuffer.readInt(this.hiddenApiRestrictionsOffset + 4 + classIndex * 4);
        if (offset == 0) {
            return 0;
        }
        return this.hiddenApiRestrictionsOffset + offset;
    }

    public static abstract class IndexedSection<T>
    extends AbstractList<T> {
        public abstract int getOffset(int var1);
    }

    public static abstract class OptionalIndexedSection<T>
    extends IndexedSection<T> {
        public abstract T getOptional(int var1);
    }

    public static class NotADexFile
    extends RuntimeException {
        public NotADexFile() {
        }

        public NotADexFile(String message) {
            super(message);
        }
    }
}

