/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.dexbacked.raw.AnnotationItem;
import org.jf.dexlib2.dexbacked.raw.MapItem;
import org.jf.dexlib2.dexbacked.raw.SectionAnnotator;
import org.jf.dexlib2.dexbacked.raw.util.DexAnnotator;
import org.jf.dexlib2.util.AnnotatedBytes;

public class AnnotationSetItem {
    public static SectionAnnotator makeAnnotator(DexAnnotator annotator, MapItem mapItem) {
        return new SectionAnnotator(annotator, mapItem){

            @Override
            public String getItemName() {
                return "annotation_set_item";
            }

            @Override
            public void annotateItem(AnnotatedBytes out, int itemIndex, String itemIdentity) {
                int size = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                out.annotate(4, "size = %d", size);
                for (int i = 0; i < size; ++i) {
                    int annotationOffset = this.dexFile.getBuffer().readSmallUint(out.getCursor());
                    out.annotate(4, AnnotationItem.getReferenceAnnotation(this.dexFile, annotationOffset), new Object[0]);
                }
            }

            @Override
            public int getItemAlignment() {
                return 4;
            }
        };
    }

    public static String getReferenceAnnotation(DexBackedDexFile dexFile, int annotationSetOffset) {
        if (annotationSetOffset == 0) {
            return "annotation_set_item[NO_OFFSET]";
        }
        return String.format("annotation_set_item[0x%x]", annotationSetOffset);
    }
}

