/*
 * Decompiled with CFR 0.152.
 */
package android.util;

public class TypedValue {
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNIT_STRS = new String[]{"px", "dip", "sp", "pt", "in", "mm"};
    private static final String[] FRACTION_UNIT_STRS = new String[]{"%", "%p"};

    public static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }

    public static final String coerceToString(int type, int data) {
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return "@" + data;
            }
            case 2: {
                return "?" + data;
            }
            case 4: {
                return Float.toString(Float.intBitsToFloat(data));
            }
            case 5: {
                return Float.toString(TypedValue.complexToFloat(data)) + DIMENSION_UNIT_STRS[data >> 0 & 0xF];
            }
            case 6: {
                return Float.toString(TypedValue.complexToFloat(data) * 100.0f) + FRACTION_UNIT_STRS[data >> 0 & 0xF];
            }
            case 17: {
                return String.format("0x%08X", data);
            }
            case 18: {
                return data != 0 ? "true" : "false";
            }
        }
        if (type >= 28 && type <= 31) {
            String res = String.format("%08x", data);
            char[] vals = res.toCharArray();
            switch (type) {
                default: {
                    break;
                }
                case 29: {
                    res = res.substring(2);
                    break;
                }
                case 30: {
                    res = new StringBuffer().append(vals[0]).append(vals[2]).append(vals[4]).append(vals[6]).toString();
                    break;
                }
                case 31: {
                    res = new StringBuffer().append(vals[2]).append(vals[4]).append(vals[6]).toString();
                }
            }
            return "#" + res;
        }
        if (type >= 16 && type <= 31) {
            switch (type) {
                default: 
            }
            String res = Integer.toString(data);
            return res;
        }
        return null;
    }
}

