/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResTable;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ResTypeSpec {
    private final String mName;
    private final Map<String, ResResSpec> mResSpecs = new LinkedHashMap<String, ResResSpec>();
    private final ResTable mResTable;
    private final ResPackage mPackage;
    private final int mId;
    private final int mEntryCount;

    public ResTypeSpec(String name, ResTable resTable, ResPackage package_, int id, int entryCount) {
        this.mName = name;
        this.mResTable = resTable;
        this.mPackage = package_;
        this.mId = id;
        this.mEntryCount = entryCount;
    }

    public String getName() {
        return this.mName;
    }

    public int getId() {
        return this.mId;
    }

    public boolean isString() {
        return this.mName.equalsIgnoreCase("string");
    }

    public ResResSpec getResSpecUnsafe(String name) {
        return this.mResSpecs.get(name);
    }

    public void removeResSpec(ResResSpec spec) throws AndrolibException {
        this.mResSpecs.remove(spec.getName());
    }

    public void addResSpec(ResResSpec spec) throws AndrolibException {
        if (this.mResSpecs.put(spec.getName(), spec) != null) {
            throw new AndrolibException(String.format("Multiple res specs: %s/%s", this.getName(), spec.getName()));
        }
    }

    public String toString() {
        return this.mName;
    }
}

