/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.value.ResIdValue;
import brut.androlib.res.data.value.ResIntValue;

public class ResReferenceValue
extends ResIntValue {
    private final ResPackage mPackage;
    private final boolean mTheme;

    public ResReferenceValue(ResPackage package_, int value, String rawValue) {
        this(package_, value, rawValue, false);
    }

    public ResReferenceValue(ResPackage package_, int value, String rawValue, boolean theme) {
        super(value, rawValue, "reference");
        this.mPackage = package_;
        this.mTheme = theme;
    }

    @Override
    protected String encodeAsResXml() throws AndrolibException {
        if (this.isNull()) {
            return "@null";
        }
        ResResSpec spec = this.getReferent();
        if (spec == null) {
            return "@null";
        }
        boolean newId = spec.hasDefaultResource() && spec.getDefaultResource().getValue() instanceof ResIdValue;
        String mStart = (this.mTheme ? (char)'?' : '@') + (newId ? "+" : "");
        return mStart + spec.getFullName(this.mPackage, this.mTheme && spec.getType().getName().equals("attr"));
    }

    public ResResSpec getReferent() throws AndrolibException {
        try {
            return this.mPackage.getResTable().getResSpec(this.getValue());
        }
        catch (UndefinedResObject ex) {
            return null;
        }
    }

    public boolean isNull() {
        return this.mValue == 0;
    }

    public boolean referentIsNull() throws AndrolibException {
        return this.getReferent() == null;
    }
}

