/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import com.natamus.collective.config.ConfigHandler;
import com.natamus.collective.data.GlobalVariables;
import com.natamus.collective.functions.BlockFunctions;
import com.natamus.collective.functions.ToolFunctions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemFunctions {
    public static void generateEntityDropsFromLootTable(Level world) {
        MinecraftServer server = world.m_142572_();
        if (server == null) {
            return;
        }
        GlobalVariables.entitydrops = new HashMap();
        FakePlayer fakeplayer = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world));
        Vec3 vec = new Vec3(0.0, 0.0, 0.0);
        ItemStack lootingsword = new ItemStack((ItemLike)Items.f_42388_, 1);
        lootingsword.m_41663_(Enchantments.f_44982_, 10);
        fakeplayer.m_8061_(EquipmentSlot.MAINHAND, lootingsword);
        Collection entitytypes = ForgeRegistries.ENTITIES.getValues();
        for (EntityType type : entitytypes) {
            Entity entity;
            if (type == null || (entity = type.m_20615_(world)) == null || !(entity instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)entity;
            ResourceLocation lootlocation = le.m_6095_().m_20677_();
            LootTable loottable = server.m_129898_().m_79217_(lootlocation);
            LootContext context = new LootContext.Builder((ServerLevel)world).m_78977_(world.m_5822_()).m_78963_(1000000.0f).m_78972_(LootContextParams.f_81455_, (Object)entity).m_78972_(LootContextParams.f_81460_, (Object)vec).m_78972_(LootContextParams.f_81458_, (Object)fakeplayer).m_78972_(LootContextParams.f_81457_, (Object)DamageSource.m_19344_((Player)fakeplayer)).m_78975_(LootContextParamSets.f_81415_);
            ArrayList<Item> alldrops = new ArrayList<Item>();
            for (int n = 0; n < (Integer)ConfigHandler.COLLECTIVE.loopsAmountUsedToGetAllEntityDrops.get(); ++n) {
                List newdrops = loottable.m_79129_(context);
                for (ItemStack newdrop : newdrops) {
                    Item newitem = newdrop.m_41720_();
                    if (alldrops.contains(newitem) || newitem.equals(Items.f_41852_)) continue;
                    alldrops.add(newitem);
                }
            }
            GlobalVariables.entitydrops.put(type, alldrops);
        }
    }

    public static Boolean isTool(ItemStack itemstack) {
        return ToolFunctions.isTool(itemstack);
    }

    public static void shrinkGiveOrDropItemStack(Player player, InteractionHand hand, ItemStack used, ItemStack give) {
        used.m_41774_(1);
        if (used.m_41619_()) {
            Item giveitem = give.m_41720_();
            int maxstacksize = give.m_41741_();
            NonNullList inventory = player.m_150109_().f_35974_;
            boolean increased = false;
            for (int n = 0; n < inventory.size(); ++n) {
                int slotcount;
                ItemStack slot = (ItemStack)inventory.get(n);
                if (!slot.m_41720_().equals(giveitem) || (slotcount = slot.m_41613_()) >= maxstacksize) continue;
                slot.m_41764_(slotcount + 1);
                increased = true;
                break;
            }
            if (!increased) {
                player.m_21008_(hand, give);
            }
        } else if (!player.m_150109_().m_36054_(give)) {
            player.m_36176_(give, false);
        }
    }

    public static void giveOrDropItemStack(Player player, ItemStack give) {
        if (!player.m_150109_().m_36054_(give)) {
            player.m_36176_(give, false);
        }
    }

    public static boolean isStoneTypeItem(Item item) {
        return GlobalVariables.stoneblockitems.contains(item);
    }

    public static String itemToReadableString(Item item, int amount) {
        Object itemstring = "";
        String translationkey = item.m_5524_();
        if (translationkey.contains("block.")) {
            return BlockFunctions.blockToReadableString(Block.m_49814_((Item)item), amount);
        }
        String[] itemspl = translationkey.replace("item.", "").split("\\.");
        itemstring = itemspl.length > 1 ? itemspl[1] : itemspl[0];
        itemstring = ((String)itemstring).replace("_", " ");
        if (amount > 1) {
            itemstring = (String)itemstring + "s";
        }
        return itemstring;
    }

    public static String itemToReadableString(Item item) {
        return ItemFunctions.itemToReadableString(item, 1);
    }
}

