/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.functions;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.LevelResource;

public class WorldFunctions {
    public static void setWorldTime(ServerLevel ServerLevel2, Integer time) {
        if (time < 0 || time > 24000) {
            return;
        }
        Integer days = WorldFunctions.getTotalDaysPassed(ServerLevel2);
        ServerLevel2.m_8615_((long)(time + days * 24000));
    }

    public static int getTotalTimePassed(ServerLevel ServerLevel2) {
        return (int)ServerLevel2.m_46468_();
    }

    public static int getTotalDaysPassed(ServerLevel ServerLevel2) {
        Integer currenttime = WorldFunctions.getTotalTimePassed(ServerLevel2);
        Integer days = (int)Math.floor((double)currenttime.intValue() / 24000.0);
        return days;
    }

    public static int getWorldTime(ServerLevel ServerLevel2) {
        return WorldFunctions.getTotalTimePassed(ServerLevel2) - WorldFunctions.getTotalDaysPassed(ServerLevel2) * 24000;
    }

    public static String getWorldDimensionName(Level world) {
        return world.m_46472_().m_135782_().toString();
    }

    public static boolean isOverworld(Level world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("overworld");
    }

    public static boolean isNether(Level world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("nether");
    }

    public static boolean isEnd(Level world) {
        return WorldFunctions.getWorldDimensionName(world).toLowerCase().endsWith("end");
    }

    public static Level getWorldIfInstanceOfAndNotRemote(LevelAccessor iworld) {
        if (iworld.m_5776_()) {
            return null;
        }
        if (iworld instanceof Level) {
            return (Level)iworld;
        }
        return null;
    }

    public static String getWorldPath(ServerLevel ServerLevel2) {
        String worldpath = ServerLevel2.m_142572_().m_129843_(LevelResource.f_78182_).toString();
        return worldpath.substring(0, worldpath.length() - 2);
    }
}

