from mathutils import Vector, Euler, Matrix

coords={
    'pelvis': Vector((1.1648752433757181e-06, -0.03546452522277832, 9.705429077148438)), 'spine_01': Vector((2.2932558749744203e-06, 0.6045663356781006, 19.095504760742188)), 'spine_02': Vector((1.5992075077519985e-06, 1.5650908946990967, 13.322303771972656)), 'spine_03': Vector((1.661253463680623e-06, 2.3110668659210205, 13.840438842773438)), 'clavicle_l': Vector((13.918235778808594, 6.9506120681762695, -2.6709747314453125)), 'upperarm_l': Vector((9.943408966064453, 1.1179428100585938, -11.732620239257812)), 'lowerarm_l': Vector((14.720138549804688, -8.791529655456543, -11.214599609375)), 'hand_l': Vector((7.418285369873047, -4.771677017211914, -6.2159423828125)), 'index_01_l': Vector((1.6297721862792969, -1.3284335136413574, -3.7365493774414062)), 'index_02_l': Vector((0.764068603515625, -0.6675519943237305, -3.23858642578125)), 'index_03_l': Vector((1.1548080444335938, -1.0154056549072266, -3.0254287719726562)), 'middle_01_l': Vector((2.0407943725585938, -1.2454519271850586, -3.977081298828125)), 'middle_02_l': Vector((0.9041290283203125, -0.8172664642333984, -3.4392852783203125)), 'middle_03_l': Vector((1.8407974243164062, -0.799962043762207, -3.0472183227539062)), 'pinky_01_l': Vector((1.9121170043945312, -0.28551551699638367, -3.0023727416992188)), 'pinky_02_l': Vector((1.0753021240234375, -0.2280139923095703, -2.7759170532226562)), 'pinky_03_l': Vector((1.03009033203125, -0.43166860938072205, -2.76885986328125)), 'ring_01_l': Vector((2.0166549682617188, -0.8928370475769043, -3.8422012329101562)), 'ring_02_l': Vector((0.841827392578125, -0.5747072696685791, -3.3238754272460938)), 'ring_03_l': Vector((1.549285888671875, -0.7849781513214111, -3.011749267578125)), 'thumb_01_l': Vector((0.12947463989257812, -3.2002079486846924, -2.171722412109375)), 'thumb_02_l': Vector((0.1767120361328125, -2.4893083572387695, -3.2051925659179688)), 'thumb_03_l': Vector((-0.3583641052246094, -2.9913997650146484, -2.7247543334960938)), 'clavicle_r': Vector((-13.918163299560547, 6.9505720138549805, -2.67095947265625)), 'upperarm_r': Vector((-9.943452835083008, 1.1179475784301758, -11.732650756835938)), 'lowerarm_r': Vector((-14.720176696777344, -8.79155445098877, -11.214614868164062)), 'hand_r': Vector((-7.418270111083984, -4.771677017211914, -6.215934753417969)), 'index_01_r': Vector((-1.6298408508300781, -1.3284940719604492, -3.7367095947265625)), 'index_02_r': Vector((-0.764068603515625, -0.6675558090209961, -3.23858642578125)), 'index_03_r': Vector((-1.154815673828125, -1.0154085159301758, -3.0254364013671875)), 'middle_01_r': Vector((-2.0408782958984375, -1.2455048561096191, -3.9772415161132812)), 'middle_02_r': Vector((-0.9041519165039062, -0.8172807693481445, -3.4393463134765625)), 'middle_03_r': Vector((-1.840850830078125, -0.7999820709228516, -3.0472640991210938)), 'pinky_01_r': Vector((-1.9121551513671875, -0.2855238914489746, -3.00244140625)), 'pinky_02_r': Vector((-1.075225830078125, -0.22799871861934662, -2.7757110595703125)), 'pinky_03_r': Vector((-1.0300140380859375, -0.43163785338401794, -2.768646240234375)), 'ring_01_r': Vector((-2.016510009765625, -0.8927762508392334, -3.8419265747070312)), 'ring_02_r': Vector((-0.8418350219726562, -0.5747084617614746, -3.3238754272460938)), 'ring_03_r': Vector((-1.549346923828125, -0.7849829196929932, -3.0117340087890625)), 'thumb_01_r': Vector((-0.12947463989257812, -3.200113534927368, -2.1716537475585938)), 'thumb_02_r': Vector((-0.17670440673828125, -2.489307403564453, -3.2052078247070312)), 'thumb_03_r': Vector((0.3583488464355469, -2.9914073944091797, -2.7247467041015625)), 'neck_01': Vector((1.0827247933775652e-06, -2.252087116241455, 9.013656616210938)), 'head': Vector((1.1142928997287527e-06, 0.2140827178955078, 16.578201293945312)), 'thigh_l': Vector((3.9585037231445312, 0.9658896923065186, -32.07537841796875)), 'calf_l': Vector((2.157259941101074, 4.733462333679199, -29.887414932250977)), 'foot_l': Vector((0.8955478668212891, -19.57691764831543, -0.23760986328125)), 'thigh_r': Vector((-3.958521842956543, 0.9658963084220886, -32.075477600097656)), 'calf_r': Vector((-2.157278060913086, 4.7334885597229, -29.887554168701172)), 'foot_r': Vector((-0.8955459594726562, -19.576862335205078, -0.23760986328125))}         

matrix_coords = {
    'pelvis': Matrix(((1.0, 1.6488743881382106e-07, 1.1779484054841305e-07, 2.9802464496242465e-08),                                                                                                              (1.1839658498047356e-07, -0.0036541179288178682, -0.9999933242797852, 0.033642228692770004),                                                                                                           (-1.6445591199953924e-07, 0.9999933242797852, -0.003654122119769454, 3.0818512439727783),                                                                                                              (0.0, 0.0, 0.0, 1.0))), 'spine_01': Matrix(((1.0, 1.6357645904463425e-07, 9.723312643927784e-08, -5.690844204764289e-07),                                                                              (1.1739510341612913e-07, -0.12815892696380615, -0.9917536377906799, 0.005264334846287966),                                                                                                             (-1.4976629358898208e-07, 0.9917535781860352, -0.12815892696380615, 3.426046133041382),                                                                                                                (0.0, 0.0, 0.0, 1.0))), 'spine_02': Matrix(((1.0, 1.6371627964417712e-07, 1.3765824746769795e-07, -1.1853769592562458e-06),                                                                            (1.1761618878836089e-07, 0.11667659133672714, -0.9931699633598328, 0.04829178750514984),                                                                                                               (-1.786596186548195e-07, 0.993169903755188, 0.11667657643556595, 4.037858486175537),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'spine_03': Matrix(((1.0000001192092896, 1.5512173945353425e-07, 1.455832716601435e-07, -1.0244309578411048e-07),                                                              (1.1804679900251358e-07, 0.1646990180015564, -0.9863439202308655, 0.11142235994338989),                                                                                                                (-1.7698083354389382e-07, 0.9863439798355103, 0.164698988199234, 4.460445404052734),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'clavicle_l': Matrix(((0.4467737078666687, 0.8817452192306519, 0.15139062702655792, 0.12046664208173752),                                                                      (-0.8946471214294434, 0.4403337836265564, 0.07558471709489822, 0.08792895078659058),                                                                                                                   (-1.603568671271205e-05, -0.16921041905879974, 0.9855800867080688, 4.848139762878418),                                                                                                                 (0.0, 0.0, 0.0, 1.0))), 'upperarm_l': Matrix(((0.06804918497800827, 0.6448394656181335, 0.7612831592559814, 0.5638118386268616),                                                                       (-0.9969836473464966, 0.07249976694583893, 0.02770778350532055, 0.30933064222335815),                                                                                                                  (-0.03732582926750183, -0.7608720660209656, 0.6478278040885925, 4.763060092926025),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'lowerarm_l': Matrix(((-0.22621221840381622, 0.71849125623703, 0.6577226519584656, 1.1870087385177612),                                                                        (-0.8883805871009827, -0.42911502718925476, 0.16321951150894165, 0.3794020414352417),                                                                                                                  (0.3995102345943451, -0.5473854541778564, 0.7353646159172058, 4.027731895446777),                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'hand_l': Matrix(((-0.38722580671310425, 0.6874744892120361, 0.6143580675125122, 1.8043731451034546),                                                                          (-0.8942700624465942, -0.4422052800655365, -0.06881863623857498, 0.010679176077246666),                                                                                                                (0.2243610918521881, -0.5760500431060791, 0.7860210537910461, 3.557389259338379),                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'index_01_l': Matrix(((-0.5691731572151184, 0.38011959195137024, 0.729076087474823, 2.008119821548462),                                                                        (-0.8210588693618774, -0.30983832478523254, -0.4794405400753021, -0.21552908420562744),                                                                                                                (0.04365073889493942, -0.8714983463287354, 0.4884522557258606, 3.3068642616271973),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'index_02_l': Matrix(((-0.5856645703315735, 0.22513845562934875, 0.7786597013473511, 2.0600335597991943),                                                                      (-0.8100426197052002, -0.19669795036315918, -0.5523962378501892, -0.25784435868263245),                                                                                                                (0.0287949126213789, -0.9542656540870667, 0.29757097363471985, 3.1878418922424316),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'index_03_l': Matrix(((-0.6060661673545837, 0.3402695059776306, 0.7189587950706482, 2.084372043609619),                                                                        (-0.7946285605430603, -0.2991945743560791, -0.5282506346702576, -0.27910828590393066),                                                                                                                 (0.03536073490977287, -0.8914593458175659, 0.45171964168548584, 3.084681510925293),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'middle_01_l': Matrix(((-0.36354056000709534, 0.4397897720336914, 0.8212333917617798, 2.054241418838501),                                                                      (-0.9258246421813965, -0.2683941423892975, -0.2661089301109314, -0.1426842212677002),                                                                                                                  (0.10338205844163895, -0.857059121131897, 0.504740297794342, 3.2962303161621094),                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'middle_02_l': Matrix(((-0.33663398027420044, 0.24778583645820618, 0.9084493517875671, 2.1192479133605957),                                                                    (-0.9321932792663574, -0.2239796668291092, -0.2843400537967682, -0.18235629796981812),                                                                                                                 (0.1330185979604721, -0.9425687789916992, 0.30638349056243896, 3.169546127319336),                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'middle_03_l': Matrix(((-0.3099201023578644, 0.5044875741004944, 0.805880069732666, 2.148047685623169),                                                                        (-0.9487493634223938, -0.21923768520355225, -0.2276187539100647, -0.20838911831378937),                                                                                                                (0.061848320066928864, -0.8351214528083801, 0.5465784072875977, 3.059992790222168),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'pinky_01_l': Matrix(((0.04751276597380638, 0.5354591608047485, 0.8432242274284363, 2.0394299030303955),                                                                       (-0.9910807013511658, -0.07995407283306122, 0.10661635547876358, 0.00506576057523489),                                                                                                                 (0.1245078295469284, -0.8407682180404663, 0.5268844962120056, 3.281456708908081),                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'pinky_02_l': Matrix(((0.03849964588880539, 0.3601591885089874, 0.9320963621139526, 2.1003365516662598),                                                                       (-0.9945776462554932, -0.07637055963277817, 0.07059013843536377, -0.004032180178910494),                                                                                                               (0.09660836309194565, -0.929759681224823, 0.3552663326263428, 3.1858248710632324),                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'pinky_03_l': Matrix(((0.007947893813252449, 0.34501662850379944, 0.9385631084442139, 2.1345880031585693),                                                                     (-0.9875791668891907, -0.14458194375038147, 0.0615118108689785, -0.011299255304038525),                                                                                                                (0.1569218635559082, -0.9273940324783325, 0.3395823836326599, 3.097403049468994),                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'ring_01_l': Matrix(((-0.10225814580917358, 0.45520704984664917, 0.8844945430755615, 2.056964159011841),                                                                       (-0.979435384273529, -0.20153452455997467, -0.009513932280242443, -0.0663369745016098),                                                                                                                (0.1739252358675003, -0.8672777414321899, 0.46645453572273254, 3.282154083251953),                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'ring_02_l': Matrix(((-0.10031932592391968, 0.2421373873949051, 0.965041995048523, 2.121201753616333),                                                                         (-0.9843636751174927, -0.16530486941337585, -0.06085115298628807, -0.09477698802947998),                                                                                                               (0.14479169249534607, -0.9560565948486328, 0.2549346685409546, 3.15976619720459),                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'ring_03_l': Matrix(((-0.11813032627105713, 0.44562584161758423, 0.8873910903930664, 2.148016929626465),                                                                       (-0.9740409255027771, -0.22578558325767517, -0.016280973330140114, -0.11308345198631287),                                                                                                              (0.1931048333644867, -0.8662784695625305, 0.4607301652431488, 3.053889036178589),                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'thumb_01_l': Matrix(((-0.8114522695541382, 0.03345802053809166, -0.5834610462188721, 1.8308699131011963),                                                                     (0.3053358793258667, -0.826994001865387, -0.47207149863243103, -0.12348103523254395),                                                                                                                  (-0.4983132481575012, -0.5612149834632874, 0.6608496904373169, 3.428670644760132),                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'thumb_02_l': Matrix(((-0.81514972448349, 0.04350228235125542, -0.5776150822639465, 1.8349940776824951),                                                                       (0.43485164642333984, -0.6128039956092834, -0.6598301529884338, -0.22541898488998413),                                                                                                                 (-0.3826688230037689, -0.7890373468399048, 0.4806095063686371, 3.3594934940338135),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'thumb_03_l': Matrix(((-0.7895572185516357, -0.08822077512741089, -0.6073035001754761, 1.8406339883804321),                                                                    (0.46224889159202576, -0.736406147480011, -0.49399662017822266, -0.3047146797180176),                                                                                                                  (-0.40364113450050354, -0.6707640886306763, 0.6222143173217773, 3.2573835849761963),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'lowerarm_twist_01_l': Matrix(((-0.22621247172355652, 0.7184913754463196, 0.6577224731445312, 1.5074182748794556),                                                             (-0.8883807063102722, -0.42911508679389954, 0.16321931779384613, 0.1880360245704651),                                                                                                                  (0.39951011538505554, -0.5473853349685669, 0.7353647947311401, 3.7836267948150635),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'upperarm_twist_01_l': Matrix(((0.06804939359426498, 0.6448401212692261, 0.7612826228141785, 0.5740784406661987),                                                              (-0.996983528137207, 0.07249986380338669, 0.02770795114338398, 0.31048622727394104),                                                                                                                   (-0.03732573240995407, -0.7608715295791626, 0.6478284597396851, 4.750943183898926),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'clavicle_r': Matrix(((0.44677361845970154, -0.8817451596260071, -0.1513901650905609, -0.12046878039836884),                                                                   (0.8946468830108643, 0.44033345580101013, 0.07558493316173553, 0.08792933821678162),                                                                                                                   (1.5580799299641512e-05, -0.16921016573905945, 0.9855800271034241, 4.848147869110107),                                                                                                                 (0.0, 0.0, 0.0, 1.0))), 'upperarm_r': Matrix(((0.06804890185594559, -0.644839882850647, -0.7612823247909546, -0.5638118386268616),                                                                     (0.9969833493232727, 0.0724998190999031, 0.027707066386938095, 0.3093298077583313),                                                                                                                    (0.03732629492878914, -0.7608714699745178, 0.647828221321106, 4.763068675994873),                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'lowerarm_r': Matrix(((-0.2262125015258789, -0.71849125623703, -0.6577220559120178, -1.1870065927505493),                                                                      (0.8883800506591797, -0.4291154146194458, 0.16321955621242523, 0.3794037401676178),                                                                                                                    (-0.3995105028152466, -0.547385036945343, 0.7353647351264954, 4.027737617492676),                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'hand_r': Matrix(((-0.38722583651542664, -0.6874740719795227, -0.6143580675125122, -1.8043839931488037),                                                                       (0.8942697048187256, -0.44220563769340515, -0.0688185915350914, 0.010687652975320816),                                                                                                                 (-0.22436153888702393, -0.5760501623153687, 0.786020815372467, 3.557386875152588),                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'index_01_r': Matrix(((-0.5691713690757751, -0.38012054562568665, -0.7290763258934021, -2.008120059967041),                                                                    (0.8210593461990356, -0.3098391592502594, -0.47943827509880066, -0.21551606059074402),                                                                                                                 (-0.04365191608667374, -0.8714976906776428, 0.48845332860946655, 3.3068623542785645),                                                                                                                  (0.0, 0.0, 0.0, 1.0))), 'index_02_r': Matrix(((-0.5856637358665466, -0.22513791918754578, -0.7786596417427063, -2.06003475189209),                                                                     (0.8100423216819763, -0.19669796526432037, -0.5523957014083862, -0.25785180926322937),                                                                                                                 (-0.02879541553556919, -0.9542656540870667, 0.2975703775882721, 3.1878323554992676),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'index_03_r': Matrix(((-0.6060664057731628, -0.3402706980705261, -0.7189571261405945, -2.0843844413757324),                                                                    (0.7946276068687439, -0.2991943061351776, -0.5282512307167053, -0.2791060209274292),                                                                                                                   (-0.03535931184887886, -0.8914586901664734, 0.45172035694122314, 3.084672212600708),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'middle_01_r': Matrix(((-0.363539457321167, -0.43979117274284363, -0.821232795715332, -2.054241180419922),                                                                     (0.9258247017860413, -0.26839444041252136, -0.2661075294017792, -0.14266574382781982),                                                                                                                 (-0.10338248312473297, -0.8570582270622253, 0.5047416090965271, 3.2962398529052734),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'middle_02_r': Matrix(((-0.3366393744945526, -0.24778705835342407, -0.9084470272064209, -2.1192402839660645),                                                                  (0.9321916103363037, -0.2239791452884674, -0.284345805644989, -0.18235494196414948),                                                                                                                   (-0.13301590085029602, -0.9425686001777649, 0.306385338306427, 3.1695480346679688),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'middle_03_r': Matrix(((-0.30992555618286133, -0.5044938325881958, -0.8058741092681885, -2.148040771484375),                                                                   (0.9487476348876953, -0.21923883259296417, -0.22762414813041687, -0.20838822424411774),                                                                                                                (-0.06184384599328041, -0.8351173996925354, 0.546585202217102, 3.059992551803589),                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'pinky_01_r': Matrix(((0.04751405119895935, -0.535459041595459, -0.8432238101959229, -2.039423942565918),                                                                      (0.9910801649093628, -0.07995471358299255, 0.10661811381578445, 0.00507327588275075),                                                                                                                  (-0.12450934201478958, -0.8407681584358215, 0.5268840193748474, 3.2814626693725586),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'pinky_02_r': Matrix(((0.03849875554442406, -0.3601601719856262, -0.9320958852767944, -2.1003241539001465),                                                                    (0.9945777654647827, -0.07637074589729309, 0.07058922201395035, -0.004011473618447781),                                                                                                                (-0.09660828858613968, -0.9297593235969543, 0.3552672266960144, 3.185828685760498),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'pinky_03_r': Matrix(((0.007947093807160854, -0.34501829743385315, -0.938562273979187, -2.134589672088623),                                                                    (0.9875790476799011, -0.14458265900611877, 0.061511389911174774, -0.011281827464699745),                                                                                                               (-0.15692244470119476, -0.9273931980133057, 0.3395839333534241, 3.097404718399048),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'ring_01_r': Matrix(((-0.10225774347782135, -0.455207496881485, -0.8844940066337585, -2.056968927383423),                                                                      (0.9794349670410156, -0.2015351504087448, -0.009513212367892265, -0.06632989645004272),                                                                                                                (-0.17392610013484955, -0.8672773838043213, 0.4664548933506012, 3.282148599624634),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'ring_02_r': Matrix(((-0.10032199323177338, -0.24213935434818268, -0.9650408029556274, -2.121198892593384),                                                                    (0.9843631982803345, -0.1653049737215042, -0.060853682458400726, -0.09476785361766815),                                                                                                                (-0.14479096233844757, -0.9560562372207642, 0.2549367845058441, 3.1597771644592285),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'ring_03_r': Matrix(((-0.11814981698989868, -0.44564124941825867, -0.8873806595802307, -2.1480143070220947),                                                                   (0.9740406274795532, -0.22578608989715576, -0.016298456117510796, -0.11307433247566223),                                                                                                               (-0.19309496879577637, -0.8662708401679993, 0.4607493579387665, 3.0539000034332275),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'thumb_01_r': Matrix(((-0.8114495277404785, -0.033459171652793884, 0.5834640264511108, -1.8308833837509155),                                                                   (-0.30533674359321594, -0.8269941210746765, -0.4720701277256012, -0.12347253412008286),                                                                                                                (0.4983166456222534, -0.5612141489982605, 0.6608477234840393, 3.4286727905273438),                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'thumb_02_r': Matrix(((-0.815152108669281, -0.04349927231669426, 0.5776113867759705, -1.8350025415420532),                                                                     (-0.4348512291908264, -0.6128020286560059, -0.6598317623138428, -0.22540561854839325),                                                                                                                 (0.38266393542289734, -0.7890384197235107, 0.4806112051010132, 3.3594961166381836),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'thumb_03_r': Matrix(((-0.7895523309707642, 0.08821609616279602, 0.6073097586631775, -1.840631127357483),                                                                      (-0.462249219417572, -0.7364076972007751, -0.4939930737018585, -0.3046988844871521),                                                                                                                   (0.40364983677864075, -0.6707620620727539, 0.6222102046012878, 3.257398843765259),                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'lowerarm_twist_01_r': Matrix(((-0.0662948489189148, -0.7184913158416748, -0.6923694610595703, -1.5074169635772705),                                                           (0.8256651163101196, -0.4291154742240906, 0.36624735593795776, 0.18803870677947998),                                                                                                                   (-0.5602519512176514, -0.5473850965499878, 0.6216815114021301, 3.783622980117798),                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'upperarm_twist_01_r': Matrix(((0.3237384259700775, -0.6448400020599365, -0.6923688650131226, -0.5740744471549988),                                                            (0.9276887774467468, 0.07249946147203445, 0.3662470579147339, 0.31048285961151123),                                                                                                                    (-0.18597427010536194, -0.7608713507652283, 0.6216818690299988, 4.750955104827881),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'neck_01': Matrix(((1.000000238418579, 1.681314216739338e-07, -3.7881150660723506e-08, 2.7830087674374226e-06),                                                                (4.003895881510289e-09, -0.2424011081457138, -0.9701761603355408, 0.1871279776096344),                                                                                                                 (-1.7229959325959499e-07, 0.9701762199401855, -0.2424011528491974, 4.982570648193359),                                                                                                                 (0.0, 0.0, 0.0, 1.0))), 'head': Matrix(((1.000000238418579, 1.569277259250157e-07, 7.995011763739512e-09, -2.7994865376967937e-06),                                                                    (4.376929041427502e-09, 0.023042455315589905, -0.9997345209121704, 0.12670011818408966),                                                                                                               (-1.5707034606293746e-07, 0.99973464012146, 0.023042425513267517, 5.272284030914307),                                                                                                                  (0.0, 0.0, 0.0, 1.0))), 'thigh_l': Matrix(((0.14777898788452148, 0.12242862582206726, 0.9814136028289795, 0.28686872124671936),                                                                        (-0.988969624042511, 0.029873084276914597, 0.14519254863262177, 0.016883566975593567),                                                                                                                 (-0.01154110487550497, -0.9920276999473572, 0.1254904568195343, 3.0356314182281494),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'calf_l': Matrix(((0.06352590024471283, 0.07111050188541412, 0.9954434633255005, 0.4528888463973999),                                                                          (-0.9864101409912109, 0.15603093802928925, 0.051805529743433, 0.057391393929719925),                                                                                                                   (-0.15163268148899078, -0.9851897954940796, 0.0800546258687973, 1.690379023551941),                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'calf_twist_01_l': Matrix(((0.07022110372781754, 0.07394026219844818, 0.9947871565818787, 0.49927011132240295),                                                                (-0.9836136698722839, 0.17123818397521973, 0.056706979870796204, 0.15916287899017334),                                                                                                                 (-0.16614899039268494, -0.9824519157409668, 0.08475161343812943, 1.0477851629257202),                                                                                                                  (0.0, 0.0, 0.0, 1.0))), 'foot_l': Matrix(((-0.9988451600074768, 0.04569467902183533, -0.0148379011079669, 0.5439279079437256),                                                                         (-0.04550909623503685, -0.9988989233970642, -0.012814990244805813, 0.25717341899871826),                                                                                                               (-0.015406751073896885, -0.012123885564506054, 0.9998079538345337, 0.42893511056900024),                                                                                                               (0.0, 0.0, 0.0, 1.0))), 'ball_l': Matrix(((-0.9997191429138184, 0.013384930789470673, 0.019564179703593254, 0.570442795753479),                                                                        (-0.014264114201068878, -0.9988853931427002, -0.045377589762210846, -0.2661576569080353),                                                                                                              (0.01893478073179722, -0.04564228653907776, 0.9987787008285522, 0.0895673930644989),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'thigh_twist_01_l': Matrix(((0.054214686155319214, 0.12228686362504959, 0.9910129308700562, 0.37302935123443604),                                                              (-0.9982490539550781, 0.030845902860164642, 0.05080666393041611, 0.03790700435638428),                                                                                                                 (-0.024354444816708565, -0.9920154213905334, 0.12374281138181686, 2.3374712467193604),                                                                                                                 (0.0, 0.0, 0.0, 1.0))), 'thigh_r': Matrix(((0.14777995645999908, -0.12242887169122696, -0.9814134240150452, -0.28686851263046265),                                                                     (0.9889672994613647, 0.029873039573431015, 0.14519290626049042, 0.01688377372920513),                                                                                                                  (0.011541100218892097, -0.9920276999473572, 0.12549076974391937, 3.035640239715576),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'calf_r': Matrix(((0.06352677941322327, -0.07111088186502457, -0.9954434633255005, -0.4528923034667969),                                                                       (0.9864077568054199, 0.15603092312812805, 0.051805902272462845, 0.057393357157707214),                                                                                                                 (0.15163299441337585, -0.9851897954940796, 0.08005517721176147, 1.6903778314590454),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'calf_twist_01_r': Matrix(((0.07022111117839813, -0.07394134253263474, -0.9947873950004578, -0.4992726445198059),                                                              (0.9836116433143616, 0.17123790085315704, 0.056706372648477554, 0.15916237235069275),                                                                                                                  (0.16614912450313568, -0.9824520349502563, 0.08475271612405777, 1.0477848052978516),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'foot_r': Matrix(((-0.9988456964492798, -0.045694686472415924, 0.014824330806732178, -0.5439401268959045),                                                                     (0.045508794486522675, -0.9988968968391418, -0.012814175337553024, 0.25717782974243164),                                                                                                               (0.015393181703984737, -0.012123774737119675, 0.9998083114624023, 0.42893141508102417),                                                                                                                (0.0, 0.0, 0.0, 1.0))), 'ball_r': Matrix(((-0.9972401261329651, -0.013385219499468803, -0.07303193211555481, -0.570457398891449),                                                                      (0.016671735793352127, -0.9988832473754883, -0.04454910010099411, -0.26614367961883545),                                                                                                               (-0.0723530724644661, -0.04564223065972328, 0.996334433555603, 0.08956339210271835),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'thigh_twist_01_r': Matrix(((0.054212234914302826, -0.12228633463382721, -0.9910131096839905, -0.373030424118042),                                                             (0.998246967792511, 0.03084590658545494, 0.050803784281015396, 0.03790738061070442),                                                                                                                   (0.024354996159672737, -0.9920153021812439, 0.12374229729175568, 2.337482213973999),                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'ik_foot_l': Matrix(((-0.04569396749138832, 0.014827638864517212, -0.9988452792167664, 0.5439395904541016),                                                                    (0.9988820552825928, 0.012795630842447281, -0.045505695044994354, 0.2571251392364502),                                                                                                                 (0.012106114998459816, -0.9998079538345337, -0.01539568044245243, 0.4289320111274719),                                                                                                                 (0.0, 0.0, 0.0, 1.0))), 'ik_foot_r': Matrix(((-0.04569617658853531, 0.01482755783945322, -0.9988452196121216, -0.5439403653144836),                                                                    (-0.9988820552825928, -0.012795629911124706, 0.04550790414214134, 0.2571261525154114),                                                                                                                 (-0.012106083333492279, 0.9998080730438232, 0.01539571676403284, 0.4289264380931854),                                                                                                                  (0.0, 0.0, 0.0, 1.0)))}

matrix_coords_legacy = {
    'pelvis': Matrix(((1.0, 1.6488743881382106e-07, 1.1779484054841305e-07, 2.9802464496242465e-08),                                                                                                                               (1.1839658498047356e-07, -0.0036541179288178682, -0.9999933242797852, 0.033642228692770004),                                                                                                                            (-1.6445591199953924e-07, 0.9999933242797852, -0.003654122119769454, 3.0818512439727783),                                                                                                                               (0.0, 0.0, 0.0, 1.0))), 'spine_01': Matrix(((1.0, 1.6357645904463425e-07, 9.723312643927784e-08, -5.690844204764289e-07),                                                                                               (1.1739510341612913e-07, -0.12815892696380615, -0.9917536377906799, 0.005264334846287966),                                                                                                                              (-1.4976629358898208e-07, 0.9917535781860352, -0.12815892696380615, 3.426046133041382),                                                                                                                                 (0.0, 0.0, 0.0, 1.0))), 'spine_02': Matrix(((1.0, 1.6371627964417712e-07, 1.3765824746769795e-07, -1.1853769592562458e-06),                                                                                             (1.1761618878836089e-07, 0.11667659133672714, -0.9931699633598328, 0.04829178750514984),                                                                                                                                (-1.786596186548195e-07, 0.993169903755188, 0.11667657643556595, 4.037858486175537),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'spine_03': Matrix(((1.0000001192092896, 1.5512173945353425e-07, 1.455832716601435e-07, -1.0244309578411048e-07),                                                                               (1.1804679900251358e-07, 0.1646990180015564, -0.9863439202308655, 0.11142235994338989),                                                                                                                                 (-1.7698083354389382e-07, 0.9863439798355103, 0.164698988199234, 4.460445404052734),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'clavicle_l': Matrix(((-0.4467739164829254, 0.8817453980445862, -0.15139032900333405, 0.12046995759010315),                                                                                     (0.8946470022201538, 0.4403337240219116, -0.07558507472276688, 0.0879276767373085),                                                                                                                                     (1.5548292140010744e-05, -0.16921041905879974, -0.9855801463127136, 4.848153591156006),                                                                                                                                 (0.0, 0.0, 0.0, 1.0))), 'upperarm_l': Matrix(((-0.06804940104484558, 0.6448395252227783, -0.7612832188606262, 0.5638152360916138),                                                                                      (0.9969835877418518, 0.07249964028596878, -0.02770802192389965, 0.3093293309211731),                                                                                                                                    (0.037325553596019745, -0.7608722448348999, -0.6478276252746582, 4.763073921203613),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'lowerarm_l': Matrix(((0.22621211409568787, 0.71849125623703, -0.6577226519584656, 1.1870040893554688),                                                                                         (0.8883803486824036, -0.4291151463985443, -0.1632196605205536, 0.3793938457965851),                                                                                                                                     (-0.3995104730129242, -0.5473855137825012, -0.7353644371032715, 4.027740478515625),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'hand_l': Matrix(((-0.3872259259223938, 0.6874744892120361, 0.6143580079078674, 1.8043683767318726),                                                                                            (-0.8942698836326599, -0.44220542907714844, -0.06881887465715408, 0.010670920833945274),                                                                                                                                (0.22436103224754333, -0.5760502219200134, 0.7860208749771118, 3.5573978424072266),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'index_01_l': Matrix(((-0.5691732168197632, 0.3801196217536926, 0.729076087474823, 2.00811505317688),                                                                                           (-0.8210586309432983, -0.3098383843898773, -0.47944071888923645, -0.21553735435009003),                                                                                                                                 (0.043650753796100616, -0.8714985847473145, 0.4884519875049591, 3.306872606277466),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'index_02_l': Matrix(((-0.5856645703315735, 0.22513841092586517, 0.7786597013473511, 2.0600287914276123),                                                                                       (-0.8100423812866211, -0.19669800996780396, -0.5523964166641235, -0.2578526437282562),                                                                                                                                  (0.028794975951313972, -0.954265832901001, 0.2975706458091736, 3.1878502368927),                                                                                                                                        (0.0, 0.0, 0.0, 1.0))), 'index_03_l': Matrix(((-0.6060661673545837, 0.3402694761753082, 0.7189587950706482, 2.084367275238037),                                                                                         (-0.794628381729126, -0.2991946041584015, -0.5282508134841919, -0.27911657094955444),                                                                                                                                   (0.03536076843738556, -0.891459584236145, 0.4517193138599396, 3.0846898555755615),                                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'middle_01_l': Matrix(((-0.3635404706001282, 0.43978965282440186, 0.8212335109710693, 2.054236650466919),                                                                                       (-0.9258244633674622, -0.2683940827846527, -0.2661091089248657, -0.14269250631332397),                                                                                                                                  (0.10338201373815536, -0.8570592403411865, 0.5047399401664734, 3.296238899230957),                                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'middle_02_l': Matrix(((-0.33663392066955566, 0.24778567254543304, 0.9084494709968567, 2.1192431449890137),                                                                                     (-0.9321931004524231, -0.22397959232330322, -0.2843402922153473, -0.1823645532131195),                                                                                                                                  (0.13301853835582733, -0.942568838596344, 0.3063831031322479, 3.1695547103881836),                                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'middle_03_l': Matrix(((-0.3099200129508972, 0.5044873952865601, 0.8058803081512451, 2.148042917251587),                                                                                        (-0.9487491846084595, -0.21923765540122986, -0.2276189774274826, -0.20839737355709076),                                                                                                                                 (0.06184826046228409, -0.8351216316223145, 0.5465779900550842, 3.0600013732910156),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'pinky_01_l': Matrix(((0.047512855380773544, 0.5354592800140381, 0.8432241082191467, 2.0394251346588135),                                                                                       (-0.991080641746521, -0.07995414733886719, 0.10661621391773224, 0.005057434551417828),                                                                                                                                  (0.12450774013996124, -0.8407683372497559, 0.5268842577934265, 3.2814652919769287),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'pinky_02_l': Matrix(((0.038499802350997925, 0.36015915870666504, 0.9320963621139526, 2.1003317832946777),                                                                                      (-0.9945775866508484, -0.07637055963277817, 0.07059001922607422, -0.0040405127219855785),                                                                                                                               (0.0966082289814949, -0.9297598004341125, 0.35526588559150696, 3.18583345413208),                                                                                                                                       (0.0, 0.0, 0.0, 1.0))), 'pinky_03_l': Matrix(((0.007948013022542, 0.34501656889915466, 0.9385631084442139, 2.1345832347869873),                                                                                         (-0.9875791072845459, -0.14458194375038147, 0.06151164323091507, -0.01130758598446846),                                                                                                                                 (0.15692174434661865, -0.9273942112922668, 0.33958184719085693, 3.097411632537842),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'ring_01_l': Matrix(((-0.10225813090801239, 0.45520707964897156, 0.8844945430755615, 2.056959390640259),                                                                                        (-0.9794353246688843, -0.20153455436229706, -0.009514044038951397, -0.06634527444839478),                                                                                                                               (0.17392514646053314, -0.8672778606414795, 0.46645429730415344, 3.282162666320801),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'ring_02_l': Matrix(((-0.10031931847333908, 0.2421373575925827, 0.9650420546531677, 2.121196985244751),                                                                                         (-0.9843636155128479, -0.16530483961105347, -0.06085129827260971, -0.09478528797626495),                                                                                                                                (0.14479155838489532, -0.9560567140579224, 0.25493428111076355, 3.1597747802734375),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'ring_03_l': Matrix(((-0.11813034862279892, 0.445625901222229, 0.8873911499977112, 2.148012161254883),                                                                                          (-0.9740408658981323, -0.22578561305999756, -0.016281140968203545, -0.11309174448251724),                                                                                                                               (0.19310469925403595, -0.8662786483764648, 0.4607298672199249, 3.0538976192474365),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'thumb_01_l': Matrix(((-0.8114521503448486, 0.03345810994505882, -0.5834612250328064, 1.8308652639389038),                                                                                      (0.30533599853515625, -0.8269938826560974, -0.4720713794231415, -0.12348932027816772),                                                                                                                                  (-0.49831318855285645, -0.5612149238586426, 0.6608496904373169, 3.4286792278289795),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'thumb_02_l': Matrix(((-0.8151497840881348, 0.04350224509835243, -0.5776150822639465, 1.8349894285202026),                                                                                      (0.4348517656326294, -0.6128038167953491, -0.6598300337791443, -0.2254272699356079),                                                                                                                                    (-0.38266855478286743, -0.78903728723526, 0.48060962557792664, 3.359502077102661),                                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'thumb_03_l': Matrix(((-0.7895572781562805, -0.08822071552276611, -0.6073035597801208, 1.8406293392181396),                                                                                     (0.4622490108013153, -0.7364058494567871, -0.49399667978286743, -0.30472293496131897),                                                                                                                                  (-0.40364086627960205, -0.6707640290260315, 0.6222143769264221, 3.257392168045044),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'lowerarm_twist_01_l': Matrix(((0.22621233761310577, 0.71849125623703, -0.6577226519584656, 1.5074151754379272),                                                                                (0.8883805274963379, -0.42911526560783386, -0.16321943700313568, 0.18803295493125916),                                                                                                                                  (-0.39951038360595703, -0.5473856329917908, -0.7353644967079163, 3.7836334705352783),                                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'upperarm_twist_01_l': Matrix(((-0.06804972887039185, 0.6448402404785156, -0.7612826228141785, 0.5740848183631897),                                                                             (0.9969834685325623, 0.0724998489022255, -0.027708232402801514, 0.31048259139060974),                                                                                                                                   (0.03732551261782646, -0.7608716487884521, -0.6478283405303955, 4.750959396362305),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'clavicle_r': Matrix(((-0.446773499250412, -0.8817450404167175, 0.15139037370681763, -0.12047027796506882),                                                                                     (-0.8946470022201538, 0.44033339619636536, -0.07558484375476837, 0.08792795240879059),                                                                                                                                  (-1.573431109136436e-05, -0.16921013593673706, -0.9855800271034241, 4.848152160644531),                                                                                                                                 (0.0, 0.0, 0.0, 1.0))), 'upperarm_r': Matrix(((-0.06804873049259186, -0.6448400616645813, 0.7612820863723755, -0.5638132691383362),                                                                                     (-0.9969834089279175, 0.07249974459409714, -0.027706917375326157, 0.3093283772468567),                                                                                                                                  (-0.037326354533433914, -0.7608712315559387, -0.6478285193443298, 4.763072967529297),                                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'lowerarm_r': Matrix(((0.2262125462293625, -0.7184913158416748, 0.6577218174934387, -1.187003254890442),                                                                                        (-0.8883800506591797, -0.4291154742240906, -0.16321952641010284, 0.3793943226337433),                                                                                                                                   (0.39951038360595703, -0.5473848581314087, -0.7353648543357849, 4.0277419090271),                                                                                                                                       (0.0, 0.0, 0.0, 1.0))), 'hand_r': Matrix(((-0.38722577691078186, -0.6874740719795227, -0.6143577694892883, -1.8043808937072754),                                                                                        (0.8942696452140808, -0.44220563769340515, -0.06881850212812424, 0.010678116232156754),                                                                                                                                 (-0.22436146438121796, -0.5760498642921448, 0.7860209345817566, 3.5573911666870117),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'index_01_r': Matrix(((-0.5691713690757751, -0.38012075424194336, -0.729076087474823, -2.0081169605255127),                                                                                     (0.8210592865943909, -0.3098392188549042, -0.47943830490112305, -0.21552559733390808),                                                                                                                                  (-0.04365173727273941, -0.8714975118637085, 0.48845356702804565, 3.3068668842315674),                                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'index_02_r': Matrix(((-0.5856636762619019, -0.22513815760612488, -0.778659462928772, -2.0600316524505615),                                                                                     (0.8100423216819763, -0.19669802486896515, -0.5523957014083862, -0.2578613758087158),                                                                                                                                   (-0.02879525162279606, -0.9542655348777771, 0.2975706160068512, 3.1878366470336914),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'index_03_r': Matrix(((-0.6060662865638733, -0.34027084708213806, -0.7189568877220154, -2.084381341934204),                                                                                     (0.7946276068687439, -0.2991943955421448, -0.5282511711120605, -0.27911558747291565),                                                                                                                                   (-0.03535920009016991, -0.8914583921432495, 0.45172056555747986, 3.084676504135132),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'middle_01_r': Matrix(((-0.363539457321167, -0.4397912621498108, -0.8212324380874634, -2.0542383193969727),                                                                                     (0.9258246421813965, -0.26839450001716614, -0.2661074697971344, -0.14267531037330627),                                                                                                                                  (-0.1033824011683464, -0.8570579886436462, 0.5047418475151062, 3.2962441444396973),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'middle_02_r': Matrix(((-0.336639404296875, -0.2477872669696808, -0.908446729183197, -2.1192374229431152),                                                                                      (0.9321915507316589, -0.22397927939891815, -0.2843457758426666, -0.18236452341079712),                                                                                                                                  (-0.13301584124565125, -0.9425684809684753, 0.3063856065273285, 3.1695525646209717),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'middle_03_r': Matrix(((-0.3099255859851837, -0.5044940114021301, -0.805873692035675, -2.148037910461426),                                                                                      (0.9487475752830505, -0.21923895180225372, -0.2276240885257721, -0.20839782059192657),                                                                                                                                  (-0.06184375286102295, -0.8351172208786011, 0.5465854406356812, 3.059997081756592),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'pinky_01_r': Matrix(((0.04751388728618622, -0.5354591012001038, -0.843223512172699, -2.0394208431243896),                                                                                      (0.9910799860954285, -0.07995501160621643, 0.10661807656288147, 0.005063686985522509),                                                                                                                                  (-0.12450950592756271, -0.8407679200172424, 0.5268841981887817, 3.2814671993255615),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'pinky_02_r': Matrix(((0.038498613983392715, -0.36016038060188293, -0.9320955276489258, -2.100321054458618),                                                                                    (0.9945775866508484, -0.07637088745832443, 0.0705891028046608, -0.004021098837256432),                                                                                                                                  (-0.09660831093788147, -0.9297590851783752, 0.3552675247192383, 3.185833215713501),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'pinky_03_r': Matrix(((0.007946948520839214, -0.34501850605010986, -0.9385619163513184, -2.1345865726470947),                                                                                   (0.987578809261322, -0.1445828080177307, 0.06151127070188522, -0.011291466653347015),                                                                                                                                   (-0.15692245960235596, -0.9273929595947266, 0.33958426117897034, 3.097409248352051),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'ring_01_r': Matrix(((-0.10225789248943329, -0.4552075266838074, -0.8844937086105347, -2.0569658279418945),                                                                                     (0.9794349670410156, -0.20153528451919556, -0.009513219818472862, -0.06633950024843216),                                                                                                                                (-0.1739262193441391, -0.8672770261764526, 0.4664551317691803, 3.2821528911590576),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'ring_02_r': Matrix(((-0.10032214224338531, -0.2421395629644394, -0.9650405049324036, -2.1211957931518555),                                                                                     (0.984363317489624, -0.1653050035238266, -0.06085372716188431, -0.09477748721837997),                                                                                                                                   (-0.14479097723960876, -0.9560558199882507, 0.2549372911453247, 3.1597814559936523),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'ring_03_r': Matrix(((-0.11814992874860764, -0.44564130902290344, -0.8873803615570068, -2.1480112075805664),                                                                                    (0.9740407466888428, -0.22578607499599457, -0.01629849337041378, -0.11308398097753525),                                                                                                                                 (-0.19309493899345398, -0.8662703633308411, 0.46074968576431274, 3.0539042949676514),                                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'thumb_01_r': Matrix(((-0.8114492893218994, -0.03345920145511627, 0.5834641456604004, -1.8308802843093872),                                                                                     (-0.3053368330001831, -0.8269942998886108, -0.47206997871398926, -0.12348204851150513),                                                                                                                                 (0.4983168840408325, -0.56121426820755, 0.6608474254608154, 3.4286770820617676),                                                                                                                                        (0.0, 0.0, 0.0, 1.0))), 'thumb_02_r': Matrix(((-0.8151518702507019, -0.043499547988176346, 0.57761150598526, -1.834999442100525),                                                                                       (-0.43485134840011597, -0.6128022074699402, -0.6598317623138428, -0.2254151701927185),                                                                                                                                  (0.3826642334461212, -0.7890386581420898, 0.48061060905456543, 3.3595004081726074),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'thumb_03_r': Matrix(((-0.7895520329475403, 0.08821599930524826, 0.6073099374771118, -1.8406280279159546),                                                                                      (-0.46224936842918396, -0.7364081144332886, -0.49399277567863464, -0.30470842123031616),                                                                                                                                (0.4036501944065094, -0.6707622408866882, 0.6222097873687744, 3.2574031352996826),                                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'lowerarm_twist_01_r': Matrix(((0.06629499793052673, -0.7184914350509644, 0.6923691630363464, -1.5074213743209839),                                                                             (-0.8256651163101196, -0.4291154742240906, -0.3662473261356354, 0.18802636861801147),                                                                                                                                   (0.5602518320083618, -0.5473848581314087, -0.6216816902160645, 3.783639669418335),                                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'upperarm_twist_01_r': Matrix(((-0.3237381875514984, -0.6448400616645813, 0.6923688054084778, -0.5740798115730286),                                                                             (-0.9276889562606812, 0.07249938696622849, -0.3662468492984772, 0.3104839622974396),                                                                                                                                    (0.18597429990768433, -0.7608712315559387, -0.6216821074485779, 4.75096321105957),                                                                                                                                      (0.0, 0.0, 0.0, 1.0))), 'neck_01': Matrix(((1.000000238418579, 1.681314216739338e-07, -3.7881150660723506e-08, 2.7830087674374226e-06),                                                                                 (4.003895881510289e-09, -0.2424011081457138, -0.9701761603355408, 0.1871279776096344),                                                                                                                                  (-1.7229959325959499e-07, 0.9701762199401855, -0.2424011528491974, 4.982570648193359),                                                                                                                                  (0.0, 0.0, 0.0, 1.0))), 'head': Matrix(((1.000000238418579, 1.569277259250157e-07, 7.995011763739512e-09, -2.7994865376967937e-06),                                                                                     (4.376929041427502e-09, 0.023042455315589905, -0.9997345209121704, 0.12670011818408966),                                                                                                                                (-1.5707034606293746e-07, 0.99973464012146, 0.023042425513267517, 5.272284030914307),                                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'thigh_l': Matrix(((0.14777898788452148, 0.12242862582206726, 0.9814136028289795, 0.28686872124671936),                                                                                         (-0.988969624042511, 0.029873084276914597, 0.14519254863262177, 0.016883566975593567),                                                                                                                                  (-0.01154110487550497, -0.9920276999473572, 0.1254904568195343, 3.0356314182281494),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'calf_l': Matrix(((0.06352590024471283, 0.07111050188541412, 0.9954434633255005, 0.4528888463973999),                                                                                           (-0.9864101409912109, 0.15603093802928925, 0.051805529743433, 0.057391393929719925),                                                                                                                                    (-0.15163268148899078, -0.9851897954940796, 0.0800546258687973, 1.690379023551941),                                                                                                                                     (0.0, 0.0, 0.0, 1.0))), 'calf_twist_01_l': Matrix(((0.07022110372781754, 0.07394026219844818, 0.9947871565818787, 0.49927011132240295),                                                                                 (-0.9836136698722839, 0.17123818397521973, 0.056706979870796204, 0.15916287899017334),                                                                                                                                  (-0.16614899039268494, -0.9824519157409668, 0.08475161343812943, 1.0477851629257202),                                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'foot_l': Matrix(((0.9988451600074768, 0.04569466412067413, 0.014837459661066532, 0.5439507365226746),                                                                                          (0.04550907760858536, -0.998898983001709, 0.012815006077289581, 0.25717443227767944),                                                                                                                                   (0.01540630403906107, -0.01212395541369915, -0.9998079538345337, 0.4289359450340271),                                                                                                                                   (0.0, 0.0, 0.0, 1.0))), 'ball_l': Matrix(((0.9997190833091736, 0.013384900987148285, -0.019564209505915642, 0.5704677700996399),                                                                                        (0.014264079742133617, -0.9988855123519897, 0.045377619564533234, -0.26615655422210693),                                                                                                                                (-0.018934819847345352, -0.045642342418432236, -0.9987786412239075, 0.08956500887870789),                                                                                                                               (0.0, 0.0, 0.0, 1.0))), 'thigh_twist_01_l': Matrix(((0.054214686155319214, 0.12228686362504959, 0.9910129308700562, 0.37302935123443604),                                                                               (-0.9982490539550781, 0.030845902860164642, 0.05080666393041611, 0.03790700435638428),                                                                                                                                  (-0.024354444816708565, -0.9920154213905334, 0.12374281138181686, 2.3374712467193604),                                                                                                                                  (0.0, 0.0, 0.0, 1.0))), 'thigh_r': Matrix(((0.14777995645999908, -0.12242887169122696, -0.9814134240150452, -0.28686851263046265),                                                                                      (0.9889672994613647, 0.029873039573431015, 0.14519290626049042, 0.01688377372920513),                                                                                                                                   (0.011541100218892097, -0.9920276999473572, 0.12549076974391937, 3.035640239715576),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'calf_r': Matrix(((0.06352677941322327, -0.07111088186502457, -0.9954434633255005, -0.4528923034667969),                                                                                        (0.9864077568054199, 0.15603092312812805, 0.051805902272462845, 0.057393357157707214),                                                                                                                                  (0.15163299441337585, -0.9851897954940796, 0.08005517721176147, 1.6903778314590454),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'calf_twist_01_r': Matrix(((0.07022111117839813, -0.07394134253263474, -0.9947873950004578, -0.4992726445198059),                                                                               (0.9836116433143616, 0.17123790085315704, 0.056706372648477554, 0.15916237235069275),                                                                                                                                   (0.16614912450313568, -0.9824520349502563, 0.08475271612405777, 1.0477848052978516),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'foot_r': Matrix(((0.9988456964492798, -0.045694682747125626, -0.014824478887021542, -0.5439459085464478),                                                                                      (-0.045508962124586105, -0.9988968372344971, 0.01281419862061739, 0.25717809796333313),                                                                                                                                 (-0.015393315814435482, -0.012123817577958107, -0.9998083114624023, 0.4289294183254242),                                                                                                                                (0.0, 0.0, 0.0, 1.0))), 'ball_r': Matrix(((0.9972401261329651, -0.013385198079049587, 0.07303211092948914, -0.5704602599143982),                                                                                        (-0.016671892255544662, -0.9988831877708435, 0.04454904794692993, -0.2661433517932892),                                                                                                                                 (0.07235328108072281, -0.045642223209142685, -0.996334433555603, 0.08956042677164078),                                                                                                                                  (0.0, 0.0, 0.0, 1.0))), 'thigh_twist_01_r': Matrix(((0.054212234914302826, -0.12228633463382721, -0.9910131096839905, -0.373030424118042),                                                                              (0.998246967792511, 0.03084590658545494, 0.050803784281015396, 0.03790738061070442),                                                                                                                                    (0.024354996159672737, -0.9920153021812439, 0.12374229729175568, 2.337482213973999),                                                                                                                                    (0.0, 0.0, 0.0, 1.0))), 'ik_foot_l': Matrix(((-0.04569396749138832, 0.014827638864517212, -0.9988452792167664, 0.5439395904541016),                                                                                     (0.9988820552825928, 0.012795630842447281, -0.045505695044994354, 0.2571251392364502),                                                                                                                                  (0.012106114998459816, -0.9998079538345337, -0.01539568044245243, 0.4289320111274719),                                                                                                                                  (0.0, 0.0, 0.0, 1.0))), 'ik_foot_r': Matrix(((-0.04569617658853531, 0.01482755783945322, -0.9988452196121216, -0.5439403653144836),                                                                                     (-0.9988820552825928, -0.012795629911124706, 0.04550790414214134, 0.2571261525154114),                                                                                                                                  (-0.012106083333492279, 0.9998080730438232, 0.01539571676403284, 0.4289264380931854),  (0.0, 0.0, 0.0, 1.0)))}  



coords_manny = {
    'pelvis': Vector((4.458343028090894e-08, 0.022810354828834534, 0.269423246383667)), 'spine_01': Vector((3.515027202638521e-08, -0.04317747429013252, 0.21050333976745605)), 'spine_02': Vector((3.685291005695035e-08, -0.02520585246384144, 0.22368669509887695)), 'spine_03': Vector((4.182476232017507e-08, 0.01812359131872654, 0.2690155506134033)), 'clavicle_l': Vector((0.38833266496658325, -0.004143714904785156, -0.06247901916503906)), 'upperarm_l': Vector((0.31430724263191223, -0.03648865222930908, -0.42975902557373047)), 'lowerarm_l': Vector((0.33439040184020996, -0.4210553765296936, -0.3698444366455078)), 'hand_l': Vector((0.17020833492279053, -0.21640276908874512, -0.20577287673950195)), 'index_01_l': Vector((0.014579057693481445, -0.07308363914489746, -0.11444735527038574)), 'index_02_l': Vector((-0.008319616317749023, -0.03915280103683472, -0.10042119026184082)), 'index_03_l': Vector((-0.027464866638183594, -0.019534945487976074, -0.10271644592285156)), 'middle_01_l': Vector((0.022649765014648438, -0.07077527046203613, -0.1277751922607422)), 'middle_02_l': Vector((-0.03115236759185791, -0.03051590919494629, -0.10773754119873047)), 'middle_03_l': Vector((-0.0426325798034668, -0.021903932094573975, -0.10588550567626953)), 'pinky_01_l': Vector((0.035091400146484375, -0.03115740418434143, -0.10361766815185547)), 'pinky_02_l': Vector((-0.008501410484313965, -0.020520806312561035, -0.09247255325317383)), 'pinky_03_l': Vector((-0.021644949913024902, -0.019707798957824707, -0.09048581123352051)), 'ring_01_l': Vector((0.020223498344421387, -0.05591464042663574, -0.12797927856445312)), 'ring_02_l': Vector((-0.02871239185333252, -0.02788454294204712, -0.10325789451599121)), 'ring_03_l': Vector((-0.045408010482788086, -0.026879966259002686, -0.09736394882202148)), 'thumb_01_l': Vector((-0.030009031295776367, -0.10571157932281494, -0.05584216117858887)), 'thumb_02_l': Vector((-0.008264780044555664, -0.08663475513458252, -0.09575486183166504)), 'thumb_03_l': Vector((0.010935187339782715, -0.07305216789245605, -0.10623884201049805)), 'lowerarm_twist_01_l': Vector((0.15177977085113525, -0.19111697375774384, -0.16787219047546387)), 'upperarm_twist_01_l': Vector((0.31430745124816895, -0.03648859262466431, -0.42975854873657227)), 'clavicle_r': Vector((-0.3883326053619385, -0.004143714904785156, -0.06247901916503906)), 'upperarm_r': Vector((-0.31430649757385254, -0.03648975491523743, -0.42975664138793945)), 'lowerarm_r': Vector((-0.33439111709594727, -0.4210564196109772, -0.369844913482666)), 'hand_r': Vector((-0.17020821571350098, -0.21640262007713318, -0.20577263832092285)), 'index_01_r': Vector((-0.0145798921585083, -0.07308685779571533, -0.11445212364196777)), 'index_02_r': Vector((0.008319616317749023, -0.03915286064147949, -0.10042142868041992)), 'index_03_r': Vector((0.027464747428894043, -0.01953500509262085, -0.10271668434143066)), 'middle_01_r': Vector((-0.022650837898254395, -0.07077819108963013, -0.12778019905090332)), 'middle_02_r': Vector((0.031152725219726562, -0.030516326427459717, -0.10773992538452148)), 'middle_03_r': Vector((0.042632460594177246, -0.021904349327087402, -0.10588788986206055)), 'pinky_01_r': Vector((-0.03509211540222168, -0.031158089637756348, -0.10361957550048828)), 'pinky_02_r': Vector((0.008500814437866211, -0.02051931619644165, -0.09246587753295898)), 'pinky_03_r': Vector((0.02164316177368164, -0.01970633864402771, -0.09047889709472656)), 'ring_01_r': Vector((-0.020222067832946777, -0.055910706520080566, -0.12796998023986816)), 'ring_02_r': Vector((0.028712153434753418, -0.027884602546691895, -0.10325813293457031)), 'ring_03_r': Vector((0.045406341552734375, -0.026879966259002686, -0.0973653793334961)), 'thumb_01_r': Vector((0.03000807762145996, -0.1057085394859314, -0.055840492248535156)), 'thumb_02_r': Vector((0.008265137672424316, -0.08663463592529297, -0.09575533866882324)), 'thumb_03_r': Vector((-0.010936141014099121, -0.07305252552032471, -0.10623836517333984)), 'lowerarm_twist_01_r': Vector((-0.33439111709594727, -0.4210563600063324, -0.369844913482666)), 'upperarm_twist_01_r': Vector((-0.3143066167831421, -0.03648969531059265, -0.42975664138793945)), 'neck_01': Vector((5.1866805961253704e-08, -0.06830257177352905, 0.30083274841308594)), 'head': Vector((2.6211068870907184e-08, 0.00036537647247314453, 0.16702604293823242)), 'spine_04': Vector((9.580594451108482e-08, 0.09931595623493195, 0.6095805168151855)), 'spine_05': Vector((6.382293804563233e-08, 0.07682652771472931, 0.4042019844055176)), 'thigh_l': Vector((0.0695282518863678, -0.0019057318568229675, -1.0275743007659912)), 'calf_l': Vector((0.0451371967792511, 0.08593619614839554, -0.9614447951316833)), 'calf_twist_01_l': Vector((0.029880672693252563, 0.06920063495635986, -0.3970276117324829)), 'foot_l': Vector((0.08850899338722229, -0.6173408627510071, -0.02823510766029358)), 'ball_l': Vector((0.0871509313583374, -0.6175223588943481, -0.028493650257587433)), 'thigh_twist_01_l': Vector((0.12594634294509888, 0.031768977642059326, -1.021701693534851)), 'thigh_r': Vector((-0.0695282518863678, -0.0019057095050811768, -1.0275743007659912)), 'calf_r': Vector((-0.0451371967792511, 0.08593619614839554, -0.9614447951316833)), 'calf_twist_01_r': Vector((-0.029880672693252563, 0.06920063495635986, -0.3970276117324829)), 'foot_r': Vector((-0.08850902318954468, -0.6173409223556519, -0.02823510766029358)), 'ball_r': Vector((-0.0871509313583374, -0.6175222992897034, -0.028493640944361687)), 'thigh_twist_01_r': Vector((-0.12594622373580933, 0.03176917880773544, -1.0217052698135376)), 'ik_foot_l': Vector((0.008104801177978516, 0.0234362930059433, -0.5460392236709595)), 'ik_foot_r': Vector((-0.008104801177978516, 0.0234362930059433, -0.5460392236709595))}                                                                                                                                 


matrix_manny_coords = {'pelvis': Matrix(((1.0, 1.6488741039211163e-07, 1.317686724178202e-07, 2.1641257532525783e-18),
        (1.1738873695321672e-07, 0.08436184376478195, -0.996435284614563, 0.12915651500225067),
        (-1.7541587737923692e-07, 0.996435284614563, 0.08436161279678345, 3.0915963649749756),
        (0.0, 0.0, 0.0, 1.0))), 'spine_01': Matrix(((1.0, 1.6357644483377953e-07, 8.277370966425224e-08, 5.67650246807716e-08),
        (1.1395330545838078e-07, -0.2009320855140686, -0.9796052575111389, 0.09487602859735489),
        (-1.4360843181293603e-07, 0.9796051979064941, -0.20093229413032532, 3.2162325382232666),
        (0.0, 0.0, 0.0, 1.0))), 'spine_02': Matrix(((1.0, 1.637162512224677e-07, 1.0006669981521554e-07, 1.5572713607525657e-07),
        (1.177695096998832e-07, -0.11197507381439209, -0.9937111139297485, 0.049215417355298996),
        (-1.5148164322908997e-07, 0.9937111735343933, -0.11197525262832642, 3.435349464416504),
        (0.0, 0.0, 0.0, 1.0))), 'spine_03': Matrix(((1.0, 1.5512181050780782e-07, 1.3192774872550217e-07, 2.2538281996276055e-07),
        (1.212024329788619e-07, 0.06721770018339157, -0.9977384209632874, 0.022080184891819954),
        (-1.6363883048597927e-07, 0.9977385997772217, 0.06721752882003784, 3.6793856620788574),
        (0.0, 0.0, 0.0, 1.0))), 'clavicle_l': Matrix(((0.00291550625115633, 0.987248420715332, 0.15916088223457336, 0.10811559110879898),
        (-0.9964441657066345, -0.010534485802054405, 0.08359717577695847, 0.31347379088401794),
        (0.08420770615339279, -0.15883870422840118, 0.9837072491645813, 4.832284927368164),
        (0.0, 0.0, 0.0, 1.0))), 'upperarm_l': Matrix(((-0.0743599459528923, 0.5889445543289185, 0.8047452569007874, 0.49644824862480164),
        (-0.996772825717926, -0.06837192922830582, -0.04206622391939163, 0.3093300759792328),
        (0.03024715930223465, -0.8052763938903809, 0.5921281576156616, 4.769805908203125),
        (0.0, 0.0, 0.0, 1.0))), 'lowerarm_l': Matrix(((-0.32608550786972046, 0.5123956799507141, 0.7944299578666687, 1.0496890544891357),
        (-0.7566928267478943, -0.6451948285102844, 0.1055455207824707, 0.2375360131263733),
        (0.5666431188583374, -0.5667229294776917, 0.5981149077415466, 3.930741548538208),
        (0.0, 0.0, 0.0, 1.0))), 'hand_l': Matrix(((-0.5013784170150757, 0.49519479274749756, 0.7095082402229309, 1.4899672269821167),
        (-0.769853413105011, -0.6295902729034424, -0.10460494458675385, -0.31685030460357666),
        (0.39489948749542236, -0.5986643433570862, 0.6968903541564941, 3.4437828063964844),
        (0.0, 0.0, 0.0, 1.0))), 'index_01_l': Matrix(((-0.703292727470398, 0.10674992203712463, 0.7028398513793945, 1.6067826747894287),
        (-0.6364068984985352, -0.5351284742355347, -0.5555395483970642, -0.6047245264053345),
        (0.31680575013160706, -0.8379993438720703, 0.44428813457489014, 3.2010366916656494),
        (0.0, 0.0, 0.0, 1.0))), 'index_02_l': Matrix(((-0.7199910283088684, -0.07695908099412918, 0.6897029876708984, 1.6213617324829102),
        (-0.6243136525154114, -0.36217576265335083, -0.6921426653862, -0.6778081655502319),
        (0.3030603229999542, -0.9289277791976929, 0.21271643042564392, 3.0865893363952637),
        (0.0, 0.0, 0.0, 1.0))), 'index_03_l': Matrix(((-0.7341527938842773, -0.254058301448822, 0.6296617984771729, 1.6130421161651611),
        (-0.6035290956497192, -0.18070416152477264, -0.7765944600105286, -0.7169609665870667),
        (0.31108275055885315, -0.9501583576202393, -0.02066744863986969, 2.986168146133423),
        (0.0, 0.0, 0.0, 1.0))), 'middle_01_l': Matrix(((-0.5201455354690552, 0.15323284268379211, 0.840219259262085, 1.662989854812622),
        (-0.7828632593154907, -0.47881683707237244, -0.3973158597946167, -0.5440884828567505),
        (0.34142908453941345, -0.8644391894340515, 0.3690146505832672, 3.1743881702423096),
        (0.0, 0.0, 0.0, 1.0))), 'middle_02_l': Matrix(((-0.48897671699523926, -0.26802703738212585, 0.8300984501838684, 1.6856396198272705),
        (-0.7919382452964783, -0.26255106925964355, -0.5512722134590149, -0.6148637533187866),
        (0.36569884419441223, -0.9269462823867798, -0.08387979865074158, 3.0466129779815674),
        (0.0, 0.0, 0.0, 1.0))), 'middle_03_l': Matrix(((-0.5007587671279907, -0.3667999505996704, 0.7840271592140198, 1.6544872522354126),
        (-0.7852983474731445, -0.18845593929290771, -0.5897381901741028, -0.6453796625137329),
        (0.36407023668289185, -0.9110121726989746, -0.19367678463459015, 2.938875436782837),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_01_l': Matrix(((-0.11292795836925507, 0.3084990084171295, 0.9444975852966309, 1.6729291677474976),
        (-0.9614167213439941, -0.2739139795303345, -0.025483042001724243, -0.3988151252269745),
        (0.25084924697875977, -0.910933792591095, 0.32752859592437744, 3.1417605876922607),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_02_l': Matrix(((-0.12845948338508606, -0.08939173817634583, 0.987677812576294, 1.708020567893982),
        (-0.9655995965003967, -0.21577498316764832, -0.1451171189546585, -0.4299725294113159),
        (0.22608809173107147, -0.9723430871963501, -0.058598458766937256, 3.0381429195404053),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_03_l': Matrix(((-0.11921877413988113, -0.22759485244750977, 0.9664303064346313, 1.699519395828247),
        (-0.9638129472732544, -0.20722588896751404, -0.1676977127790451, -0.45049339532852173),
        (0.23843617737293243, -0.9514508843421936, -0.19465383887290955, 2.9456703662872314),
        (0.0, 0.0, 0.0, 1.0))), 'ring_01_l': Matrix(((-0.2704697251319885, 0.1433098018169403, 0.9520023465156555, 1.6771681308746338),
        (-0.8971536755561829, -0.39622780680656433, -0.19524076581001282, -0.4717802405357361),
        (0.3492296636104584, -0.9068995714187622, 0.23573839664459229, 3.1497862339019775),
        (0.0, 0.0, 0.0, 1.0))), 'ring_02_l': Matrix(((-0.2777215242385864, -0.25926920771598816, 0.9250137209892273, 1.6973916292190552),
        (-0.9052055478096008, -0.25179386138916016, -0.3423490524291992, -0.5276948809623718),
        (0.32167312502861023, -0.9324055314064026, -0.16476359963417053, 3.0218069553375244),
        (0.0, 0.0, 0.0, 1.0))), 'ring_03_l': Matrix(((-0.26888975501060486, -0.4100281894207001, 0.8715361952781677, 1.6686792373657227),
        (-0.8889283537864685, -0.24272248148918152, -0.38844847679138184, -0.555579423904419),
        (0.37081608176231384, -0.8791833519935608, -0.29922038316726685, 2.918549060821533),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_01_l': Matrix(((-0.8061848282814026, -0.24345475435256958, -0.539254903793335, 1.470875859260559),
        (0.43861910700798035, -0.8576086163520813, -0.26855406165122986, -0.4666717052459717),
        (-0.3970886766910553, -0.4530319571495056, 0.7981749773025513, 3.3321752548217773),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_02_l': Matrix(((-0.790361762046814, -0.06387288868427277, -0.6093018054962158, 1.4408668279647827),
        (0.48668378591537476, -0.6695411205291748, -0.5611186623573303, -0.5723832845687866),
        (-0.3721121847629547, -0.740024209022522, 0.5602654218673706, 3.2763330936431885),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_03_l': Matrix(((-0.7667809128761292, 0.08451060950756073, -0.6363216638565063, 1.432601809501648),
        (0.4893605411052704, -0.5645703673362732, -0.6646707057952881, -0.6590176820755005),
        (-0.41541993618011475, -0.8210475444793701, 0.39154547452926636, 3.1805777549743652),
        (0.0, 0.0, 0.0, 1.0))), 'lowerarm_twist_01_l': Matrix(((-0.3260864019393921, 0.5123958587646484, 0.7944294810295105, 1.2781918048858643),
        (-0.7566927671432495, -0.6451950073242188, 0.1055450290441513, -0.050188541412353516),
        (0.566642701625824, -0.5667225122451782, 0.5981156229972839, 3.678011655807495),
        (0.0, 0.0, 0.0, 1.0))), 'upperarm_twist_01_l': Matrix(((-0.07435967028141022, 0.588945209980011, 0.8047447800636292, 0.5044553279876709),
        (-0.996772825717926, -0.06837183982133865, -0.04206591472029686, 0.3081468939781189),
        (0.03024720959365368, -0.8052759170532227, 0.5921288132667542, 4.756089210510254),
        (0.0, 0.0, 0.0, 1.0))), 'clavicle_r': Matrix(((0.002915681106969714, -0.9872481226921082, -0.15916086733341217, -0.10811560600996017),
        (0.9964439868927002, -0.01053445041179657, 0.08359712362289429, 0.31347376108169556),
        (-0.08420762419700623, -0.1588386595249176, 0.9837071299552917, 4.832284927368164),
        (0.0, 0.0, 0.0, 1.0))), 'upperarm_r': Matrix(((-0.07436239719390869, -0.5889455080032349, -0.8047440648078918, -0.49644821882247925),
        (0.9967724084854126, -0.06837429106235504, -0.04206768423318863, 0.3093300461769104),
        (-0.03024805337190628, -0.8052753210067749, 0.5921292304992676, 4.769805908203125),
        (0.0, 0.0, 0.0, 1.0))), 'lowerarm_r': Matrix(((-0.3260858356952667, -0.5123957395553589, -0.7944294810295105, -1.0496890544891357),
        (0.7566924691200256, -0.6451950073242188, 0.10554541647434235, 0.23753467202186584),
        (-0.5666431188583374, -0.5667224526405334, 0.5981150269508362, 3.9307425022125244),
        (0.0, 0.0, 0.0, 1.0))), 'hand_r': Matrix(((-0.5013782978057861, -0.49519461393356323, -0.7095081210136414, -1.4899682998657227),
        (0.7698531150817871, -0.6295903921127319, -0.10460490733385086, -0.3168543875217438),
        (-0.39489978551864624, -0.5986641049385071, 0.696890115737915, 3.4437828063964844),
        (0.0, 0.0, 0.0, 1.0))), 'index_01_r': Matrix(((-0.7032912969589233, -0.10675141215324402, -0.7028406858444214, -1.6067743301391602),
        (0.6364077925682068, -0.535129189491272, -0.5555375814437866, -0.6047251224517822),
        (-0.3168063163757324, -0.8379985094070435, 0.4442889392375946, 3.2010340690612793),
        (0.0, 0.0, 0.0, 1.0))), 'index_02_r': Matrix(((-0.7199904322624207, 0.07695888727903366, -0.6897032856941223, -1.6213585138320923),
        (0.62431401014328, -0.36217546463012695, -0.6921423673629761, -0.677812397480011),
        (-0.30306029319763184, -0.9289276599884033, 0.21271610260009766, 3.086582899093628),
        (0.0, 0.0, 0.0, 1.0))), 'index_03_r': Matrix(((-0.7341533303260803, 0.2540567219257355, -0.6296614408493042, -1.6130415201187134),
        (0.6035284996032715, -0.18070435523986816, -0.7765947580337524, -0.7169673442840576),
        (-0.3110818862915039, -0.9501585364341736, -0.020666107535362244, 2.9861621856689453),
        (0.0, 0.0, 0.0, 1.0))), 'middle_01_r': Matrix(((-0.5201447606086731, -0.15323388576507568, -0.8402193188667297, -1.6629856824874878),
        (0.7828633785247803, -0.478817343711853, -0.3973146080970764, -0.5440899133682251),
        (-0.34142959117889404, -0.8644384145736694, 0.3690154552459717, 3.174389600753784),
        (0.0, 0.0, 0.0, 1.0))), 'middle_02_r': Matrix(((-0.4889822006225586, 0.26802441477775574, -0.8300957679748535, -1.6856328248977661),
        (0.7919357419013977, -0.26254913210868835, -0.551276445388794, -0.6148666739463806),
        (-0.36569657921791077, -0.9269471168518066, -0.08387643098831177, 3.0466082096099854),
        (0.0, 0.0, 0.0, 1.0))), 'middle_03_r': Matrix(((-0.5007653832435608, 0.36679181456565857, -0.7840263843536377, -1.6544800996780396),
        (0.7852954864501953, -0.18845584988594055, -0.5897417068481445, -0.6453830003738403),
        (-0.36406683921813965, -0.911014974117279, -0.19366800785064697, 2.938868284225464),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_01_r': Matrix(((-0.1129264384508133, -0.30849936604499817, -0.9444974660873413, -1.6729239225387573),
        (0.9614164233207703, -0.27391481399536133, -0.025481179356575012, -0.3988187611103058),
        (-0.2508507966995239, -0.9109331369400024, 0.3275284469127655, 3.1417577266693115),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_02_r': Matrix(((-0.12846022844314575, 0.08939197659492493, -0.9876774549484253, -1.7080131769180298),
        (0.9655994176864624, -0.21577484905719757, -0.14511799812316895, -0.42997652292251587),
        (-0.22608821094036102, -0.972342848777771, -0.05859863758087158, 3.038137197494507),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_03_r': Matrix(((-0.11921931803226471, 0.22759345173835754, -0.9664303660392761, -1.6995227336883545),
        (0.9638126492500305, -0.20722635090351105, -0.16769811511039734, -0.45049619674682617),
        (-0.2384367138147354, -0.951450765132904, -0.19465236365795135, 2.9456703662872314),
        (0.0, 0.0, 0.0, 1.0))), 'ring_01_r': Matrix(((-0.2704695165157318, -0.14330998063087463, -0.952002227306366, -1.6771655082702637),
        (0.897153377532959, -0.3962286710739136, -0.19524040818214417, -0.4717854857444763),
        (-0.34923064708709717, -0.9068989753723145, 0.23573851585388184, 3.1497790813446045),
        (0.0, 0.0, 0.0, 1.0))), 'ring_02_r': Matrix(((-0.27772432565689087, 0.2592666745185852, -0.9250134825706482, -1.6973901987075806),
        (0.9052048325538635, -0.25179392099380493, -0.3423510789871216, -0.5276962518692017),
        (-0.32167288661003113, -0.9324060678482056, -0.1647605150938034, 3.0218095779418945),
        (0.0, 0.0, 0.0, 1.0))), 'ring_03_r': Matrix(((-0.2689112424850464, 0.4100109338760376, -0.8715376257896423, -1.6686780452728271),
        (0.8889226317405701, -0.24272121489048004, -0.38846269249916077, -0.5555808544158936),
        (-0.3708144724369049, -0.879191517829895, -0.2991979122161865, 2.918551445007324),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_01_r': Matrix(((-0.8061825633049011, 0.2434541881084442, 0.5392581820487976, -1.47087562084198),
        (-0.43861961364746094, -0.8576086163520813, -0.2685520648956299, -0.46667683124542236),
        (0.39709222316741943, -0.4530315399169922, 0.7981733083724976, 3.332169771194458),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_02_r': Matrix(((-0.7903635501861572, 0.0638754814863205, 0.6092988848686218, -1.4408639669418335),
        (-0.4866843521595001, -0.6695384979248047, -0.5611206889152527, -0.5723855495452881),
        (0.3721071481704712, -0.74002605676651, 0.5602661371231079, 3.2763314247131348),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_03_r': Matrix(((-0.7667759656906128, -0.08451802283525467, 0.6363261342048645, -1.4325988292694092),
        (-0.4893597364425659, -0.5645735859870911, -0.6646680235862732, -0.659020185470581),
        (0.41542932391166687, -0.8210445046424866, 0.3915417194366455, 3.1805760860443115),
        (0.0, 0.0, 0.0, 1.0))), 'lowerarm_twist_01_r': Matrix(((-0.13146661221981049, -0.5123957395553589, -0.8486263751983643, -1.2781914472579956),
        (0.7110953330993652, -0.6451950073242188, 0.2794042229652405, -0.05019032955169678),
        (-0.6906951665878296, -0.5667224526405334, 0.449183851480484, 3.678013324737549),
        (0.0, 0.0, 0.0, 1.0))), 'upperarm_twist_01_r': Matrix(((-0.074361652135849, -0.588945746421814, -0.8047439455986023, -0.5044553279876709),
        (0.9967724680900574, -0.0683741569519043, -0.04206685721874237, 0.3081468641757965),
        (-0.030248412862420082, -0.8052751421928406, 0.5921294689178467, 4.756089210510254),
        (0.0, 0.0, 0.0, 1.0))), 'neck_01': Matrix(((1.0, 1.6813174852359225e-07, -3.3157419920826214e-08, 3.0941473028178734e-07),
        (4.891546723229112e-09, -0.22141002118587494, -0.9751809239387512, 0.22548344731330872),
        (-1.7130024332345783e-07, 0.975180983543396, -0.22141024470329285, 4.945338726043701),
        (0.0, 0.0, 0.0, 1.0))), 'head': Matrix(((1.0, 1.5692768329245155e-07, 4.7626436128211935e-09, 3.5955861221736996e-07),
        (4.4193262382918874e-09, 0.0021875351667404175, -0.9999977350234985, 0.15264689922332764),
        (-1.569377303667352e-07, 0.9999977946281433, 0.0021873414516448975, 5.25986385345459),
        (0.0, 0.0, 0.0, 1.0))), 'spine_04': Matrix(((1.0, 1.5512163997755124e-07, 1.4505690160149243e-07, 2.2538281996276055e-07),
        (1.182248539066677e-07, 0.16080479323863983, -0.9869863390922546, 0.04211437329649925),
        (-1.7642875604906294e-07, 0.986986517906189, 0.1608046293258667, 3.957427501678467),
        (0.0, 0.0, 0.0, 1.0))), 'spine_05': Matrix(((1.0, 1.5512158313413238e-07, 1.485358325226116e-07, 2.2538281996276055e-07),
        (1.169580130522263e-07, 0.18672679364681244, -0.9824119806289673, 0.14445115625858307),
        (-1.8012887892382423e-07, 0.9824120998382568, 0.1867266595363617, 4.584443092346191),
        (0.0, 0.0, 0.0, 1.0))), 'thigh_l': Matrix(((0.14466875791549683, 0.0675080344080925, 0.9871893525123596, 0.3200046420097351),
        (-0.989425003528595, -0.0018503591418266296, 0.1451553851366043, 0.10297611355781555),
        (0.011625580489635468, -0.9977171421051025, 0.06652387231588364, 3.0307652950286865),
        (0.0, 0.0, 0.0, 1.0))), 'calf_l': Matrix(((0.1365826427936554, 0.0467098131775856, 0.9895415902137756, 0.397309809923172),
        (-0.9872567057609558, 0.08893030136823654, 0.13210183382034302, 0.10352449864149094),
        (-0.08182699233293533, -0.9949424266815186, 0.058258604258298874, 1.623097538948059),
        (0.0, 0.0, 0.0, 1.0))), 'calf_twist_01_l': Matrix(((0.070191890001297, 0.07394029200077057, 0.9948040843009949, 0.4992711842060089),
        (-0.9836143255233765, 0.17123828828334808, 0.05670703202486038, 0.1591656357049942),
        (-0.1661500632762909, -0.9824523329734802, 0.08474511653184891, 1.0477813482284546),
        (0.0, 0.0, 0.0, 1.0))), 'foot_l': Matrix(((-0.9898257255554199, 0.14177680015563965, -0.013173159211874008, 0.4563150107860565),
        (-0.14104032516479492, -0.9888780117034912, -0.04757152870297432, 0.21526113152503967),
        (-0.019770119339227676, -0.04522796347737312, 0.998781144618988, 0.26789307594299316),
        (0.0, 0.0, 0.0, 1.0))), 'ball_l': Matrix(((-0.9901553392410278, 0.13960136473178864, 0.011527369730174541, 0.5100196003913879),
        (-0.14001226425170898, -0.9891685247421265, -0.04446752369403839, -0.2630292773246765),
        (0.005195053294301033, -0.04564210772514343, 0.9989444017410278, 0.02319321781396866),
        (0.0, 0.0, 0.0, 1.0))), 'thigh_twist_01_l': Matrix(((0.05418498069047928, 0.12228691577911377, 0.9910293221473694, 0.373029887676239),
        (-0.9982497096061707, 0.030845917761325836, 0.05080590397119522, 0.03790731728076935),
        (-0.024355340749025345, -0.9920157790184021, 0.12373986840248108, 2.3374691009521484),
        (0.0, 0.0, 0.0, 1.0))), 'thigh_r': Matrix(((0.14466889202594757, -0.0675080418586731, -0.9871892929077148, -0.32000458240509033),
        (0.9894249439239502, -0.0018503367900848389, 0.14515537023544312, 0.10297612100839615),
        (-0.011625565588474274, -0.9977171421051025, 0.06652389466762543, 3.0307652950286865),
        (0.0, 0.0, 0.0, 1.0))), 'calf_r': Matrix(((0.13658277690410614, -0.0467098094522953, -0.9895415306091309, -0.3973097801208496),
        (0.987256646156311, 0.08893029391765594, 0.13210181891918182, 0.10352452844381332),
        (0.08182698488235474, -0.9949424266815186, 0.058258626610040665, 1.623097538948059),
        (0.0, 0.0, 0.0, 1.0))), 'calf_twist_01_r': Matrix(((0.07019202411174774, -0.07394029200077057, -0.9948040246963501, -0.4992711842060089),
        (0.9836142659187317, 0.17123828828334808, 0.056707024574279785, 0.1591656506061554),
        (0.16615010797977448, -0.9824523329734802, 0.08474515378475189, 1.0477813482284546),
        (0.0, 0.0, 0.0, 1.0))), 'foot_r': Matrix(((-0.9898258447647095, -0.14177681505680084, 0.013173144310712814, -0.45631498098373413),
        (0.14104008674621582, -0.9888781309127808, -0.04757152497768402, 0.21526116132736206),
        (0.01977011188864708, -0.04522797837853432, 0.998781144618988, 0.2678929567337036),
        (0.0, 0.0, 0.0, 1.0))), 'ball_r': Matrix(((-0.9901554584503174, -0.13960137963294983, -0.011527369730174541, -0.5100196003913879),
        (0.14001202583312988, -0.9891685843467712, -0.0444675050675869, -0.2630293369293213),
        (-0.005195043981075287, -0.04564209654927254, 0.9989444017410278, 0.02319309115409851),
        (0.0, 0.0, 0.0, 1.0))), 'thigh_twist_01_r': Matrix(((0.05418234318494797, -0.12228637933731079, -0.9910295605659485, -0.37302982807159424),
        (0.9982498288154602, 0.030846010893583298, 0.05080311745405197, 0.03790723532438278),
        (0.024355806410312653, -0.9920158982276917, 0.12373930215835571, 2.337475061416626),
        (0.0, 0.0, 0.0, 1.0))), 'ik_foot_l': Matrix(((-0.04613957554101944, 0.014827612787485123, -0.9988250136375427, 0.4563155770301819),
        (0.9980453252792358, 0.04287634789943695, -0.045467063784599304, 0.21521075069904327),
        (0.042151790112257004, -0.9989704489707947, -0.016777023673057556, 0.2678888440132141),
        (0.0, 0.0, 0.0, 1.0))), 'ik_foot_r': Matrix(((-0.04613957554101944, -0.014827612787485123, 0.9988250136375427, -0.4563155770301819),
        (-0.9980453252792358, 0.04287634789943695, -0.045467063784599304, 0.21521075069904327),
        (-0.042151790112257004, -0.9989704489707947, -0.016777023673057556, 0.2678888440132141),
        (0.0, 0.0, 0.0, 1.0)))}

matrix_manny_coords_legacy = {'pelvis': Matrix(((1.0, 1.6488741039211163e-07, 1.317686724178202e-07, 2.1641257532525783e-18),
        (1.1738873695321672e-07, 0.08436184376478195, -0.996435284614563, 0.12915651500225067),
        (-1.7541587737923692e-07, 0.996435284614563, 0.08436161279678345, 3.0915963649749756),
        (0.0, 0.0, 0.0, 1.0))), 'spine_01': Matrix(((1.0, 1.6357644483377953e-07, 8.277370966425224e-08, 5.67650246807716e-08),
        (1.1395330545838078e-07, -0.2009320855140686, -0.9796052575111389, 0.09487602859735489),
        (-1.4360843181293603e-07, 0.9796051979064941, -0.20093229413032532, 3.2162325382232666),
        (0.0, 0.0, 0.0, 1.0))), 'spine_02': Matrix(((1.0, 1.637162512224677e-07, 1.0006669981521554e-07, 1.5572713607525657e-07),
        (1.177695096998832e-07, -0.11197507381439209, -0.9937111139297485, 0.049215417355298996),
        (-1.5148164322908997e-07, 0.9937111735343933, -0.11197525262832642, 3.435349464416504),
        (0.0, 0.0, 0.0, 1.0))), 'spine_03': Matrix(((1.0, 1.5512181050780782e-07, 1.3192774872550217e-07, 2.2538281996276055e-07),
        (1.212024329788619e-07, 0.06721770018339157, -0.9977384209632874, 0.022080184891819954),
        (-1.6363883048597927e-07, 0.9977385997772217, 0.06721752882003784, 3.6793856620788574),
        (0.0, 0.0, 0.0, 1.0))), 'clavicle_l': Matrix(((0.010669793002307415, 0.9872484803199768, -0.15882959961891174, 0.10811559110879898),
        (0.9999431371688843, -0.010534497909247875, 0.0016943886876106262, 0.31347379088401794),
        (-1.9371509552001953e-07, -0.15883871912956238, -0.9873048663139343, 4.832284927368164),
        (0.0, 0.0, 0.0, 1.0))), 'upperarm_l': Matrix(((0.07435979694128036, 0.588944673538208, -0.8047453761100769, 0.496448278427124),
        (0.9967726469039917, -0.06837191432714462, 0.04206627234816551, 0.3093300759792328),
        (-0.030247073620557785, -0.8052763938903809, -0.5921280384063721, 4.769805908203125),
        (0.0, 0.0, 0.0, 1.0))), 'lowerarm_l': Matrix(((0.32608574628829956, 0.5123957395553589, -0.7944300174713135, 1.0496891736984253),
        (0.75669264793396, -0.6451948881149292, -0.1055452972650528, 0.2375360131263733),
        (-0.5666431188583374, -0.5667228698730469, -0.5981149077415466, 3.930741548538208),
        (0.0, 0.0, 0.0, 1.0))), 'hand_l': Matrix(((-0.5013784766197205, 0.49519476294517517, 0.7095082998275757, 1.4899673461914062),
        (-0.7698531746864319, -0.6295901536941528, -0.1046050414443016, -0.31685030460357666),
        (0.39489954710006714, -0.5986643433570862, 0.696890115737915, 3.4437828063964844),
        (0.0, 0.0, 0.0, 1.0))), 'index_01_l': Matrix(((-0.7032927870750427, 0.10674980282783508, 0.7028399705886841, 1.6067826747894287),
        (-0.6364066004753113, -0.5351284742355347, -0.5555394887924194, -0.6047245264053345),
        (0.31680598855018616, -0.8379992246627808, 0.4442880153656006, 3.2010366916656494),
        (0.0, 0.0, 0.0, 1.0))), 'index_02_l': Matrix(((-0.7199912071228027, -0.07695905864238739, 0.6897029876708984, 1.6213617324829102),
        (-0.6243133544921875, -0.36217576265335083, -0.6921426057815552, -0.6778081655502319),
        (0.3030604124069214, -0.9289276599884033, 0.2127164751291275, 3.0865893363952637),
        (0.0, 0.0, 0.0, 1.0))), 'index_03_l': Matrix(((-0.7341529130935669, -0.2540583610534668, 0.6296617984771729, 1.6130421161651611),
        (-0.6035287976264954, -0.18070413172245026, -0.776594340801239, -0.7169609665870667),
        (0.3110828399658203, -0.9501582384109497, -0.020667463541030884, 2.986168146133423),
        (0.0, 0.0, 0.0, 1.0))), 'middle_01_l': Matrix(((-0.5201456546783447, 0.1532326638698578, 0.8402193188667297, 1.6629900932312012),
        (-0.7828629016876221, -0.47881677746772766, -0.3973159193992615, -0.5440884828567505),
        (0.34142929315567017, -0.8644390106201172, 0.3690144121646881, 3.1743881702423096),
        (0.0, 0.0, 0.0, 1.0))), 'middle_02_l': Matrix(((-0.4889768064022064, -0.2680269181728363, 0.8300985097885132, 1.6856398582458496),
        (-0.7919379472732544, -0.2625509798526764, -0.5512721538543701, -0.6148637533187866),
        (0.3656989336013794, -0.9269459247589111, -0.08387964963912964, 3.0466129779815674),
        (0.0, 0.0, 0.0, 1.0))), 'middle_03_l': Matrix(((-0.5007588863372803, -0.36679983139038086, 0.7840272784233093, 1.6544874906539917),
        (-0.7852980494499207, -0.18845587968826294, -0.589738130569458, -0.6453796625137329),
        (0.364070326089859, -0.9110119342803955, -0.19367656111717224, 2.938875436782837),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_01_l': Matrix(((-0.11292803287506104, 0.3084990084171295, 0.9444977045059204, 1.672929286956787),
        (-0.9614164233207703, -0.27391403913497925, -0.02548319101333618, -0.3988150954246521),
        (0.2508494257926941, -0.9109337329864502, 0.32752832770347595, 3.1417605876922607),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_02_l': Matrix(((-0.12845945358276367, -0.08939176797866821, 0.9876779317855835, 1.7080206871032715),
        (-0.9655993580818176, -0.21577493846416473, -0.14511717855930328, -0.42997249960899353),
        (0.22608821094036102, -0.9723429679870605, -0.05859866738319397, 3.0381429195404053),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_03_l': Matrix(((-0.11921872943639755, -0.22759488224983215, 0.9664304256439209, 1.6995195150375366),
        (-0.9638127088546753, -0.20722588896751404, -0.1676977574825287, -0.45049336552619934),
        (0.23843634128570557, -0.9514507055282593, -0.1946539729833603, 2.9456703662872314),
        (0.0, 0.0, 0.0, 1.0))), 'ring_01_l': Matrix(((-0.27046990394592285, 0.14330977201461792, 0.9520024061203003, 1.677168369293213),
        (-0.8971534371376038, -0.3962278664112091, -0.19524088501930237, -0.4717802405357361),
        (0.3492298126220703, -0.9068993330001831, 0.23573830723762512, 3.1497862339019775),
        (0.0, 0.0, 0.0, 1.0))), 'ring_02_l': Matrix(((-0.2777216136455536, -0.25926917791366577, 0.9250137805938721, 1.6973918676376343),
        (-0.9052053689956665, -0.25179383158683777, -0.3423490524291992, -0.5276948809623718),
        (0.3216731548309326, -0.9324053525924683, -0.16476358473300934, 3.0218069553375244),
        (0.0, 0.0, 0.0, 1.0))), 'ring_03_l': Matrix(((-0.268889844417572, -0.4100281596183777, 0.8715362548828125, 1.6686794757843018),
        (-0.8889281749725342, -0.24272246658802032, -0.38844847679138184, -0.555579423904419),
        (0.37081608176231384, -0.8791831731796265, -0.29922032356262207, 2.918549060821533),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_01_l': Matrix(((-0.8061848878860474, -0.24345481395721436, -0.5392549633979797, 1.4708759784698486),
        (0.4386190176010132, -0.8576083779335022, -0.26855382323265076, -0.4666716754436493),
        (-0.39708855748176575, -0.4530317485332489, 0.798175036907196, 3.3321752548217773),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_02_l': Matrix(((-0.7903618216514587, -0.06387282907962799, -0.6093018054962158, 1.4408669471740723),
        (0.48668357729911804, -0.6695409417152405, -0.5611183643341064, -0.5723832845687866),
        (-0.3721120357513428, -0.7400239706039429, 0.5602656602859497, 3.2763330936431885),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_03_l': Matrix(((-0.7667809724807739, 0.08451055735349655, -0.6363216042518616, 1.4326019287109375),
        (0.48936033248901367, -0.5645702481269836, -0.6646703481674194, -0.6590176820755005),
        (-0.41541972756385803, -0.8210473656654358, 0.391545832157135, 3.1805777549743652),
        (0.0, 0.0, 0.0, 1.0))), 'lowerarm_twist_01_l': Matrix(((-0.32608652114868164, 0.5123959183692932, 0.7944296002388, 1.2781919240951538),
        (-0.75669264793396, -0.6451950073242188, 0.10554482042789459, -0.05018860101699829),
        (0.566642701625824, -0.566722571849823, 0.5981155633926392, 3.678011655807495),
        (0.0, 0.0, 0.0, 1.0))), 'upperarm_twist_01_l': Matrix(((-0.07435942441225052, 0.5889453291893005, 0.8047448992729187, 0.5044553875923157),
        (-0.9967726469039917, -0.06837185472249985, -0.0420658253133297, 0.3081468939781189),
        (0.030247226357460022, -0.8052759170532227, 0.5921286940574646, 4.756089210510254),
        (0.0, 0.0, 0.0, 1.0))), 'clavicle_r': Matrix(((0.010669918730854988, -0.9872482419013977, 0.15882958471775055, -0.10811560600996017),
        (-0.9999431371688843, -0.01053444854915142, 0.0016944333910942078, 0.31347376108169556),
        (1.7881393432617188e-07, -0.1588386744260788, -0.9873047471046448, 4.832284927368164),
        (0.0, 0.0, 0.0, 1.0))), 'upperarm_r': Matrix(((0.07435993105173111, -0.5889445543289185, 0.8047451376914978, -0.496448278427124),
        (-0.9967726469039917, -0.06837191432714462, 0.04206624999642372, 0.3093300461769104),
        (0.03024710714817047, -0.8052762150764465, -0.5921280980110168, 4.769805908203125),
        (0.0, 0.0, 0.0, 1.0))), 'lowerarm_r': Matrix(((0.32608562707901, -0.5123956203460693, 0.7944298386573792, -1.0496890544891357),
        (-0.75669264793396, -0.6451947689056396, -0.10554535686969757, 0.2375359982252121),
        (0.5666429996490479, -0.5667228102684021, -0.5981148481369019, 3.930741786956787),
        (0.0, 0.0, 0.0, 1.0))), 'hand_r': Matrix(((-0.5013784766197205, -0.49519452452659607, -0.7095081806182861, -1.4899685382843018),
        (0.7698531150817871, -0.6295902729034424, -0.10460494458675385, -0.3168542981147766),
        (-0.3948996365070343, -0.5986641645431519, 0.696890115737915, 3.4437830448150635),
        (0.0, 0.0, 0.0, 1.0))), 'index_01_r': Matrix(((-0.7032915353775024, -0.1067514717578888, -0.7028406858444214, -1.6067745685577393),
        (0.6364078521728516, -0.535129189491272, -0.5555374026298523, -0.6047250032424927),
        (-0.3168061375617981, -0.8379984498023987, 0.4442891776561737, 3.2010345458984375),
        (0.0, 0.0, 0.0, 1.0))), 'index_02_r': Matrix(((-0.7199907302856445, 0.07695894688367844, -0.6897032856941223, -1.6213587522506714),
        (0.62431401014328, -0.36217546463012695, -0.6921422481536865, -0.6778122782707214),
        (-0.3030601441860199, -0.9289277195930481, 0.2127162367105484, 3.086583375930786),
        (0.0, 0.0, 0.0, 1.0))), 'index_03_r': Matrix(((-0.734153687953949, 0.25405675172805786, -0.6296613812446594, -1.6130417585372925),
        (0.6035284399986267, -0.18070434033870697, -0.7765946388244629, -0.7169672250747681),
        (-0.3110816776752472, -0.9501586556434631, -0.020666003227233887, 2.9861626625061035),
        (0.0, 0.0, 0.0, 1.0))), 'middle_01_r': Matrix(((-0.5201449990272522, -0.15323379635810852, -0.8402193188667297, -1.6629858016967773),
        (0.7828632593154907, -0.4788174331188202, -0.39731451869010925, -0.5440897941589355),
        (-0.34142956137657166, -0.8644384145736694, 0.36901557445526123, 3.1743898391723633),
        (0.0, 0.0, 0.0, 1.0))), 'middle_02_r': Matrix(((-0.4889824390411377, 0.26802441477775574, -0.8300957679748535, -1.6856329441070557),
        (0.7919356822967529, -0.26254916191101074, -0.5512763261795044, -0.6148666143417358),
        (-0.36569643020629883, -0.9269472360610962, -0.08387637138366699, 3.0466084480285645),
        (0.0, 0.0, 0.0, 1.0))), 'middle_03_r': Matrix(((-0.5007656812667847, 0.36679184436798096, -0.7840263247489929, -1.654480218887329),
        (0.7852954268455505, -0.18845587968826294, -0.5897416472434998, -0.6453829407691956),
        (-0.3640667200088501, -0.9110150933265686, -0.1936679482460022, 2.938868522644043),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_01_r': Matrix(((-0.11292673647403717, -0.308499276638031, -0.9444975256919861, -1.6729240417480469),
        (0.9614163041114807, -0.2739148437976837, -0.025481238961219788, -0.39881858229637146),
        (-0.2508508563041687, -0.910933256149292, 0.3275284767150879, 3.1417579650878906),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_02_r': Matrix(((-0.12846048176288605, 0.08939194679260254, -0.9876774549484253, -1.7080132961273193),
        (0.9655992984771729, -0.21577481925487518, -0.14511798322200775, -0.42997634410858154),
        (-0.2260882407426834, -0.9723429679870605, -0.05859851837158203, 3.038137435913086),
        (0.0, 0.0, 0.0, 1.0))), 'pinky_03_r': Matrix(((-0.11921956390142441, 0.22759345173835754, -0.9664303660392761, -1.699522852897644),
        (0.963812530040741, -0.20722636580467224, -0.16769810020923615, -0.45049601793289185),
        (-0.23843680322170258, -0.9514508843421936, -0.19465228915214539, 2.9456706047058105),
        (0.0, 0.0, 0.0, 1.0))), 'ring_01_r': Matrix(((-0.2704697847366333, -0.14330992102622986, -0.9520021677017212, -1.6771656274795532),
        (0.8971531391143799, -0.39622873067855835, -0.19524040818214417, -0.471785306930542),
        (-0.3492306172847748, -0.9068989753723145, 0.23573869466781616, 3.1497793197631836),
        (0.0, 0.0, 0.0, 1.0))), 'ring_02_r': Matrix(((-0.2777245044708252, 0.25926673412323, -0.9250133633613586, -1.6973903179168701),
        (0.9052045941352844, -0.25179392099380493, -0.3423510193824768, -0.5276960730552673),
        (-0.32167279720306396, -0.9324060678482056, -0.16476042568683624, 3.0218098163604736),
        (0.0, 0.0, 0.0, 1.0))), 'ring_03_r': Matrix(((-0.2689113914966583, 0.4100109934806824, -0.8715375065803528, -1.6686781644821167),
        (0.888922393321991, -0.24272119998931885, -0.3884626030921936, -0.5555806756019592),
        (-0.37081435322761536, -0.8791915774345398, -0.29919785261154175, 2.9185516834259033),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_01_r': Matrix(((-0.8061826229095459, 0.24345406889915466, 0.5392582416534424, -1.4708757400512695),
        (-0.4386192262172699, -0.8576086163520813, -0.26855212450027466, -0.4666766822338104),
        (0.39709240198135376, -0.45303142070770264, 0.798173189163208, 3.332170009613037),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_02_r': Matrix(((-0.7903634905815125, 0.0638754814863205, 0.6092989444732666, -1.440864086151123),
        (-0.4866841435432434, -0.6695384383201599, -0.5611207485198975, -0.5723853707313538),
        (0.37210720777511597, -0.7400259971618652, 0.5602660179138184, 3.276331663131714),
        (0.0, 0.0, 0.0, 1.0))), 'thumb_03_r': Matrix(((-0.766775906085968, -0.08451803028583527, 0.6363261938095093, -1.4325989484786987),
        (-0.4893594980239868, -0.5645734667778015, -0.6646681427955627, -0.6590200066566467),
        (0.41542935371398926, -0.8210443258285522, 0.3915417194366455, 3.1805763244628906),
        (0.0, 0.0, 0.0, 1.0))), 'lowerarm_twist_01_r': Matrix(((-0.13146671652793884, -0.5123957395553589, -0.8486265540122986, -1.2781915664672852),
        (0.71109539270401, -0.6451950073242188, 0.2794041633605957, -0.050190240144729614),
        (-0.6906951665878296, -0.5667224526405334, 0.44918400049209595, 3.678013563156128),
        (0.0, 0.0, 0.0, 1.0))), 'upperarm_twist_01_r': Matrix(((-0.07436171919107437, -0.588945746421814, -0.8047441244125366, -0.5044554471969604),
        (0.9967725276947021, -0.0683741420507431, -0.04206676036119461, 0.3081468641757965),
        (-0.030248481780290604, -0.8052751421928406, 0.5921294689178467, 4.756089210510254),
        (0.0, 0.0, 0.0, 1.0))), 'neck_01': Matrix(((1.0, 1.6813174852359225e-07, -3.3157419920826214e-08, 3.0941473028178734e-07),
        (4.891546723229112e-09, -0.22141002118587494, -0.9751809239387512, 0.22548344731330872),
        (-1.7130024332345783e-07, 0.975180983543396, -0.22141024470329285, 4.945338726043701),
        (0.0, 0.0, 0.0, 1.0))), 'head': Matrix(((1.0, 1.5692768329245155e-07, 4.7626436128211935e-09, 3.5955861221736996e-07),
        (4.4193262382918874e-09, 0.0021875351667404175, -0.9999977350234985, 0.15264689922332764),
        (-1.569377303667352e-07, 0.9999977946281433, 0.0021873414516448975, 5.25986385345459),
        (0.0, 0.0, 0.0, 1.0))), 'spine_04': Matrix(((1.0, 1.5512163997755124e-07, 1.4505690160149243e-07, 2.2538281996276055e-07),
        (1.182248539066677e-07, 0.16080479323863983, -0.9869863390922546, 0.04211437329649925),
        (-1.7642875604906294e-07, 0.986986517906189, 0.1608046293258667, 3.957427501678467),
        (0.0, 0.0, 0.0, 1.0))), 'spine_05': Matrix(((1.0, 1.5512158313413238e-07, 1.485358325226116e-07, 2.2538281996276055e-07),
        (1.169580130522263e-07, 0.18672679364681244, -0.9824119806289673, 0.14445115625858307),
        (-1.8012887892382423e-07, 0.9824120998382568, 0.1867266595363617, 4.584443092346191),
        (0.0, 0.0, 0.0, 1.0))), 'thigh_l': Matrix(((0.14466875791549683, 0.0675080344080925, 0.9871893525123596, 0.3200046420097351),
        (-0.989425003528595, -0.0018503591418266296, 0.1451553851366043, 0.10297611355781555),
        (0.011625580489635468, -0.9977171421051025, 0.06652387231588364, 3.0307652950286865),
        (0.0, 0.0, 0.0, 1.0))), 'calf_l': Matrix(((0.1365826427936554, 0.0467098131775856, 0.9895415902137756, 0.397309809923172),
        (-0.9872567057609558, 0.08893030136823654, 0.13210183382034302, 0.10352449864149094),
        (-0.08182699233293533, -0.9949424266815186, 0.058258604258298874, 1.623097538948059),
        (0.0, 0.0, 0.0, 1.0))), 'calf_twist_01_l': Matrix(((0.070191890001297, 0.07394029200077057, 0.9948040843009949, 0.4992711842060089),
        (-0.9836143255233765, 0.17123828828334808, 0.05670703202486038, 0.1591656357049942),
        (-0.1661500632762909, -0.9824523329734802, 0.08474511653184891, 1.0477813482284546),
        (0.0, 0.0, 0.0, 1.0))), 'foot_l': Matrix(((0.9898257255554199, 0.14177680015563965, 0.013173084706068039, 0.4563150107860565),
        (0.1410403549671173, -0.9888780117034912, 0.047571513801813126, 0.21526113152503967),
        (0.01977003738284111, -0.04522796347737312, -0.998781144618988, 0.26789307594299316),
        (0.0, 0.0, 0.0, 1.0))), 'ball_l': Matrix(((0.9901553392410278, 0.13960136473178864, -0.011527390219271183, 0.5100196003913879),
        (0.14001229405403137, -0.9891685247421265, 0.044467516243457794, -0.2630292475223541),
        (-0.005195079371333122, -0.04564210772514343, -0.9989444017410278, 0.023193221539258957),
        (0.0, 0.0, 0.0, 1.0))), 'thigh_twist_01_l': Matrix(((0.05418498069047928, 0.12228691577911377, 0.9910293221473694, 0.373029887676239),
        (-0.9982497096061707, 0.030845917761325836, 0.05080590397119522, 0.03790731728076935),
        (-0.024355340749025345, -0.9920157790184021, 0.12373986840248108, 2.3374691009521484),
        (0.0, 0.0, 0.0, 1.0))), 'thigh_r': Matrix(((0.14466889202594757, -0.0675080418586731, -0.9871892929077148, -0.32000458240509033),
        (0.9894249439239502, -0.0018503367900848389, 0.14515537023544312, 0.10297612100839615),
        (-0.011625565588474274, -0.9977171421051025, 0.06652389466762543, 3.0307652950286865),
        (0.0, 0.0, 0.0, 1.0))), 'calf_r': Matrix(((0.13658277690410614, -0.0467098094522953, -0.9895415306091309, -0.3973097801208496),
        (0.987256646156311, 0.08893029391765594, 0.13210181891918182, 0.10352452844381332),
        (0.08182698488235474, -0.9949424266815186, 0.058258626610040665, 1.623097538948059),
        (0.0, 0.0, 0.0, 1.0))), 'calf_twist_01_r': Matrix(((0.07019202411174774, -0.07394029200077057, -0.9948040246963501, -0.4992711842060089),
        (0.9836142659187317, 0.17123828828334808, 0.056707024574279785, 0.1591656506061554),
        (0.16615010797977448, -0.9824523329734802, 0.08474515378475189, 1.0477813482284546),
        (0.0, 0.0, 0.0, 1.0))), 'foot_r': Matrix(((0.9898257851600647, -0.14177684485912323, -0.013173054903745651, -0.45631498098373413),
        (-0.14104032516479492, -0.9888782501220703, 0.04757152497768402, 0.21526116132736206),
        (-0.019770033657550812, -0.04522797837853432, -0.9987812042236328, 0.2678929567337036),
        (0.0, 0.0, 0.0, 1.0))), 'ball_r': Matrix(((0.9901553988456726, -0.13960137963294983, 0.011527388356626034, -0.5100196003913879),
        (-0.1400122493505478, -0.9891687035560608, 0.0444675087928772, -0.26302939653396606),
        (0.0051950570195913315, -0.04564209654927254, -0.9989444613456726, 0.023193078115582466),
        (0.0, 0.0, 0.0, 1.0))), 'thigh_twist_01_r': Matrix(((0.05418234318494797, -0.12228637933731079, -0.9910295605659485, -0.37302982807159424),
        (0.9982498288154602, 0.030846010893583298, 0.05080311745405197, 0.03790723532438278),
        (0.024355806410312653, -0.9920158982276917, 0.12373930215835571, 2.337475061416626),
        (0.0, 0.0, 0.0, 1.0))), 'ik_foot_l': Matrix(((-0.04613957554101944, 0.014827612787485123, -0.9988250136375427, 0.4563155770301819),
        (0.9980453252792358, 0.04287634789943695, -0.045467063784599304, 0.21521075069904327),
        (0.042151790112257004, -0.9989704489707947, -0.016777023673057556, 0.2678888440132141),
        (0.0, 0.0, 0.0, 1.0))), 'ik_foot_r': Matrix(((-0.04613957554101944, -0.014827612787485123, 0.9988250136375427, -0.4563155770301819),
        (-0.9980453252792358, 0.04287634789943695, -0.045467063784599304, 0.21521075069904327),
        (-0.042151790112257004, -0.9989704489707947, -0.016777023673057556, 0.2678888440132141),
        (0.0, 0.0, 0.0, 1.0)))}