/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain;

import com.asprise.util.jtwain.JTwainException;
import com.asprise.util.jtwain.Source;
import com.asprise.util.jtwain.lowlevel.Control;

public class SourceManager {
    private static String libraryName = "AspriseJTwain";
    private static boolean libraryLoaded = false;
    private static String libraryPath = null;
    private static SourceManager instance = null;

    public static SourceManager instance() throws JTwainException {
        if (instance == null) {
            instance = new SourceManager();
        }
        return instance;
    }

    protected SourceManager() throws JTwainException {
        SourceManager.init();
    }

    public boolean isTwainAvailable() {
        return true;
    }

    public native String getJTwainDLLVersion();

    public native Source[] getAllSources();

    public native Source getDefaultSource();

    public void openSource(Source source) throws JTwainException {
        Control.openDataSource(source);
    }

    public Source getCurrentSource() {
        return Control.getCurrentSource();
    }

    public int getState() throws JTwainException {
        return Control.getState(null);
    }

    public void closeSource() throws JTwainException {
        Control.closeSource();
    }

    public static void closeSourceManager() {
        try {
            Control.unloadSourceManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void unloadSourceManager() {
        try {
            Control.unloadSourceManager();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public Source selectSourceUI() {
        return this.selectSource((String)null);
    }

    public Source selectSource(Source source) {
        if (source != null) {
            return this.selectSource(source.getSourceName());
        }
        return this.selectSource((String)null);
    }

    public Source selectSourceByName(String sourceName) {
        return this.selectSource(sourceName);
    }

    private native Source selectSource(String var1);

    public static void setLibraryPath(String libraryPath) {
        SourceManager.libraryPath = libraryPath;
    }

    public static String getLibraryPath() {
        return libraryPath;
    }

    private static void init() {
        if (libraryLoaded) {
            return;
        }
        if (libraryPath != null) {
            try {
                System.load(libraryPath);
                libraryLoaded = true;
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        System.loadLibrary(libraryName);
        libraryLoaded = true;
    }
}

