/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain.lowlevel;

import com.asprise.util.jtwain.JTwainConstants;
import com.asprise.util.jtwain.lowlevel.ItemType;

public class ItemTypeString
extends ItemType
implements JTwainConstants {
    private String value;

    public ItemTypeString(int type) {
        this(type, null);
    }

    public ItemTypeString(int type, String value) {
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.setItemTypeCode(type);
                this.setString(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + type);
            }
        }
    }

    public String getString() {
        return this.value;
    }

    public String getValue() {
        return this.getString();
    }

    public void setString(String value) {
        if (value == null) {
            return;
        }
        switch (this.getItemTypeCode()) {
            case 9: {
                if (value.length() <= 31) break;
                throw new IllegalArgumentException("String lenth is too long. Max is 31, actual is: " + value.length());
            }
            case 10: {
                if (value.length() <= 63) break;
                throw new IllegalArgumentException("String lenth is too long. Max is 63, actual is: " + value.length());
            }
            case 11: {
                if (value.length() <= 127) break;
                throw new IllegalArgumentException("String lenth is too long. Max is 127, actual is: " + value.length());
            }
            case 12: {
                if (value.length() <= 254) break;
                throw new IllegalArgumentException("String lenth is too long. Max is 254, actual is: " + value.length());
            }
            case 13: {
                if (value.length() <= 1023) break;
                throw new IllegalArgumentException("String lenth is too long. Max is 1023, actual is: " + value.length());
            }
            case 14: {
                if (value.length() <= 511) break;
                throw new IllegalArgumentException("String lenth is too long. Max is 511, actual is: " + value.length());
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + this.getItemTypeCode());
            }
        }
    }

    public String toString() {
        return String.valueOf(this.value) + "\t[" + ItemType.getTypeRepresentation(this.getItemTypeCode()) + "]";
    }

    public Object getObject() {
        return this.getValue();
    }
}

