/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain.lowlevel;

import com.asprise.util.jtwain.lowlevel.ItemType;
import com.asprise.util.jtwain.lowlevel.ItemTypeFix32;
import com.asprise.util.jtwain.lowlevel.ItemTypeFrame;
import com.asprise.util.jtwain.lowlevel.ItemTypeInteger;
import com.asprise.util.jtwain.lowlevel.ItemTypeString;
import com.asprise.util.jtwain.lowlevel.ValueContainer;
import java.util.Vector;

public class ValueContainerArray
extends ValueContainer {
    Vector vec = new Vector();

    public void pushItem(ItemType item) {
        if (item == null) {
            System.err.println("ValueContainerArray.pushItem: item is null!");
            return;
        }
        if (this.vec.size() != 0) {
            ItemType org = (ItemType)this.vec.elementAt(0);
            if (org.getItemTypeCode() != item.getItemTypeCode()) {
                throw new IllegalArgumentException("Inconsistent type!");
            }
        } else {
            this.setItemType(item.getItemTypeCode());
        }
        this.vec.add(item);
    }

    public Object popItem() {
        if (this.vec.isEmpty()) {
            return null;
        }
        return this.vec.remove(this.vec.size() - 1);
    }

    public int size() {
        return this.vec.size();
    }

    public int getNumItems() {
        return this.size();
    }

    public ItemType getItem(int index) {
        if (index >= this.vec.size()) {
            return null;
        }
        return (ItemType)this.vec.elementAt(index);
    }

    public int getContainerType() {
        return 3;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ValueContainerArray [" + ItemType.getTypeRepresentation(this.getItemType()) + "]\n");
        sb.append(" - size:\t" + this.size() + "\n");
        int i = 0;
        while (i < this.size()) {
            sb.append(" (" + i + ")\t" + this.getItem(i) + "\n");
            ++i;
        }
        return sb.toString();
    }

    public Object getObject() {
        if (this.size() == 0) {
            return null;
        }
        ItemType item = this.getItem(0);
        if (item instanceof ItemTypeFix32) {
            Double[] doubles = new Double[this.size()];
            int i = 0;
            while (i < this.size()) {
                doubles[i] = (Double)this.getItem(i).getObject();
                ++i;
            }
            return doubles;
        }
        if (item instanceof ItemTypeInteger) {
            Long[] integers = new Long[this.size()];
            int i = 0;
            while (i < this.size()) {
                integers[i] = (Long)this.getItem(i).getObject();
                ++i;
            }
            return integers;
        }
        if (item instanceof ItemTypeString) {
            String[] strings = new String[this.size()];
            int i = 0;
            while (i < this.size()) {
                strings[i] = (String)this.getItem(i).getObject();
                ++i;
            }
            return strings;
        }
        if (item instanceof ItemTypeFrame) {
            Double[][] doubles = new Double[this.size()][4];
            int i = 0;
            while (i < this.size()) {
                doubles[i] = (Double[])this.getItem(i).getObject();
                ++i;
            }
            return doubles;
        }
        return null;
    }
}

