/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain.lowlevel;

import com.asprise.util.jtwain.lowlevel.ItemType;
import com.asprise.util.jtwain.lowlevel.ItemTypeFix32;
import com.asprise.util.jtwain.lowlevel.ItemTypeFrame;
import com.asprise.util.jtwain.lowlevel.ItemTypeInteger;
import com.asprise.util.jtwain.lowlevel.ItemTypeString;
import com.asprise.util.jtwain.lowlevel.ValueContainerArray;

public class ValueContainerEnumeration
extends ValueContainerArray {
    int currentIndex;
    int defaultIndex;

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public int getDefaultIndex() {
        return this.defaultIndex;
    }

    public void setCurrentIndex(ItemTypeInteger i) {
        this.setCurrentIndex((int)i.getValue());
    }

    public void setDefaultIndex(ItemTypeInteger i) {
        this.setDefaultIndex((int)i.getValue());
    }

    public void setCurrentIndex(int i) {
        if (i < 0 || i >= this.getNumItems()) {
            throw new IndexOutOfBoundsException("can not set current index to " + i);
        }
        this.currentIndex = i;
    }

    public void setDefaultIndex(int i) {
        if (i < 0 || i >= this.getNumItems()) {
            throw new IndexOutOfBoundsException("can not set default index to " + i);
        }
        this.defaultIndex = i;
    }

    public int getContainerType() {
        return 4;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ValueContainerEnumeration [" + ItemType.getTypeRepresentation(this.getItemType()) + "]\n");
        sb.append(" - size:\t" + this.size() + "\n");
        sb.append(" - defaultIndex:\t" + this.getDefaultIndex() + "\n");
        sb.append(" - currentIndex:\t" + this.getCurrentIndex() + "\n");
        int i = 0;
        while (i < this.size()) {
            sb.append(" (" + i + ")\t" + this.getItem(i) + "\n");
            ++i;
        }
        return sb.toString();
    }

    public Object getObject() {
        if (this.size() == 0) {
            return null;
        }
        ItemType item = this.getItem(0);
        if (item instanceof ItemTypeFix32) {
            Double[] doubles = new Double[this.size()];
            int i = 0;
            while (i < this.size()) {
                doubles[i] = (Double)this.getItem(i).getObject();
                ++i;
            }
            return doubles;
        }
        if (item instanceof ItemTypeInteger) {
            Long[] integers = new Long[this.size()];
            int i = 0;
            while (i < this.size()) {
                integers[i] = (Long)this.getItem(i).getObject();
                ++i;
            }
            return integers;
        }
        if (item instanceof ItemTypeString) {
            String[] strings = new String[this.size()];
            int i = 0;
            while (i < this.size()) {
                strings[i] = (String)this.getItem(i).getObject();
                ++i;
            }
            return strings;
        }
        if (item instanceof ItemTypeFrame) {
            Double[][] doubles = new Double[this.size()][4];
            int i = 0;
            while (i < this.size()) {
                doubles[i] = (Double[])this.getItem(i).getObject();
                ++i;
            }
            return doubles;
        }
        return null;
    }
}

