/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.jtwain.web;

import com.asprise.util.jtwain.Source;
import com.asprise.util.jtwain.SourceManager;
import com.asprise.util.jtwain.web.FileUploader;
import com.asprise.util.jtwain.web.ImageDisplayPanel;
import com.asprise.util.jtwain.web.UploadApplet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class UploadAppletSimple
extends UploadApplet {
    private JPanel jContentPane = null;
    private JLabel labelTitle = null;
    private JScrollPane scrollPane = null;
    private JPanel panelButtons = null;
    private JButton buttonScan = null;
    private JButton buttonSubmit = null;
    private ImageDisplayPanel imageDisplayPanel = null;

    public void init() {
        this.setSize(300, 200);
        this.setContentPane(this.getJContentPane());
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getImageDisplayPanel());
        }
        return this.scrollPane;
    }

    private JPanel getPanelButtons() {
        if (this.panelButtons == null) {
            this.panelButtons = new JPanel();
            this.panelButtons.add((Component)this.getButtonScan(), null);
            this.panelButtons.add((Component)this.getButtonSubmit(), null);
        }
        return this.panelButtons;
    }

    void uploadNow() {
        if (this.lastImageAcquiredPath == null) {
            JOptionPane.showMessageDialog(this, "No images have been acquired yet!");
            return;
        }
        String fileName = "scanned.jpg";
        String url = this.getParameter("UPLOAD_URL");
        if (url.length() == 0) {
            JOptionPane.showMessageDialog(this, "Target URL is empty. Upload aborted.");
            return;
        }
        String parameter = this.getParameter("UPLOAD_PARAM_NAME");
        if (parameter.length() == 0) {
            JOptionPane.showMessageDialog(this, "The parameter name is empty. Upload aborted.");
            return;
        }
        try {
            FileUploader uploader = new FileUploader();
            uploader.upload(url, parameter, fileName, this.lastImageAcquiredPath, null);
            JOptionPane.showMessageDialog(this, "File uploaded successfully. ");
            String openURL = this.getParameter("UPLOAD_OPEN_URL");
            String target = this.getParameter("UPLOAD_OPEN_TARGET");
            if (openURL != null && openURL.length() > 1) {
                this.getAppletContext().showDocument(new URL(openURL), target);
            }
        }
        catch (Exception ee) {
            JOptionPane.showMessageDialog(this, ee);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void scanNow() {
        block13: {
            block12: {
                if (!this.hasJTwainDLL()) {
                    this.buttonInstallJVM_actionPerformed(null);
                }
                try {
                    try {
                        Source source = null;
                        if (this.getParameter("SCAN_DEVICE_NAME") != null) {
                            source = SourceManager.instance().selectSourceByName(this.getParameter("SCAN_DEVICE_NAME"));
                        }
                        if (source == null) {
                            source = SourceManager.instance().selectSourceUI();
                        }
                        if (source == null) {
                            this.log("There is no source selected.");
                            Object var5_3 = null;
                            break block12;
                        }
                        source.open();
                        if (this.getParameter("SCAN_HIDDEN_UI") != null) {
                            source.setUIEnabled(false);
                        }
                        Image image = source.acquireImage();
                        MediaTracker tracker = new MediaTracker(this);
                        tracker.addImage(image, 1);
                        try {
                            tracker.waitForAll();
                        }
                        catch (Exception ee) {
                            this.log(ee);
                        }
                        source.close();
                        this.imageDisplayPanel.setImage(image);
                        this.scrollPane.setPreferredSize(new Dimension(300, 300));
                        this.imageDisplayPanel.revalidate();
                        this.scrollPane.repaint();
                        this.lastImageAcquiredPath = source.saveLastAcquiredImageIntoTemporaryFile();
                        this.log("Image acquired successfully.");
                    }
                    catch (Exception eee) {
                        this.log(eee);
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    SourceManager.closeSourceManager();
                    throw throwable;
                }
            }
            SourceManager.closeSourceManager();
            return;
        }
        Object var5_5 = null;
        SourceManager.closeSourceManager();
    }

    private JButton getButtonScan() {
        if (this.buttonScan == null) {
            this.buttonScan = new JButton();
            this.buttonScan.setText("Scan");
            this.buttonScan.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UploadAppletSimple.this.scanNow();
                }
            });
        }
        return this.buttonScan;
    }

    private JButton getButtonSubmit() {
        if (this.buttonSubmit == null) {
            this.buttonSubmit = new JButton();
            this.buttonSubmit.setText("Submit");
            this.buttonSubmit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UploadAppletSimple.this.uploadNow();
                }
            });
        }
        return this.buttonSubmit;
    }

    private ImageDisplayPanel getImageDisplayPanel() {
        if (this.imageDisplayPanel == null) {
            this.imageDisplayPanel = new ImageDisplayPanel();
        }
        return this.imageDisplayPanel;
    }

    public static void main(String[] args) {
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.labelTitle = new JLabel();
            this.labelTitle.setText("Scan and upload");
            this.labelTitle.setHorizontalAlignment(0);
            this.labelTitle.setFont(new Font("Dialog", 0, 14));
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.labelTitle, "North");
            this.jContentPane.add((Component)this.getScrollPane(), "Center");
            this.jContentPane.add((Component)this.getPanelButtons(), "South");
        }
        return this.jContentPane;
    }
}

