/*
 * Decompiled with CFR 0.152.
 */
package com.asprise.util.ocr;

import com.asprise.util.ocr.a;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class b
extends a {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int SPACE = 32;
    private static final String COMMENT = "#ASPRISE OCR";
    private byte[] lineSeparator;
    private int variant;
    private int maxValue;

    public b(OutputStream outputstream) {
        super(outputstream);
    }

    private static BufferedImage forceBanding(BufferedImage image) {
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        BufferedImage bufferedImage = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawRenderedImage(image, new AffineTransform());
        return bufferedImage;
    }

    public void encode(RenderedImage renderedimage) throws IOException {
        ComponentSampleModel componentsamplemodel;
        int i = renderedimage.getMinX();
        int j = renderedimage.getMinY();
        int k = renderedimage.getWidth();
        int l = renderedimage.getHeight();
        int i1 = renderedimage.getTileHeight();
        SampleModel samplemodel = renderedimage.getSampleModel();
        ColorModel colormodel = renderedimage.getColorModel();
        String s = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        this.lineSeparator = s.getBytes();
        int j1 = samplemodel.getTransferType();
        if (j1 == 4 || j1 == 5) {
            this.encode(b.forceBanding((BufferedImage)renderedimage));
            return;
        }
        int[] ai = samplemodel.getSampleSize();
        int k1 = samplemodel.getNumBands();
        byte[] abyte0 = null;
        byte[] abyte1 = null;
        byte[] abyte2 = null;
        boolean flag = false;
        if (k1 == 1) {
            if (colormodel instanceof IndexColorModel) {
                IndexColorModel indexcolormodel = (IndexColorModel)colormodel;
                int l1 = indexcolormodel.getMapSize();
                if (l1 < 1 << ai[0]) {
                    this.encode(b.forceBanding((BufferedImage)renderedimage));
                    return;
                }
                if (ai[0] == 1) {
                    this.variant = 52;
                    flag = indexcolormodel.getRed(1) + indexcolormodel.getGreen(1) + indexcolormodel.getBlue(1) > indexcolormodel.getRed(0) + indexcolormodel.getGreen(0) + indexcolormodel.getBlue(0);
                } else {
                    this.variant = 54;
                    abyte0 = new byte[l1];
                    abyte1 = new byte[l1];
                    abyte2 = new byte[l1];
                    indexcolormodel.getReds(abyte0);
                    indexcolormodel.getGreens(abyte1);
                    indexcolormodel.getBlues(abyte2);
                }
            } else {
                this.variant = ai[0] == 1 ? 52 : (ai[0] <= 8 ? 53 : 50);
            }
        } else if (k1 == 3) {
            this.variant = ai[0] <= 8 && ai[1] <= 8 && ai[2] <= 8 ? 54 : 51;
        } else {
            this.encode(b.forceBanding((BufferedImage)renderedimage));
            return;
        }
        if (!this.isRaw(this.variant)) {
            boolean flag1 = true;
            int i2 = 0;
            while (i2 < ai.length) {
                if (ai[i2] > 8) {
                    flag1 = false;
                    break;
                }
                ++i2;
            }
            if (flag1) {
                this.variant += 3;
            }
        }
        this.maxValue = (1 << ai[0]) - 1;
        this.output.write(80);
        this.output.write(this.variant);
        this.output.write(this.lineSeparator);
        this.output.write("# ASPRISE OCR".getBytes());
        this.output.write(this.lineSeparator);
        this.writeInteger(this.output, k);
        this.output.write(32);
        this.writeInteger(this.output, l);
        if (this.variant != 52 && this.variant != 49) {
            this.output.write(this.lineSeparator);
            this.writeInteger(this.output, this.maxValue);
        }
        if (this.variant == 52 || this.variant == 53 || this.variant == 54) {
            this.output.write(10);
        }
        boolean flag2 = false;
        if (this.variant == 52 && samplemodel.getTransferType() == 0 && samplemodel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multipixelpackedsamplemodel = (MultiPixelPackedSampleModel)samplemodel;
            if (multipixelpackedsamplemodel.getDataBitOffset() == 0 && multipixelpackedsamplemodel.getPixelBitStride() == 1) {
                flag2 = true;
            }
        } else if ((this.variant == 53 || this.variant == 54) && samplemodel instanceof ComponentSampleModel && !(colormodel instanceof IndexColorModel) && (componentsamplemodel = (ComponentSampleModel)samplemodel).getPixelStride() == k1) {
            flag2 = true;
            if (this.variant == 54) {
                int[] ai2 = componentsamplemodel.getBandOffsets();
                int l2 = 0;
                while (l2 < k1) {
                    if (ai2[l2] != l2) {
                        flag2 = false;
                        break;
                    }
                    ++l2;
                }
            }
        }
        if (flag2) {
            int j2 = this.variant != 52 ? k * samplemodel.getNumBands() : (k + 7) / 8;
            int k2 = renderedimage.getNumYTiles();
            Rectangle rectangle = new Rectangle(renderedimage.getMinX(), renderedimage.getMinY(), renderedimage.getWidth(), renderedimage.getHeight());
            Rectangle rectangle1 = new Rectangle(renderedimage.getMinX(), renderedimage.getMinTileY() * renderedimage.getTileHeight() + renderedimage.getTileGridYOffset(), renderedimage.getWidth(), renderedimage.getTileHeight());
            byte[] abyte4 = null;
            if (flag) {
                abyte4 = new byte[j2];
            }
            int l3 = 0;
            while (l3 < k2) {
                int i5;
                if (l3 == k2 - 1) {
                    rectangle1.height = renderedimage.getHeight() - rectangle1.y;
                }
                Rectangle rectangle2 = rectangle1.intersection(rectangle);
                Raster raster = renderedimage.getData(rectangle2);
                byte[] abyte5 = ((DataBufferByte)raster.getDataBuffer()).getData();
                int n = i5 = this.variant != 52 ? ((ComponentSampleModel)raster.getSampleModel()).getScanlineStride() : ((MultiPixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
                if (i5 == j2 && !flag) {
                    this.output.write(abyte5, 0, abyte5.length);
                } else {
                    int i6 = 0;
                    int k6 = 0;
                    while (k6 < rectangle2.height) {
                        if (flag) {
                            int i7 = 0;
                            while (i7 < j2) {
                                abyte4[i7] = (byte)(~(abyte5[i6 + i7] & 0xFF));
                                ++i7;
                            }
                            this.output.write(abyte4, 0, j2);
                        } else {
                            this.output.write(abyte5, i6, j2);
                        }
                        i6 += i5;
                        ++k6;
                    }
                }
                rectangle1.y += i1;
                ++l3;
            }
            this.output.flush();
            return;
        }
        int[] ai1 = new int[8 * k * k1];
        byte[] abyte3 = abyte0 != null ? new byte[8 * k * 3] : new byte[8 * k * k1];
        int i3 = 0;
        int j3 = j + l;
        int k3 = j;
        while (k3 < j3) {
            int i4 = Math.min(8, j3 - k3);
            int j4 = i4 * k * k1;
            Raster raster1 = renderedimage.getData(new Rectangle(i, k3, k, i4));
            raster1.getPixels(i, k3, k, i4, ai1);
            if (flag) {
                int k4 = 0;
                while (k4 < j4) {
                    int n = k4++;
                    ai1[n] = ai1[n] ^ 1;
                }
            }
            switch (this.variant) {
                default: {
                    break;
                }
                case 49: 
                case 50: {
                    int l4 = 0;
                    while (l4 < j4) {
                        if (i3++ % 16 == 0) {
                            this.output.write(this.lineSeparator);
                        } else {
                            this.output.write(32);
                        }
                        this.writeInteger(this.output, ai1[l4]);
                        ++l4;
                    }
                    this.output.write(this.lineSeparator);
                    break;
                }
                case 51: {
                    if (abyte0 == null) {
                        int j5 = 0;
                        while (j5 < j4) {
                            if (i3++ % 16 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, ai1[j5]);
                            ++j5;
                        }
                    } else {
                        int k5 = 0;
                        while (k5 < j4) {
                            if (i3++ % 16 == 0) {
                                this.output.write(this.lineSeparator);
                            } else {
                                this.output.write(32);
                            }
                            this.writeInteger(this.output, abyte0[ai1[k5]] & 0xFF);
                            this.output.write(32);
                            this.writeInteger(this.output, abyte1[ai1[k5]] & 0xFF);
                            this.output.write(32);
                            this.writeInteger(this.output, abyte2[ai1[k5]] & 0xFF);
                            ++k5;
                        }
                    }
                    this.output.write(this.lineSeparator);
                    break;
                }
                case 52: {
                    int l5 = 0;
                    int j6 = 0;
                    int l6 = 0;
                    while (l6 < j4 / 8) {
                        int j7 = ai1[j6++] << 7 | ai1[j6++] << 6 | ai1[j6++] << 5 | ai1[j6++] << 4 | ai1[j6++] << 3 | ai1[j6++] << 2 | ai1[j6++] << 1 | ai1[j6++];
                        abyte3[l5++] = (byte)j7;
                        ++l6;
                    }
                    if (j4 % 8 > 0) {
                        int k7 = 0;
                        int i8 = 0;
                        while (i8 < j4 % 8) {
                            k7 |= ai1[j4 + i8] << 7 - i8;
                            ++i8;
                        }
                        abyte3[l5++] = (byte)k7;
                    }
                    this.output.write(abyte3, 0, (j4 + 7) / 8);
                    break;
                }
                case 53: {
                    int l7 = 0;
                    while (l7 < j4) {
                        abyte3[l7] = (byte)ai1[l7];
                        ++l7;
                    }
                    this.output.write(abyte3, 0, j4);
                    break;
                }
                case 54: {
                    if (abyte0 == null) {
                        int j8 = 0;
                        while (j8 < j4) {
                            abyte3[j8] = (byte)(ai1[j8] & 0xFF);
                            ++j8;
                        }
                    } else {
                        int k8 = 0;
                        int l8 = 0;
                        while (k8 < j4) {
                            abyte3[l8++] = abyte0[ai1[k8]];
                            abyte3[l8++] = abyte1[ai1[k8]];
                            abyte3[l8++] = abyte2[ai1[k8]];
                            ++k8;
                        }
                    }
                    this.output.write(abyte3, 0, abyte3.length);
                }
            }
            k3 += 8;
        }
        this.output.flush();
    }

    private void writeInteger(OutputStream outputstream, int i) throws IOException {
        outputstream.write(Integer.toString(i).getBytes());
    }

    private void writeByte(OutputStream outputstream, byte byte0) throws IOException {
        outputstream.write(Byte.toString(byte0).getBytes());
    }

    private boolean isRaw(int i) {
        return i >= 52;
    }

    public static void main(String[] args) {
    }
}

