/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private transient Object[] elementData;
    private int size;

    public ArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elementData = new Object[n];
    }

    public ArrayList() {
        this(10);
    }

    public ArrayList(Collection<? extends E> collection) {
        this.elementData = collection.toArray();
        this.size = this.elementData.length;
        if (this.elementData.getClass() != Object[].class) {
            this.elementData = Arrays.copyOf(this.elementData, this.size, Object[].class);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        int n = this.elementData.length;
        if (this.size < n) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
        }
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (n > n2) {
            Object[] objectArray = this.elementData;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = Arrays.copyOf(this.elementData, n3);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            ArrayList arrayList = (ArrayList)super.clone();
            arrayList.elementData = Arrays.copyOf(this.elementData, this.size);
            arrayList.modCount = 0;
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, TArray.getClass());
        }
        System.arraycopy(this.elementData, 0, TArray, 0, this.size);
        if (TArray.length > this.size) {
            TArray[this.size] = null;
        }
        return TArray;
    }

    @Override
    public E get(int n) {
        this.RangeCheck(n);
        return (E)this.elementData[n];
    }

    @Override
    public E set(int n, E e) {
        this.RangeCheck(n);
        Object object = this.elementData[n];
        this.elementData[n] = e;
        return (E)object;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int n, E e) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
        this.elementData[n] = e;
        ++this.size;
    }

    @Override
    public E remove(int n) {
        this.RangeCheck(n);
        ++this.modCount;
        Object object = this.elementData[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        return (E)object;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                this.fastRemove(i);
                return true;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                this.fastRemove(i);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int n) {
        ++this.modCount;
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        this.ensureCapacity(this.size + n);
        System.arraycopy(objectArray, 0, this.elementData, this.size, n);
        this.size += n;
        return n != 0;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        this.ensureCapacity(this.size + n2);
        int n3 = this.size - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n, this.elementData, n + n2, n3);
        }
        System.arraycopy(objectArray, 0, this.elementData, n, n2);
        this.size += n2;
        return n2 != 0;
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.size - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.elementData[--this.size] = null;
        }
    }

    private void RangeCheck(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.modCount;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.elementData.length);
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(this.elementData[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.elementData = new Object[n];
        Object[] objectArray = this.elementData;
        for (int i = 0; i < this.size; ++i) {
            objectArray[i] = objectInputStream.readObject();
        }
    }
}

