/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.swing.Action;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.basic.BasicComboPopup;
import sun.security.action.GetPropertyAction;

public class JPopupMenu
extends JComponent
implements Accessible,
MenuElement {
    private static final String uiClassID = "PopupMenuUI";
    private static final Object defaultLWPopupEnabledKey = new StringBuffer("JPopupMenu.defaultLWPopupEnabledKey");
    static boolean popupPostionFixDisabled = false;
    transient Component invoker;
    transient Popup popup;
    transient Frame frame;
    private int desiredLocationX;
    private int desiredLocationY;
    private String label = null;
    private boolean paintBorder = true;
    private Insets margin = null;
    private boolean lightWeightPopup = true;
    private SingleSelectionModel selectionModel;
    private static final Object classLock;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;

    public static void setDefaultLightWeightPopupEnabled(boolean bl) {
        SwingUtilities.appContextPut(defaultLWPopupEnabledKey, bl);
    }

    public static boolean getDefaultLightWeightPopupEnabled() {
        Boolean bl = (Boolean)SwingUtilities.appContextGet(defaultLWPopupEnabledKey);
        if (bl == null) {
            SwingUtilities.appContextPut(defaultLWPopupEnabledKey, Boolean.TRUE);
            return true;
        }
        return bl;
    }

    public JPopupMenu() {
        this(null);
    }

    public JPopupMenu(String string) {
        this.label = string;
        this.lightWeightPopup = JPopupMenu.getDefaultLightWeightPopupEnabled();
        this.setSelectionModel(new DefaultSingleSelectionModel());
        this.enableEvents(16L);
        this.setFocusTraversalKeysEnabled(false);
        this.updateUI();
    }

    public PopupMenuUI getUI() {
        return (PopupMenuUI)this.ui;
    }

    public void setUI(PopupMenuUI popupMenuUI) {
        super.setUI(popupMenuUI);
    }

    public void updateUI() {
        this.setUI((PopupMenuUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        super.processKeyEvent(keyEvent);
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel singleSelectionModel) {
        this.selectionModel = singleSelectionModel;
    }

    public JMenuItem add(JMenuItem jMenuItem) {
        super.add(jMenuItem);
        return jMenuItem;
    }

    public JMenuItem add(String string) {
        return this.add(new JMenuItem(string));
    }

    public JMenuItem add(Action action) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.add(jMenuItem);
        return jMenuItem;
    }

    Point adjustPopupLocationToFitScreen(int n, int n2) {
        Point point = new Point(n, n2);
        if (popupPostionFixDisabled || GraphicsEnvironment.isHeadless()) {
            return point;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            GraphicsConfiguration graphicsConfiguration2;
            if (graphicsDeviceArray[i].getType() != 0 || !(graphicsConfiguration2 = graphicsDeviceArray[i].getDefaultConfiguration()).getBounds().contains(point)) continue;
            graphicsConfiguration = graphicsConfiguration2;
            break;
        }
        if (graphicsConfiguration == null && this.getInvoker() != null) {
            graphicsConfiguration = this.getInvoker().getGraphicsConfiguration();
        }
        Rectangle rectangle = graphicsConfiguration != null ? graphicsConfiguration.getBounds() : new Rectangle(toolkit.getScreenSize());
        Dimension dimension = this.getPreferredSize();
        long l = (long)point.x + (long)dimension.width;
        long l2 = (long)point.y + (long)dimension.height;
        if (l > (long)(rectangle.x + rectangle.width)) {
            point.x = rectangle.x + rectangle.width - dimension.width;
        }
        if (l2 > (long)(rectangle.y + rectangle.height)) {
            point.y = rectangle.y + rectangle.height - dimension.height;
        }
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        }
        return point;
    }

    protected JMenuItem createActionComponent(Action action) {
        JMenuItem jMenuItem = new JMenuItem(){

            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = JPopupMenu.this.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
        };
        jMenuItem.setHorizontalTextPosition(11);
        jMenuItem.setVerticalTextPosition(0);
        return jMenuItem;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem jMenuItem) {
        return jMenuItem.createActionPropertyChangeListener0(jMenuItem.getAction());
    }

    public void remove(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (n > this.getComponentCount() - 1) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        super.remove(n);
    }

    public void setLightWeightPopupEnabled(boolean bl) {
        this.lightWeightPopup = bl;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopup;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.firePropertyChange("label", string2, string);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        this.invalidate();
        this.repaint();
    }

    public void addSeparator() {
        this.add(new Separator());
    }

    public void insert(Action action, int n) {
        JMenuItem jMenuItem = this.createActionComponent(action);
        jMenuItem.setAction(action);
        this.insert(jMenuItem, n);
    }

    public void insert(Component component, int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        int n3 = this.getComponentCount();
        Vector<Component> vector = new Vector<Component>();
        for (n2 = n; n2 < n3; ++n2) {
            vector.addElement(this.getComponent(n));
            this.remove(n);
        }
        this.add(component);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            this.add((Component)vector.elementAt(n2));
        }
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(PopupMenuListener.class, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(PopupMenuListener.class, popupMenuListener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(PopupMenuListener.class);
    }

    public void addMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.add(MenuKeyListener.class, menuKeyListener);
    }

    public void removeMenuKeyListener(MenuKeyListener menuKeyListener) {
        this.listenerList.remove(MenuKeyListener.class, menuKeyListener);
    }

    public MenuKeyListener[] getMenuKeyListeners() {
        return (MenuKeyListener[])this.listenerList.getListeners(MenuKeyListener.class);
    }

    protected void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
        }
    }

    protected void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i + 1]).popupMenuCanceled(popupMenuEvent);
        }
    }

    boolean alwaysOnTop() {
        return true;
    }

    public void pack() {
        if (this.popup != null) {
            Dimension dimension = this.getPreferredSize();
            if (dimension == null || dimension.width != this.getWidth() || dimension.height != this.getHeight()) {
                this.popup = this.getPopup();
            } else {
                this.validate();
            }
        }
    }

    public void setVisible(boolean bl) {
        if (bl == this.isVisible()) {
            return;
        }
        if (!bl) {
            Boolean bl2 = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
            if (bl2 != null && bl2 == Boolean.TRUE) {
                this.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.FALSE);
                this.firePopupMenuCanceled();
            }
            this.getSelectionModel().clearSelection();
        } else if (this.isPopupMenu()) {
            MenuElement[] menuElementArray = new MenuElement[]{this};
            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
        }
        if (bl) {
            this.firePopupMenuWillBecomeVisible();
            this.popup = this.getPopup();
            this.firePropertyChange("visible", Boolean.FALSE, Boolean.TRUE);
        } else if (this.popup != null) {
            this.firePopupMenuWillBecomeInvisible();
            this.popup.hide();
            this.popup = null;
            this.firePropertyChange("visible", Boolean.TRUE, Boolean.FALSE);
            if (this.isPopupMenu()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private Popup getPopup() {
        Popup popup = this.popup;
        if (popup != null) {
            popup.hide();
        }
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        if (this.isLightWeightPopupEnabled()) {
            popupFactory.setPopupType(0);
        } else {
            popupFactory.setPopupType(1);
        }
        Point point = this.adjustPopupLocationToFitScreen(this.desiredLocationX, this.desiredLocationY);
        this.desiredLocationX = point.x;
        this.desiredLocationY = point.y;
        Popup popup2 = this.getUI().getPopup(this, this.desiredLocationX, this.desiredLocationY);
        popupFactory.setPopupType(0);
        popup2.show();
        return popup2;
    }

    public boolean isVisible() {
        return this.popup != null;
    }

    public void setLocation(int n, int n2) {
        int n3 = this.desiredLocationX;
        int n4 = this.desiredLocationY;
        this.desiredLocationX = n;
        this.desiredLocationY = n2;
        if (this.popup != null && (n != n3 || n2 != n4)) {
            this.popup = this.getPopup();
        }
    }

    private boolean isPopupMenu() {
        return this.invoker != null && !(this.invoker instanceof JMenu);
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Component component) {
        Component component2 = this.invoker;
        this.invoker = component;
        if (component2 != this.invoker && this.ui != null) {
            this.ui.uninstallUI(this);
            this.ui.installUI(this);
        }
        this.invalidate();
    }

    public void show(Component component, int n, int n2) {
        this.setInvoker(component);
        Frame frame = JPopupMenu.getFrame(component);
        if (frame != this.frame && frame != null) {
            this.frame = frame;
            if (this.popup != null) {
                this.setVisible(false);
            }
        }
        if (component != null) {
            Point point = component.getLocationOnScreen();
            long l = (long)point.x + (long)n;
            long l2 = (long)point.y + (long)n2;
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            if (l < Integer.MIN_VALUE) {
                l = Integer.MIN_VALUE;
            }
            if (l2 > Integer.MAX_VALUE) {
                l2 = Integer.MAX_VALUE;
            }
            if (l2 < Integer.MIN_VALUE) {
                l2 = Integer.MIN_VALUE;
            }
            this.setLocation((int)l, (int)l2);
        } else {
            this.setLocation(n, n2);
        }
        this.setVisible(true);
    }

    JPopupMenu getRootPopupMenu() {
        JPopupMenu jPopupMenu = this;
        while (jPopupMenu != null && !jPopupMenu.isPopupMenu() && jPopupMenu.getInvoker() != null && jPopupMenu.getInvoker().getParent() != null && jPopupMenu.getInvoker().getParent() instanceof JPopupMenu) {
            jPopupMenu = (JPopupMenu)jPopupMenu.getInvoker().getParent();
        }
        return jPopupMenu;
    }

    @Deprecated
    public Component getComponentAtIndex(int n) {
        return this.getComponent(n);
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < n; ++i) {
            Component component2 = componentArray[i];
            if (component2 != component) continue;
            return i;
        }
        return -1;
    }

    public void setPopupSize(Dimension dimension) {
        Dimension dimension2;
        Dimension dimension3 = this.getPreferredSize();
        this.setPreferredSize(dimension);
        if (this.popup != null && !dimension3.equals(dimension2 = this.getPreferredSize())) {
            this.popup = this.getPopup();
        }
    }

    public void setPopupSize(int n, int n2) {
        this.setPopupSize(new Dimension(n, n2));
    }

    public void setSelected(Component component) {
        SingleSelectionModel singleSelectionModel = this.getSelectionModel();
        int n = this.getComponentIndex(component);
        singleSelectionModel.setSelectedIndex(n);
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        this.paintBorder = bl;
        this.repaint();
    }

    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    boolean isSubPopupMenu(JPopupMenu jPopupMenu) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < n; ++i) {
            Component component = componentArray[i];
            if (!(component instanceof JMenu)) continue;
            JMenu jMenu = (JMenu)component;
            JPopupMenu jPopupMenu2 = jMenu.getPopupMenu();
            if (jPopupMenu2 == jPopupMenu) {
                return true;
            }
            if (!jPopupMenu2.isSubPopupMenu(jPopupMenu)) continue;
            return true;
        }
        return false;
    }

    private static Frame getFrame(Component component) {
        Component component2;
        for (component2 = component; !(component2 instanceof Frame) && component2 != null; component2 = component2.getParent()) {
        }
        return (Frame)component2;
    }

    protected String paramString() {
        String string = this.label != null ? this.label : "";
        String string2 = this.paintBorder ? "true" : "false";
        String string3 = this.margin != null ? this.margin.toString() : "";
        String string4 = this.isLightWeightPopupEnabled() ? "true" : "false";
        return super.paramString() + ",desiredLocationX=" + this.desiredLocationX + ",desiredLocationY=" + this.desiredLocationY + ",label=" + string + ",lightWeightPopupEnabled=" + string4 + ",margin=" + string3 + ",paintBorder=" + string2;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPopupMenu();
        }
        return this.accessibleContext;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.invoker != null && this.invoker instanceof Serializable) {
            vector.addElement("invoker");
            vector.addElement(this.invoker);
        }
        if (this.popup != null && this.popup instanceof Serializable) {
            vector.addElement("popup");
            vector.addElement(this.popup);
        }
        objectOutputStream.writeObject(vector);
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("invoker")) {
            this.invoker = (Component)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("popup")) {
            this.popup = (Popup)vector.elementAt(++n);
            ++n;
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
        MenuKeyEvent menuKeyEvent = new MenuKeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), menuElementArray, menuSelectionManager);
        this.processMenuKeyEvent(menuKeyEvent);
        if (menuKeyEvent.isConsumed()) {
            keyEvent.consume();
        }
    }

    private void processMenuKeyEvent(MenuKeyEvent menuKeyEvent) {
        switch (menuKeyEvent.getID()) {
            case 401: {
                this.fireMenuKeyPressed(menuKeyEvent);
                break;
            }
            case 402: {
                this.fireMenuKeyReleased(menuKeyEvent);
                break;
            }
            case 400: {
                this.fireMenuKeyTyped(menuKeyEvent);
                break;
            }
        }
    }

    private void fireMenuKeyPressed(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MenuKeyListener.class) continue;
            ((MenuKeyListener)objectArray[i + 1]).menuKeyPressed(menuKeyEvent);
        }
    }

    private void fireMenuKeyReleased(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MenuKeyListener.class) continue;
            ((MenuKeyListener)objectArray[i + 1]).menuKeyReleased(menuKeyEvent);
        }
    }

    private void fireMenuKeyTyped(MenuKeyEvent menuKeyEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MenuKeyListener.class) continue;
            ((MenuKeyListener)objectArray[i + 1]).menuKeyTyped(menuKeyEvent);
        }
    }

    public void menuSelectionChanged(boolean bl) {
        if (this.invoker instanceof JMenu) {
            JMenu jMenu = (JMenu)this.invoker;
            if (bl) {
                jMenu.setPopupMenuVisible(true);
            } else {
                jMenu.setPopupMenuVisible(false);
            }
        }
        if (this.isPopupMenu() && !bl) {
            this.setVisible(false);
        }
    }

    public MenuElement[] getSubElements() {
        int n;
        Vector<Component> vector = new Vector<Component>();
        int n2 = this.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.getComponent(n);
            if (!(component instanceof MenuElement)) continue;
            vector.addElement(component);
        }
        MenuElement[] menuElementArray = new MenuElement[vector.size()];
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            menuElementArray[n] = (MenuElement)vector.elementAt(n);
        }
        return menuElementArray;
    }

    public Component getComponent() {
        return this;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return this.getUI().isPopupTrigger(mouseEvent);
    }

    static {
        popupPostionFixDisabled = AccessController.doPrivileged(new GetPropertyAction("javax.swing.adjustPopupLocationToFit", "")).equals("false");
        classLock = new Object();
    }

    protected class AccessibleJPopupMenu
    extends JComponent.AccessibleJComponent
    implements PropertyChangeListener {
        protected AccessibleJPopupMenu() {
            JPopupMenu.this.addPropertyChangeListener(this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "visible") {
                if (propertyChangeEvent.getOldValue() == Boolean.FALSE && propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    this.handlePopupIsVisibleEvent(true);
                } else if (propertyChangeEvent.getOldValue() == Boolean.TRUE && propertyChangeEvent.getNewValue() == Boolean.FALSE) {
                    this.handlePopupIsVisibleEvent(false);
                }
            }
        }

        private void handlePopupIsVisibleEvent(boolean bl) {
            if (bl) {
                this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
                this.fireActiveDescendant();
            } else {
                this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }
        }

        private void fireActiveDescendant() {
            if (JPopupMenu.this instanceof BasicComboPopup) {
                AccessibleContext accessibleContext;
                JList jList = ((BasicComboPopup)JPopupMenu.this).getList();
                if (jList == null) {
                    return;
                }
                AccessibleContext accessibleContext2 = jList.getAccessibleContext();
                AccessibleSelection accessibleSelection = accessibleContext2.getAccessibleSelection();
                if (accessibleSelection == null) {
                    return;
                }
                Accessible accessible = accessibleSelection.getAccessibleSelection(0);
                if (accessible == null) {
                    return;
                }
                AccessibleContext accessibleContext3 = accessible.getAccessibleContext();
                if (accessibleContext3 != null && JPopupMenu.this.invoker != null && (accessibleContext = JPopupMenu.this.invoker.getAccessibleContext()) != null) {
                    accessibleContext.firePropertyChange("AccessibleActiveDescendant", null, accessibleContext3);
                }
            }
        }
    }

    public static class Separator
    extends JSeparator {
        public Separator() {
            super(0);
        }

        public String getUIClassID() {
            return "PopupMenuSeparatorUI";
        }
    }
}

