/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import sun.dc.path.PathConsumer;
import sun.dc.path.PathException;
import sun.dc.pr.PRException;
import sun.dc.pr.PathDasher;
import sun.dc.pr.PathStroker;
import sun.dc.pr.Rasterizer;

public class DuctusRenderer {
    public static final float PenUnits = 0.01f;
    public static final int MinPenUnits = 100;
    public static final int MinPenUnitsAA = 20;
    public static final float MinPenSizeAA = 0.19999999f;
    static final int[] RasterizerCaps = new int[]{30, 10, 20};
    static final int[] RasterizerCorners = new int[]{50, 10, 40};
    private static Rasterizer theRasterizer;
    private static byte[] theTile;
    static final float UPPER_BND = 1.7014117E38f;
    static final float LOWER_BND = -1.7014117E38f;

    public static synchronized Rasterizer getRasterizer() {
        Rasterizer rasterizer = theRasterizer;
        if (rasterizer == null) {
            rasterizer = new Rasterizer();
        } else {
            theRasterizer = null;
        }
        return rasterizer;
    }

    public static synchronized void dropRasterizer(Rasterizer rasterizer) {
        rasterizer.reset();
        theRasterizer = rasterizer;
    }

    public static synchronized byte[] getAlphaTile() {
        byte[] byArray = theTile;
        if (byArray == null) {
            int n = Rasterizer.TILE_SIZE;
            byArray = new byte[n * n];
        } else {
            theTile = null;
        }
        return byArray;
    }

    public static synchronized void dropAlphaTile(byte[] byArray) {
        theTile = byArray;
    }

    public static synchronized void getAlpha(Rasterizer rasterizer, byte[] byArray, int n, int n2, int n3) throws PRException {
        try {
            rasterizer.writeAlpha(byArray, n, n2, n3);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static PathConsumer createStroker(PathConsumer pathConsumer, BasicStroke basicStroke, boolean bl, AffineTransform affineTransform) {
        PathStroker pathStroker = new PathStroker(pathConsumer);
        pathConsumer = pathStroker;
        float[] fArray = null;
        if (!bl) {
            pathStroker.setPenDiameter(basicStroke.getLineWidth());
            if (affineTransform != null) {
                fArray = DuctusRenderer.getTransformMatrix(affineTransform);
            }
            pathStroker.setPenT4(fArray);
            pathStroker.setPenFitting(0.01f, 100);
        }
        pathStroker.setCaps(RasterizerCaps[basicStroke.getEndCap()]);
        pathStroker.setCorners(RasterizerCorners[basicStroke.getLineJoin()], basicStroke.getMiterLimit());
        float[] fArray2 = basicStroke.getDashArray();
        if (fArray2 != null) {
            PathDasher pathDasher = new PathDasher((PathConsumer)pathStroker);
            pathDasher.setDash(fArray2, basicStroke.getDashPhase());
            if (affineTransform != null && fArray == null) {
                fArray = DuctusRenderer.getTransformMatrix(affineTransform);
            }
            pathDasher.setDashT4(fArray);
            pathConsumer = pathDasher;
        }
        return pathConsumer;
    }

    static float[] getTransformMatrix(AffineTransform affineTransform) {
        float[] fArray = new float[4];
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        for (int i = 0; i < 4; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    public static void disposeStroker(PathConsumer pathConsumer, PathConsumer pathConsumer2) {
        while (pathConsumer != null && pathConsumer != pathConsumer2) {
            PathConsumer pathConsumer3 = pathConsumer.getConsumer();
            pathConsumer.dispose();
            pathConsumer = pathConsumer3;
        }
    }

    public static void feedConsumer(PathIterator pathIterator, PathConsumer pathConsumer, boolean bl, float f) throws PathException {
        pathConsumer.beginPath();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float[] fArray = new float[6];
        float f4 = 0.5f - f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (bl2) {
                bl2 = false;
                if (n != 0) {
                    pathConsumer.beginSubpath(f2, f3);
                    bl4 = true;
                }
            }
            if (bl) {
                int n2;
                switch (n) {
                    case 3: {
                        n2 = 4;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 0: 
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = -1;
                    }
                }
                if (n2 >= 0) {
                    float f7 = fArray[n2];
                    float f8 = fArray[n2 + 1];
                    float f9 = (float)Math.floor(f7 + f4) + f;
                    float f10 = (float)Math.floor(f8 + f4) + f;
                    fArray[n2] = f9;
                    fArray[n2 + 1] = f10;
                    f9 -= f7;
                    f10 -= f8;
                    switch (n) {
                        case 3: {
                            fArray[0] = fArray[0] + f5;
                            fArray[1] = fArray[1] + f6;
                            fArray[2] = fArray[2] + f9;
                            fArray[3] = fArray[3] + f10;
                            break;
                        }
                        case 2: {
                            fArray[0] = fArray[0] + (f9 + f5) / 2.0f;
                            fArray[1] = fArray[1] + (f10 + f6) / 2.0f;
                            break;
                        }
                    }
                    f5 = f9;
                    f6 = f10;
                }
            }
            switch (n) {
                case 0: {
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        f2 = fArray[0];
                        f3 = fArray[1];
                        pathConsumer.beginSubpath(f2, f3);
                        bl4 = true;
                        bl3 = false;
                        break;
                    }
                    bl3 = true;
                    break;
                }
                case 1: {
                    if (!(fArray[0] < 1.7014117E38f) || !(fArray[0] > -1.7014117E38f) || !(fArray[1] < 1.7014117E38f) || !(fArray[1] > -1.7014117E38f)) break;
                    if (bl3) {
                        pathConsumer.beginSubpath(fArray[0], fArray[1]);
                        bl4 = true;
                        bl3 = false;
                        break;
                    }
                    pathConsumer.appendLine(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    if (!(fArray[2] < 1.7014117E38f) || !(fArray[2] > -1.7014117E38f) || !(fArray[3] < 1.7014117E38f) || !(fArray[3] > -1.7014117E38f)) break;
                    if (bl3) {
                        pathConsumer.beginSubpath(fArray[2], fArray[3]);
                        bl4 = true;
                        bl3 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        pathConsumer.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    pathConsumer.appendLine(fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    if (!(fArray[4] < 1.7014117E38f) || !(fArray[4] > -1.7014117E38f) || !(fArray[5] < 1.7014117E38f) || !(fArray[5] > -1.7014117E38f)) break;
                    if (bl3) {
                        pathConsumer.beginSubpath(fArray[4], fArray[5]);
                        bl4 = true;
                        bl3 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f && fArray[2] < 1.7014117E38f && fArray[2] > -1.7014117E38f && fArray[3] < 1.7014117E38f && fArray[3] > -1.7014117E38f) {
                        pathConsumer.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    pathConsumer.appendLine(fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    if (!bl4) break;
                    pathConsumer.closedSubpath();
                    bl4 = false;
                    bl2 = true;
                }
            }
            pathIterator.next();
        }
        pathConsumer.endPath();
    }

    public static Rasterizer createShapeRasterizer(PathIterator pathIterator, AffineTransform affineTransform, BasicStroke basicStroke, boolean bl, boolean bl2, float f) {
        Rasterizer rasterizer = DuctusRenderer.getRasterizer();
        if (basicStroke != null) {
            float[] fArray = null;
            rasterizer.setUsage(3);
            if (bl) {
                rasterizer.setPenDiameter(0.19999999f);
            } else {
                rasterizer.setPenDiameter(basicStroke.getLineWidth());
                if (affineTransform != null) {
                    fArray = DuctusRenderer.getTransformMatrix(affineTransform);
                    rasterizer.setPenT4(fArray);
                }
                rasterizer.setPenFitting(0.01f, 20);
            }
            rasterizer.setCaps(RasterizerCaps[basicStroke.getEndCap()]);
            rasterizer.setCorners(RasterizerCorners[basicStroke.getLineJoin()], basicStroke.getMiterLimit());
            float[] fArray2 = basicStroke.getDashArray();
            if (fArray2 != null) {
                rasterizer.setDash(fArray2, basicStroke.getDashPhase());
                if (affineTransform != null && fArray == null) {
                    fArray = DuctusRenderer.getTransformMatrix(affineTransform);
                }
                rasterizer.setDashT4(fArray);
            }
        } else {
            rasterizer.setUsage(pathIterator.getWindingRule() == 0 ? 1 : 2);
        }
        rasterizer.beginPath();
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float[] fArray = new float[6];
        float f4 = 0.5f - f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            if (bl3) {
                bl3 = false;
                if (n != 0) {
                    rasterizer.beginSubpath(f2, f3);
                    bl5 = true;
                }
            }
            if (bl2) {
                int n2;
                switch (n) {
                    case 3: {
                        n2 = 4;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                    case 0: 
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 = -1;
                    }
                }
                if (n2 >= 0) {
                    float f7 = fArray[n2];
                    float f8 = fArray[n2 + 1];
                    float f9 = (float)Math.floor(f7 + f4) + f;
                    float f10 = (float)Math.floor(f8 + f4) + f;
                    fArray[n2] = f9;
                    fArray[n2 + 1] = f10;
                    f9 -= f7;
                    f10 -= f8;
                    switch (n) {
                        case 3: {
                            fArray[0] = fArray[0] + f5;
                            fArray[1] = fArray[1] + f6;
                            fArray[2] = fArray[2] + f9;
                            fArray[3] = fArray[3] + f10;
                            break;
                        }
                        case 2: {
                            fArray[0] = fArray[0] + (f9 + f5) / 2.0f;
                            fArray[1] = fArray[1] + (f10 + f6) / 2.0f;
                            break;
                        }
                    }
                    f5 = f9;
                    f6 = f10;
                }
            }
            switch (n) {
                case 0: {
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        f2 = fArray[0];
                        f3 = fArray[1];
                        rasterizer.beginSubpath(f2, f3);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    bl4 = true;
                    break;
                }
                case 1: {
                    if (!(fArray[0] < 1.7014117E38f) || !(fArray[0] > -1.7014117E38f) || !(fArray[1] < 1.7014117E38f) || !(fArray[1] > -1.7014117E38f)) break;
                    if (bl4) {
                        rasterizer.beginSubpath(fArray[0], fArray[1]);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    rasterizer.appendLine(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    if (!(fArray[2] < 1.7014117E38f) || !(fArray[2] > -1.7014117E38f) || !(fArray[3] < 1.7014117E38f) || !(fArray[3] > -1.7014117E38f)) break;
                    if (bl4) {
                        rasterizer.beginSubpath(fArray[2], fArray[3]);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f) {
                        rasterizer.appendQuadratic(fArray[0], fArray[1], fArray[2], fArray[3]);
                        break;
                    }
                    rasterizer.appendLine(fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    if (!(fArray[4] < 1.7014117E38f) || !(fArray[4] > -1.7014117E38f) || !(fArray[5] < 1.7014117E38f) || !(fArray[5] > -1.7014117E38f)) break;
                    if (bl4) {
                        rasterizer.beginSubpath(fArray[4], fArray[5]);
                        bl5 = true;
                        bl4 = false;
                        break;
                    }
                    if (fArray[0] < 1.7014117E38f && fArray[0] > -1.7014117E38f && fArray[1] < 1.7014117E38f && fArray[1] > -1.7014117E38f && fArray[2] < 1.7014117E38f && fArray[2] > -1.7014117E38f && fArray[3] < 1.7014117E38f && fArray[3] > -1.7014117E38f) {
                        rasterizer.appendCubic(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                        break;
                    }
                    rasterizer.appendLine(fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    if (!bl5) break;
                    rasterizer.closedSubpath();
                    bl5 = false;
                    bl3 = true;
                }
            }
            pathIterator.next();
        }
        try {
            rasterizer.endPath();
        }
        catch (PRException pRException) {
            System.err.println("DuctusRenderer.createShapeRasterizer: " + (Object)((Object)pRException));
        }
        return rasterizer;
    }
}

