_G = _G or GLOBAL
local STRINGS = _G.STRINGS
local TheSim = _G.TheSim
local require = _G.require
local name = "nagisa"
env.char = name
modimport("xkmodmain.lua")

Assets = {
	Asset( "ATLAS", "images/saveslot_portraits/"..name..".xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/"..name..".xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/"..name.."_silho.xml" ),
    Asset( "ATLAS", "bigportraits/"..name..".xml" ),    
    Asset( "ATLAS", "images/map_icons/"..name..".xml" ),    
    Asset( "ATLAS", "images/avatars/avatar_"..name..".xml" ),    
    Asset( "ATLAS", "images/avatars/avatar_ghost_"..name..".xml" ),   
    Asset( "ATLAS", "images/avatars/self_inspect_"..name..".xml" ),

    Asset( "ATLAS", "images/hud/"..name..".xml" ),
    Asset( "ATLAS", "images/hud/bg.xml" ),
    Asset( "ATLAS", "images/hud/qrcode.xml" ),

    Asset( "ATLAS", "images/inventoryimages/trumpet.xml" ),
}

PrefabFiles = {
	name,  name.."_none",
    "cheese","trumpet",
    name.."_projectile",
}

STRINGS.CHARACTER_TITLES[name] = "I am Momoe Nagisa"
STRINGS.CHARACTER_NAMES[name] = name
STRINGS.CHARACTER_DESCRIPTIONS[name] = ""
STRINGS.CHARACTER_QUOTES[name] = "\"Nagisa just wanna eat cheese again~\""-- 渚我只是想再吃一次奶酪啦~

STRINGS.CHARACTERS[string.upper(name)] = require("speech_"..name)
 
STRINGS.NAMES[string.upper(name)] = "Momoe Nagisa"

STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(name)] = 
{
    GENERIC = "It's Momoe Nagisa!",
    ATTACKER = "That Momoe Nagisa looks shifty...",
    MURDERER = "Murderer!",
    REVIVER = "Momoe Nagisa, friend of ghosts.",
    GHOST = "Momoe Nagisa could use a heart.",
}

AddMinimapAtlas("images/map_icons/"..name..".xml")
AddModCharacter(name, "FEMALE")

local builder_tag = AddRecipeTab( "Momoe Nagisa's Build", 99, "images/hud/"..name..".xml", name..".tex", name.."_build") 
AddRecipe("trumpet", {Ingredient("cutgrass", 8),Ingredient("twigs", 8),Ingredient("goldnugget", 2)}, builder_tag,  _G.TECH.SCIENCE_ONE,nil,nil,nil,nil,name.."_build", "images/inventoryimages/trumpet.xml", "trumpet.tex")
AddCookerRecipe("cookpot", { 
    name = "cheese" ,
    test = function(cooker, names, tags) return names.goatmilk and names.goatmilk > 1 and not tags.meat and not tags.monster end,
    weight = 1 ,
    priority = 10 ,
    cooktime = 3 ,
})

AddPrefabPostInit("world", function( inst ) 
    if not inst.GetServerGameMode then
        inst.GetServerGameMode = function( )
            return inst.gamemode
        end
    end
end)

if TheSim.RAILGetPlatform and (TheSim:RAILGetPlatform() == "TGP" or TheSim:RAILGetPlatform() == "WG") then
    for _, mod in ipairs(_G.ModManager.mods) do 
        if mod and mod.modinfo and mod.modinfo.id == modname or mod.modinfo.name == modname then
            _G.KnownModIndex:Disable(modname)
        end
    end
    _G.Shutdown()
end
