--[[
作者：小开心
请不要擅自修改或删除
请尊重版权
@

说明：
想患 懒癌强迫症
]]

local function EntityWatchWorldState(self, var, fn)
    if self.worldstatewatching == nil then
        self.worldstatewatching = {}
    end

    local watcherfns = self.worldstatewatching[var]
    if watcherfns == nil then
        watcherfns = {}
        self.worldstatewatching[var] = watcherfns
    end

    table.insert(watcherfns, fn)
end

function EntityScript:WatchWorldState(var, fn)
    EntityWatchWorldState(self, var, fn)
    TheWorld.components.worldstate:AddWatcher(var, self, fn, self)
end

local oldCreateEntity = CreateEntity
function CreateEntity( )
    local ent = oldCreateEntity( )        
    local entity = getmetatable(ent.entity)
    entity.__index.AddNetwork = function( ... ) end
    entity.__index.SetPristine = function( ... ) end 
    return ent
end

function CreatePrefabSkin(name, info)
    local prefab_skin = Prefab(name, nil, info.assets, info.prefabs)
    prefab_skin.is_skin = true

    prefab_skin.base_prefab         = info.base_prefab
    prefab_skin.type                = info.type
    prefab_skin.skin_tags           = info.skin_tags
    prefab_skin.init_fn             = info.init_fn
    prefab_skin.build_name          = info.build_name
    prefab_skin.bigportrait         = info.bigportrait
    prefab_skin.rarity              = info.rarity
    prefab_skin.rarity_modifier     = info.rarity_modifier
    prefab_skin.skins               = info.skins
    prefab_skin.disabled            = info.disabled
    prefab_skin.granted_items       = info.granted_items
    prefab_skin.marketable          = info.marketable
    prefab_skin.release_group       = info.release_group

    if info.torso_tuck_builds ~= nil then
        for _,base_skin in pairs(info.torso_tuck_builds) do
            BASE_TORSO_TUCK[base_skin] = "full"
        end
    end

    if info.torso_untuck_builds ~= nil then
        for _,base_skin in pairs(info.torso_untuck_builds) do
            BASE_TORSO_TUCK[base_skin] = "untucked"
        end
    end

    if info.torso_untuck_wide_builds ~= nil then
        for _,base_skin in pairs(info.torso_untuck_wide_builds) do
            BASE_TORSO_TUCK[base_skin] = "untucked_wide"
        end
    end

    if info.has_alternate_for_body ~= nil then
        for _,base_skin in pairs(info.has_alternate_for_body) do
            BASE_ALTERNATE_FOR_BODY[base_skin] = true
        end
    end

    if info.has_alternate_for_skirt ~= nil then
        for _,base_skin in pairs(info.has_alternate_for_skirt) do
            BASE_ALTERNATE_FOR_SKIRT[base_skin] = true
        end
    end

    if info.legs_cuff_size ~= nil then
        for base_skin,size in pairs(info.legs_cuff_size) do
            BASE_LEGS_SIZE[base_skin] = size
        end
    end

    if info.feet_cuff_size ~= nil then
        for base_skin,size in pairs(info.feet_cuff_size) do
            BASE_FEET_SIZE[base_skin] = size
        end
    end

    --HAS_LEG_BOOT not yet tested
    if info.has_leg_boot_builds ~= nil then
        for _,base_skin in pairs(info.has_leg_boot_builds) do
            HAS_LEG_BOOT[base_skin] = true
        end
    end

    if info.fx_prefab ~= nil then
        SKIN_FX_PREFAB[name] = info.fx_prefab
    end

    return prefab_skin
end

function table.invert(t)
    local invt = {}
    for k, v in pairs(t) do
        invt[v] = k
    end
    return invt
end

local memoizedFilePaths = {}
function resolvefilepath( filepath, force_path_search ) 
    if memoizedFilePaths[filepath] then 
        return memoizedFilePaths[filepath]
    end
    local resolved = softresolvefilepath(filepath, force_path_search)
    assert(resolved ~= nil, "Could not find an asset matching "..filepath.." in any of the search paths.")
    memoizedFilePaths[filepath] = resolved 
   return resolved
end

function MakeHauntableLaunch( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntableLaunchAndSmash( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end   
end

function MakeHauntableWork( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntableWorkAndIgnite( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntableFreeze( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntableIgnite( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntableLaunchAndIgnite( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function DoChangePrefab( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntableChangePrefab( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntableLaunchOrChangePrefab( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntablePerish( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntableLaunchAndPerish( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntablePanic( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntablePanicAndIgnite( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntablePlayAnim( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntableGoToState( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntableDropFirstItem( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function MakeHauntableLaunchAndDropFirstItem( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function AddHauntableCustomReaction( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end

function AddHauntableDropItemOrWork( inst )
    if not inst.components.hauntable then
        inst:AddComponent("hauntable")
    end
end
