--[[
作者：小开心
请不要擅自修改或删除
请尊重版权
@

说明：
想患 懒癌强迫症
]]

local name = "cheese"
local eatername = "nagisa"

local assets =
{
    Asset("ANIM", "anim/"..name..".zip"), 

    Asset( "ATLAS", "images/inventoryimages/"..name..".xml" ),
}

local prefabs =
{

}

local function cheesetimetaskfn( inst )
    if GetTime() - inst.cheesetime >= 60 then
        inst.components.combat.damagemultiplier = 1
        inst:RemoveTag(name.."time")
        xk.RemoveSpeed(inst, name.."time")
    else
        inst:DoTaskInTime(60 - GetTime() + inst.cheesetime, cheesetimetaskfn)
    end
end

local function oneatenfn( inst, eater )
    if eater.prefab == eatername then
        eater[name.."time"] = GetTime()
        if not eater:HasTag(name.."time") then
            eater:DoTaskInTime(60 , cheesetimetaskfn)
            eater.components.combat.damagemultiplier = 1.25
        end
        eater:AddTag(name.."time")
        xk.MakeSpeed(eater, name.."time", 1.8 )
    end
end

local function fn(  )
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst:AddTag("catfood")

    inst.AnimState:SetBank(name)
    inst.AnimState:SetBuild(name)
    inst.AnimState:PlayAnimation("idle") 
 
    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable") 

    inst:AddComponent("edible")
    --inst.components.edible.healthvalue = TUNING.HEALING_SUPERHUGE
    --inst.components.edible.sanityvalue = TUNING.SANITY_TINY
    --inst.components.edible.hungervalue = TUNING.CALORIES_SUPERHUGE
    inst.components.edible:SetOnEatenFn(oneatenfn)
    --inst.components.edible.foodtype =  "MEAT"
    local _GetHealth = inst.components.edible.GetHealth
    function inst.components.edible:GetHealth(eater)
        if eater.prefab == eatername then
            return TUNING.HEALING_SUPERHUGE
        else
            return _GetHealth(self, eater)
        end
    end
    local _GetSanity = inst.components.edible.GetSanity
    function inst.components.edible:GetSanity(eater)
        if eater.prefab == eatername then
            return TUNING.SANITY_TINY * 10
        else
            return _GetSanity(self, eater)
        end
    end
    local _GetHunger = inst.components.edible.GetHunger
    function inst.components.edible:GetHunger(eater)
        if eater.prefab == eatername then
            return TUNING.CALORIES_SUPERHUGE
        else
            return _GetHunger(self, eater)
        end
    end

    inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST) 
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/"..name..".xml"
    inst.components.inventoryitem.imagename = name

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    if TheWorld:GetServerGameMode() == "MST" then
        xk.magicgirl_server_data("Server/", "prefabs/"..name).master_postinit(inst)
    end

    --MakeHauntableLaunch(inst)
    MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    MakeHauntableLaunchAndPerish(inst)
    MakeInventoryFloatable(inst, "idle", "idle")

    return inst       
end

STRINGS.NAMES[string.upper(name)] = name
--STRINGS.RECIPE_DESC[string.upper(name)] = ""
STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(name)] = "Momoe Nagisa's favorite cheese."

--table.insert(Prefabs["cookpot"].assets, Asset("ANIM", "anim/"..name..".zip") )

return Prefab(name, fn, assets, prefabs)
