--[[
作者：小开心
请不要擅自修改或删除
请尊重版权
@

说明：
想患 懒癌强迫症
]]

local name = "trumpet"
local ownername = "nagisa"

local assets =
{
    Asset("ANIM", "anim/"..name..".zip"),
--    Asset("ANIM", "anim/swap_"..name..".zip"),

    Asset( "IMAGE", "images/inventoryimages/"..name..".tex" ),
    Asset( "ATLAS", "images/inventoryimages/"..name..".xml" ),
}

local function onequip( inst , owner )
    owner.AnimState:OverrideSymbol("swap_object" , name , "swap_weapon")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")

    if owner.prefab == ownername then
        xk.SetDamage(inst, 55)
    end
    owner.components.combat:SetAttackPeriod( .75 )
end

local function onunequip( inst , owner )
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")

    xk.SetDamage(inst, 10)
    owner.components.combat:SetAttackPeriod(TUNING.WILSON_ATTACK_PERIOD)
end

local function attackfn( inst , owner , target )
    if not target or not target:IsValid()then
        return
    end
    if owner.components.health then 
    --    owner.components.health:DoDelta( -2 )
    end
    if target.components.health.maxhealth < TUNING.GRUEDAMAGE / 2 and not target:HasTag("monster") then 
        owner.components.combat:GetAttacked(target:HasTag("_combat") and target or nil , math.clamp((TUNING.GRUEDAMAGE / 2 - target.components.health.maxhealth) / 2 , 5 , 25))
    end
    if not target.components.health:IsDead() then
        xk.WorkedBy(target, owner)
    end 
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank(name)
    inst.AnimState:SetBuild(name)
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("guns")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    --inst.components.weapon:SetDamage( 55 )
    inst.components.weapon:SetRange( 5 , 12 )
    inst.components.weapon:SetOnAttack( attackfn )  
    inst.components.weapon:SetProjectile("blossom_projectile")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/"..name..".xml"
    inst.components.inventoryitem.imagename = name

    inst:AddComponent("inspectable")

    xk.SetFiniteuses(inst, TUNING.SPEAR_USES)

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip(onunequip)

    if TheWorld:GetServerGameMode() == "MST" then
        xk.magicgirl_server_data("Server/", "prefabs/"..name).master_postinit(inst)
    end

    MakeHauntableLaunch(inst)
    MakeInventoryFloatable(inst, "idle", "idle")

    return inst
end

STRINGS.NAMES[string.upper(name)] = name
STRINGS.RECIPE_DESC[string.upper(name)] = "Make "..name.." !"
STRINGS.CHARACTERS.GENERIC.DESCRIBE[string.upper(name)] = "Momoe Nagisa's trumpet !"

return Prefab(name , fn , assets)
