local assets =
{
    Asset("ANIM", "anim/ramiobat.zip"),
    Asset("ANIM", "anim/swap_ramiobat.zip"),
    Asset("ATLAS", "images/inventoryimages/ramiobat.xml"),
    Asset("IMAGE", "images/inventoryimages/ramiobat.tex"),
}

local function OnEquip(inst, owner)
	-- if owner:HasTag("ramio_buff") then
    owner.AnimState:OverrideSymbol("swap_object", "swap_ramiobat", "swap_ramiobat")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
	-- else
            -- inst:DoTaskInTime(0, function()
                -- if owner and owner.components and owner.components.inventory then
                    -- owner.components.inventory:GiveItem(inst)
                    -- if owner.components.talker then
                        -- owner.components.talker:Say("I can't use that.")
                -- end
            -- end
        -- end)
	--end
end
  
local function OnUnequip(inst, owner)
	--if owner:HasTag("ramio_buff") then
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
	--end
end
 
local function fn()
  
    local inst = CreateEntity()
 
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
	inst.entity:AddMiniMapEntity()
     
    MakeInventoryPhysics(inst)   
      
    inst.AnimState:SetBank("ramiobat")
    inst.AnimState:SetBuild("ramiobat")
    inst.AnimState:PlayAnimation("idle")
	
    inst.MiniMapEntity:SetIcon("ramiobat.tex")
	
	inst:AddTag("ramio_gear")
 
    if not TheWorld.ismastersim then
        return inst
    end
 
    inst.entity:SetPristine()

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(65)
  
    inst:AddComponent("inspectable")

	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(200)
	inst.components.finiteuses:SetUses(200)
	inst.components.finiteuses:SetOnFinished(inst.Remove)
      
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "ramiobat"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/ramiobat.xml"
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
    return inst
end
return  Prefab("common/inventory/ramiobat", fn, assets) 