local assets =
{ 
    Asset("ANIM", "anim/ramiohat.zip"),
    Asset("ANIM", "anim/swap_ramiohat.zip"), 

    Asset("ATLAS", "images/inventoryimages/ramiohat.xml"),
    Asset("IMAGE", "images/inventoryimages/ramiohat.tex"),
}

local prefabs = 
{
}

local function OnEquip(inst, owner)
		-- if owner:HasTag("ramio_buff") then
        owner.AnimState:OverrideSymbol("swap_hat", "swap_ramiohat", "swap_ramiohat")
        owner.AnimState:Show("HAT")
		
	-- if owner:HasTag("player") then
        owner.AnimState:Hide("HEAD")
        owner.AnimState:Show("HEAD_HAT")
    -- end
        -- else
            -- inst:DoTaskInTime(0, function()
                -- if owner and owner.components and owner.components.inventory then
                    -- owner.components.inventory:GiveItem(inst)
                    -- if owner.components.talker then
                        -- owner.components.talker:Say("I can't use that.")
                -- end
            -- end
        -- end)
    -- end
end

local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("HAT")
		owner.AnimState:Show("HEAD")
        owner.AnimState:Hide("HEAD_HAT")
end

local function fn()

    local inst = CreateEntity()
	
	inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
	
	inst:AddTag("hat")
	
    MakeInventoryPhysics(inst)
	
	inst.AnimState:SetBank("ramiohat")
    inst.AnimState:SetBuild("ramiohat")
    inst.AnimState:PlayAnimation("idle")
	
	inst:AddTag("ramio_gear")
	
	if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddComponent("inspectable")

    inst:AddComponent("tradable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "ramiohat"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/ramiohat.xml"

	inst:AddComponent("armor")
	inst.components.armor:InitCondition(TUNING.ARMOR_FOOTBALLHAT, TUNING.ARMOR_FOOTBALLHAT_ABSORPTION)
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	inst.components.inventoryitem.keepondeath = true
	
	MakeHauntableLaunch(inst)

    return inst
end

return  Prefab("common/inventory/ramiohat", fn, assets, prefabs)