require "prefabutil"

local assets =
{
		Asset("ANIM", "anim/wall.zip"),
		Asset("ANIM", "anim/brick_wall.zip"),
		
		Asset("ANIM", "anim/zhuan.zip"),
		Asset("ANIM", "anim/swap_zhuan.zip"),
		
		Asset("ATLAS", "images/inventoryimages/zhuan.xml")
}

local function onhammered(inst, worker)
	local num_loots = math.max(1, math.floor(2*inst.components.health:GetPercent()))
	for k = 1, num_loots do
	inst.components.lootdropper:SpawnLootPrefab("rocks")
	end

		
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
		
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_stone")		

		
	inst:Remove()
end

local function test_wall(inst, pt)
	local tiletype = GetGroundTypeAtPosition(pt)
	local ground_OK = tiletype ~= GROUND.IMPASSABLE 
		
	if ground_OK then
	local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 2, nil, {"NOBLOCK", "player", "FX", "INLIMBO", "DECOR"}) -- or we could include a flag to the search?

	for k, v in pairs(ents) do
	if v ~= inst and v.entity:IsValid() and v.entity:IsVisible() and not v.components.placer and v.parent == nil then
	local dsq = distsq( Vector3(v.Transform:GetWorldPosition()), pt)
	if v:HasTag("wall") then
	if dsq < .1 then return false end
	else
	if  dsq< 1 then return false end
	end
	end
	end
			
	return true

	end
	return false
		
end

local function makeobstacle(inst)

	inst.Physics:SetCollisionGroup(COLLISION.OBSTACLES)	
	inst.Physics:ClearCollisionMask()
	inst.Physics:SetMass(0)
	inst.Physics:CollidesWith(COLLISION.ITEMS)
	inst.Physics:CollidesWith(COLLISION.CHARACTERS)
	inst.Physics:SetActive(true)
	local ground = GetWorld()
	if ground then
	local pt = Point(inst.Transform:GetWorldPosition())
	ground.Pathfinder:AddWall(pt.x, pt.y, pt.z)
	end
end

local function clearobstacle(inst)
	inst:DoTaskInTime(2*FRAMES, function() inst.Physics:SetActive(false) end)

	local ground = GetWorld()
	if ground then
	local pt = Point(inst.Transform:GetWorldPosition())
	ground.Pathfinder:RemoveWall(pt.x, pt.y, pt.z)
	end
end

local function resolveanimtoplay(percent)
	
	local anim_to_play = nil
	if percent <= 0 then
	anim_to_play = "0"
	elseif percent <= .4 then
	anim_to_play = "1_4"
	elseif percent <= .5 then
	anim_to_play = "1_2"
	elseif percent < 1 then
	anim_to_play = "3_4"
	else
	anim_to_play = "1"
	end
	return anim_to_play
end

local function onhealthchange(inst, old_percent, new_percent)
		
	if old_percent <= 0 and new_percent > 0 then makeobstacle(inst) end
	if old_percent > 0 and new_percent <= 0 then clearobstacle(inst) end

	local anim_to_play = resolveanimtoplay(new_percent)
	if new_percent > 0 then
		inst.AnimState:PlayAnimation(anim_to_play.."_hit")
		inst.AnimState:PushAnimation(anim_to_play, false)
	else
		inst.AnimState:PlayAnimation(anim_to_play)
	end
end

local function ondeploywall(inst, pt, deployer)
	local wall = SpawnPrefab("brick_wall") 
	if wall then 
	pt = Vector3(math.floor(pt.x)+.5, 0, math.floor(pt.z)+.5)
	wall.Physics:SetCollides(false)
	wall.Physics:Teleport(pt.x, pt.y, pt.z) 
	wall.Physics:SetCollides(true)
	--inst.components.stackable:Get():Remove()--本身不可折叠

	local ground = GetWorld()
	if ground then
	ground.Pathfinder:AddWall(pt.x, pt.y, pt.z)
	end
	end 		
end

-----------------------------------------------------

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_zhuan", "swap_nightmaresword")

    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function itemfn(Sim)

	local inst = CreateEntity()
	
	inst:AddTag("wallbuilder")
	inst:AddTag("zhuan")
	inst:AddTag("wall")
		
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
	    
    inst.AnimState:SetBank("zhuan")
    inst.AnimState:SetBuild("zhuan")
	inst.AnimState:PlayAnimation("idle")

	inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/zhuan.xml"
	
    inst:AddComponent("weapon")
    inst.components.weapon:SetRange(8)
    inst.components.weapon:SetDamage(50)

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(4)
    inst.components.finiteuses:SetUses(4)
    
    inst.components.finiteuses:SetOnFinished( onfinished )
	
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(70)
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
		
	inst:AddComponent("repairer")
	inst.components.repairer.repairmaterial = "stone"
	inst.components.repairer.healthrepairvalue = TUNING.STONEWALL_HEALTH / 2
		
	inst:AddComponent("deployable")
	inst.components.deployable.ondeploy = ondeploywall
	inst.components.deployable.test = test_wall
	inst.components.deployable.min_spacing = 0  --间距
	inst.components.deployable.placer = "brick_wall_placer"  ----注明
		
	return inst
end

local function onhit(inst)
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_stone")

	local healthpercent = inst.components.health:GetPercent()
	local anim_to_play = resolveanimtoplay(healthpercent)
	if healthpercent <= 0 then
	inst.AnimState:PlayAnimation("0")
	elseif healthpercent > 0 then
	inst.AnimState:PlayAnimation(anim_to_play.."_hit")		
	inst.AnimState:PushAnimation(anim_to_play, false)	
	end	

end

local function onrepaired(inst)
		inst.SoundEmitter:PlaySound("dontstarve/common/place_structure_stone")
		makeobstacle(inst)
end
	    
local function onload(inst, data)
		--print("walls - onload")
		makeobstacle(inst)
		if inst.components.health:GetPercent() <= 0 then
			clearobstacle(inst)
		end
end

local function onremoveentity(inst)
		clearobstacle(inst)
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst:AddTag("wall")
	inst:AddTag("stone")
	inst:AddTag("noauradamage")
	MakeObstaclePhysics(inst, .5)    
	inst.entity:SetCanSleep(false)
	anim:SetBank("brick_wall")
	anim:SetBuild("brick_wall")
	anim:PlayAnimation("1_2", false)
	    
	inst:AddComponent("inspectable")
	inst:AddComponent("lootdropper")
				
	inst:AddComponent("repairable")
	inst.components.repairable.repairmaterial = "stone"
	inst.components.repairable.onrepaired = onrepaired
		
	inst:AddComponent("combat")
	inst.components.combat.onhitfn = onhit
		
	inst:AddComponent("health")
	inst.components.health:SetMaxHealth(TUNING.STONEWALL_HEALTH)
	inst.components.health.currenthealth = TUNING.STONEWALL_HEALTH / 2  --当前健康
	inst.components.health.ondelta = onhealthchange
	inst.components.health.nofadeout = true
	inst.components.health.canheal = false
	inst:AddTag("noauradamage")
		
	inst.components.health.fire_damage_scale = 0

	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_stone")
		
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
	inst.components.workable:SetWorkLeft(3)
	inst.components.workable:SetOnFinishCallback(onhammered)
	inst.components.workable:SetOnWorkCallback(onhit) 
				
		
	inst.OnLoad = onload
	inst.OnRemoveEntity = onremoveentity
		
	MakeSnowCovered(inst)
		
	return inst
end

STRINGS.NAMES.BRICK_WALL = "Wall"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.BRICK_WALL = "Engineering Technology."

STRINGS.NAMES.ZHUAN = "Brick"
STRINGS.RECIPE_DESC.ZHUAN = "This wall will protect you."
STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZHUAN = "Head over, I'll give you a buff."

return Prefab( "common/brick_wall", fn, assets),
Prefab( "common/zhuan", itemfn, assets, {"brick_wall", "brick_wall_placer"}),
MakePlacer("common/brick_wall_placer", "brick_wall", "brick_wall", "1_2")