local fileroot = ".\\modules\\EvoSwitcher\\EvoStadium"
local tid
local m = {}

local function set_random(ctx)
	tid = ctx.tournament_id
	home = ctx.home_team
	away = ctx.away_team
end

function make_key(ctx, filename)
	if home == 109 and ctx.stadium == 13 then
	    EvoStadium = "Santiago Bernabeu"
	else
		EvoStadium = nil
	end

    if tid then
       return string.format("%s:%s", EvoStadium, filename)
    end
end

local function get_filepath(ctx, filename, key)
    if key and EvoStadium ~= nil then
        return string.format("%s\\%s\\%s", fileroot, EvoStadium, filename)
    end
end

function m.set_stadium(ctx, options)
    tid = ctx.tournament_id
    if (ctx.match_info == 53) and (tid == 2 or tid == 3 or tid == 4 or tid == 400 or tid == 401 or tid == 402 or tid == 403 or tid == 404 or tid == 405 or tid == 406 or tid == 600  or tid == 601 or tid == 602 or tid == 603 or tid == 604 or tid == 605 or tid == 606 or tid == 607) then
	   options.stadium = 56
	   options.weather = 1
       options.weather_effects = 1
       options.timeofday = 1
       options.season = 1
       return options
	end
end

local function trophy_rewrite(ctx, tournament_id)
	if EvoStadium ~= nil then
		log("----- " .. EvoStadium)
	else
		log("----- Default")
	end
end


function m.init(ctx)
	ctx.register("set_conditions", set_random)
    ctx.register("livecpk_make_key", make_key)
    ctx.register("livecpk_get_filepath", get_filepath)
    ctx.register("set_stadium", m.set_stadium)
    ctx.register("trophy_rewrite", trophy_rewrite)
end

return m
