/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.dataengine.CDBJDBCNativeResultSet;
import com.simba.cassandra.cassandra.dataengine.CDBJDBCResultSet;
import com.simba.cassandra.cassandra.dataengine.CDBJDBCRowCount;
import com.simba.cassandra.cassandra.dataengine.utils.CDBJDBCUtils;
import com.simba.cassandra.cassandra.utils.CDBJDBCDataTypeUtilities;
import com.simba.cassandra.dsi.dataengine.impl.DSIEmptyResultSet;
import com.simba.cassandra.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.simba.cassandra.dsi.dataengine.interfaces.IQueryExecutor;
import com.simba.cassandra.dsi.dataengine.interfaces.IResultSet;
import com.simba.cassandra.dsi.dataengine.interfaces.IRowCountResult;
import com.simba.cassandra.dsi.dataengine.utilities.ExecutionContext;
import com.simba.cassandra.dsi.dataengine.utilities.ExecutionContexts;
import com.simba.cassandra.dsi.dataengine.utilities.ExecutionResult;
import com.simba.cassandra.dsi.dataengine.utilities.ExecutionResultType;
import com.simba.cassandra.dsi.dataengine.utilities.ExecutionResults;
import com.simba.cassandra.dsi.dataengine.utilities.Nullable;
import com.simba.cassandra.dsi.dataengine.utilities.ParameterInputValue;
import com.simba.cassandra.dsi.dataengine.utilities.ParameterMetadata;
import com.simba.cassandra.dsi.dataengine.utilities.ParameterType;
import com.simba.cassandra.dsi.dataengine.utilities.TypeMetadata;
import com.simba.cassandra.dsi.exceptions.BadDefaultParamException;
import com.simba.cassandra.dsi.exceptions.ExecutingException;
import com.simba.cassandra.dsi.exceptions.OperationCanceledException;
import com.simba.cassandra.dsi.exceptions.ParsingException;
import com.simba.cassandra.shaded.datastax.driver.core.BoundStatement;
import com.simba.cassandra.shaded.datastax.driver.core.ColumnDefinitions;
import com.simba.cassandra.shaded.datastax.driver.core.PreparedStatement;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSetFuture;
import com.simba.cassandra.shaded.datastax.driver.core.Session;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.IWarningListener;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CDBJDBCQueryExecutor
implements IQueryExecutor {
    private static final String SELECT_CASE = "select";
    private static final String LIST_CASE = "list";
    private ExecutionResults m_executionResults = new ExecutionResults();
    private int m_fetchSize;
    private boolean m_hasBeenExecuted = false;
    private boolean m_isDirectExecution;
    private boolean m_isRowCount;
    private ILogger m_logger;
    private List<ColumnDefinitions.Definition> m_parameterDefinitions;
    private List<ParameterMetadata> m_parameterColumnMetadata = new ArrayList<ParameterMetadata>();
    private PreparedStatement m_preparedStatement;
    private String m_query;
    private Session m_session;
    private CDBJDBCConnectionSettings m_settings;

    public CDBJDBCQueryExecutor(String string, CDBJDBCConnectionSettings cDBJDBCConnectionSettings, Session session, boolean bl, int n, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, string, cDBJDBCConnectionSettings, session, bl, n);
        this.m_logger = iLogger;
        this.m_query = string;
        this.m_settings = cDBJDBCConnectionSettings;
        this.m_isDirectExecution = bl;
        this.m_session = session;
        this.m_isRowCount = CDBJDBCQueryExecutor.isRowCountResult(this.m_query);
        this.m_fetchSize = n;
        if (!this.m_isDirectExecution) {
            this.m_preparedStatement = CDBJDBCUtils.prepareQuery(session, string);
            ColumnDefinitions columnDefinitions = this.m_preparedStatement.getVariables();
            if (null != columnDefinitions) {
                this.m_parameterDefinitions = columnDefinitions.asList();
            }
        }
    }

    @Override
    public void cancelExecute() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Iterator<ExecutionResult> iterator = this.m_executionResults.getResultItr();
        ExecutionResult executionResult = null;
        while (iterator.hasNext()) {
            executionResult = iterator.next();
            if (ExecutionResultType.RESULT_SET == executionResult.getType()) {
                ((CDBJDBCResultSet)executionResult.getResult()).getResultSetFuture().cancel(true);
                continue;
            }
            ((CDBJDBCRowCount)executionResult.getResult()).getResultSetFuture().cancel(true);
        }
    }

    @Override
    public void clearCancel() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void clearPushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(this.m_logger, executionContexts, iWarningListener);
        ResultSetFuture resultSetFuture = null;
        if (this.m_isDirectExecution) {
            resultSetFuture = CDBJDBCUtils.executeQuery(this.m_session, this.m_query, this.m_fetchSize);
        } else {
            object = executionContexts.contextIterator();
            ExecutionContext executionContext = null;
            while (object.hasNext()) {
                executionContext = object.next();
                BoundStatement boundStatement = CDBJDBCUtils.bindParameter(this.m_preparedStatement, executionContext.getInputs(), this.m_logger);
                resultSetFuture = CDBJDBCUtils.executePreparedStatement(this.m_session, boundStatement, this.m_fetchSize);
            }
        }
        if (this.m_isRowCount) {
            object = new CDBJDBCRowCount(this.m_logger, resultSetFuture, this.m_query);
            this.m_executionResults.addRowCountResult((IRowCountResult)object);
        } else {
            object = new CDBJDBCNativeResultSet(this.m_logger, resultSetFuture, this.m_query, this.m_settings);
            this.m_executionResults.addResultSet((IResultSet)object);
        }
        this.m_hasBeenExecuted = true;
    }

    @Override
    public void finalizePushedParamData() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ParameterMetadata parameterMetadata = null;
        int n = 1;
        if (this.m_parameterColumnMetadata.isEmpty()) {
            for (ColumnDefinitions.Definition definition : this.m_parameterDefinitions) {
                parameterMetadata = CDBJDBCDataTypeUtilities.createParameterColumn(n, definition, this.m_settings);
                this.m_parameterColumnMetadata.add(n - 1, parameterMetadata);
                ++n;
            }
        }
        return (ArrayList)this.m_parameterColumnMetadata;
    }

    @Override
    public int getNumParams() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return 0;
    }

    @Override
    public ExecutionResults getResults() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (!this.m_hasBeenExecuted) {
            ExecutionResults executionResults = new ExecutionResults();
            if (!this.m_isRowCount) {
                executionResults.addResultSet(new DSIEmptyResultSet());
            } else {
                executionResults.addRowCountResult(new DSISimpleRowCountResult(-1L));
            }
            return executionResults;
        }
        return this.m_executionResults;
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, parameterInputValue);
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Integer n = null;
        for (Map.Entry<Integer, TypeMetadata> entry : map.entrySet()) {
            if (!entry.getValue().isExactNumericType()) continue;
            n = entry.getKey();
            TypeMetadata typeMetadata = TypeMetadata.createTypeMetadata(12);
            typeMetadata.setIntervalPrecision(this.m_settings.m_stringColumnLength);
            entry.setValue(typeMetadata);
            ParameterMetadata parameterMetadata = new ParameterMetadata(n + 1, ParameterType.INPUT, typeMetadata, this.m_settings.m_stringColumnLength, this.m_parameterColumnMetadata.get(n).getName(), true, Nullable.NULLABLE);
            this.m_parameterColumnMetadata.set(n, parameterMetadata);
        }
    }

    private static boolean isRowCountResult(String string) {
        boolean bl = true;
        string = string.trim();
        if ((string = string.toLowerCase()).startsWith(SELECT_CASE) || string.startsWith(LIST_CASE)) {
            bl = false;
        }
        return bl;
    }
}

