/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.jsql.passdown;

import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.dataengine.jsql.passdown.CDBAggregationResult;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCReadTable;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEAggrFn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtAbstractAggregationHandler;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;

public class CDBAggregationHandler
extends DSIExtAbstractAggregationHandler {
    private boolean m_isPassDownPossible = false;
    private ILogger m_logger;
    private CDBJDBCConnectionSettings m_settings;
    private CDBJDBCReadTable m_table;

    public CDBAggregationHandler(CDBJDBCReadTable cDBJDBCReadTable, ILogger iLogger, CDBJDBCConnectionSettings cDBJDBCConnectionSettings) {
        LogUtilities.logFunctionEntrance(iLogger, cDBJDBCReadTable, cDBJDBCConnectionSettings);
        this.m_table = cDBJDBCReadTable;
        this.m_logger = iLogger;
        this.m_settings = cDBJDBCConnectionSettings;
    }

    @Override
    protected DSIExtJResultSet takeResult() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        CDBAggregationResult cDBAggregationResult = null;
        if (this.m_isPassDownPossible) {
            try {
                cDBAggregationResult = new CDBAggregationResult(this.m_table, this.m_logger, this.m_settings);
            }
            catch (ErrorException errorException) {
                LogUtilities.logError(errorException, this.m_logger);
            }
        }
        return cDBAggregationResult;
    }

    @Override
    protected boolean setAggregateFn(AEAggrFn.AggrFnId aggrFnId, boolean bl, AEValueExpr ... aEValueExprArray) {
        AELiteral aELiteral;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{aggrFnId, bl, aEValueExprArray});
        AEValueExpr aEValueExpr = null;
        if (0 != aEValueExprArray.length) {
            aEValueExpr = aEValueExprArray[0];
        }
        if (AEAggrFn.AggrFnId.COUNT_STAR == aggrFnId && null == aEValueExpr) {
            this.m_isPassDownPossible = true;
            return true;
        }
        if (aEValueExpr instanceof AELiteral && AEAggrFn.AggrFnId.COUNT == aggrFnId && (aELiteral = (AELiteral)aEValueExpr).getStringValue().equals("1")) {
            this.m_isPassDownPossible = true;
            return true;
        }
        return false;
    }

    @Override
    protected boolean setGroupingExpr(AEValueExpr aEValueExpr) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return false;
    }
}

