/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.jsql.passdown;

import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCReadTable;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtAbstractProjectionHandler;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CDBProjectionHandler
extends DSIExtAbstractProjectionHandler {
    private Map<String, String> m_aliasNamesMap;
    private List<IColumn> m_columns = new ArrayList<IColumn>();
    private Map<String, String> m_correlationNamesMap;
    private boolean m_isPassDownPossible = false;
    private ILogger m_logger;
    private List<Integer> m_projectionMappings = new ArrayList<Integer>();
    private CDBJDBCReadTable m_table;

    public CDBProjectionHandler(CDBJDBCReadTable cDBJDBCReadTable, ILogger iLogger) {
        LogUtilities.logFunctionEntrance(iLogger, cDBJDBCReadTable);
        this.m_table = cDBJDBCReadTable;
        this.m_logger = iLogger;
    }

    @Override
    protected void passdownColumnRef(AEColumnReference aEColumnReference, String string) throws ErrorException {
        String string2;
        String string3 = aEColumnReference.getColumn().getName();
        if (string3 != (string2 = aEColumnReference.getNamedRelationalExpr().getBaseColumn(aEColumnReference.getColumnNum()).getName())) {
            if (null == this.m_correlationNamesMap) {
                this.m_correlationNamesMap = new HashMap<String, String>();
            }
            this.m_correlationNamesMap.put(string3, string2);
        }
        if (null != string) {
            if (null == this.m_aliasNamesMap) {
                this.m_aliasNamesMap = new HashMap<String, String>();
            }
            this.m_aliasNamesMap.put(aEColumnReference.getName(), string);
        }
        this.m_columns.add(aEColumnReference.getColumn());
        this.m_projectionMappings.add(aEColumnReference.getColumnNum());
        this.m_isPassDownPossible = true;
    }

    @Override
    protected DSIExtJResultSet takeResult() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        CDBJDBCReadTable cDBJDBCReadTable = null;
        if (this.m_isPassDownPossible) {
            this.m_isPassDownPossible = false;
            this.m_table.setProjectionVariables(this.m_aliasNamesMap, this.m_correlationNamesMap, this.m_columns, this.m_projectionMappings);
            cDBJDBCReadTable = this.m_table;
        }
        return cDBJDBCReadTable;
    }
}

