/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.table;

import com.simba.cassandra.cassandra.core.CDBJDBCConnection;
import com.simba.cassandra.cassandra.core.CDBJDBCConnectionSettings;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.dataengine.CDBJDBCNativeResultSet;
import com.simba.cassandra.cassandra.dataengine.CDBJDBCResultSet;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.CDBJDBCColumnMetadata;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.CDBJDBCVirtualTableMetadata;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.ICDBJDBCTableMetadata;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCResultsBase;
import com.simba.cassandra.cassandra.dataengine.utils.CDBJDBCUtils;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.dsi.core.impl.DSIDriver;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.interfaces.IResultSet;
import com.simba.cassandra.dsi.dataengine.utilities.CursorType;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.utilities.DSIMessageKey;
import com.simba.cassandra.shaded.datastax.driver.core.ColumnMetadata;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSetFuture;
import com.simba.cassandra.shaded.datastax.driver.core.Row;
import com.simba.cassandra.shaded.datastax.driver.core.Session;
import com.simba.cassandra.sqlengine.dsiext.dataengine.OpenTableType;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.IWarningListener;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CDBJDBCReadTable
extends CDBJDBCResultsBase {
    protected Map<String, String> m_aliasNamesMap;
    protected Map<String, String> m_aliasToOriginalNamesMap;
    private boolean m_allowFilteringNeeded = false;
    protected String m_cassTableName;
    protected String m_catalogName;
    protected List<IColumn> m_columnMetadata = null;
    protected Map<String, Integer> m_columnNameIndexMapping = new HashMap<String, Integer>();
    protected Map<String, CDBJDBCColumnMetadata> m_columnNameMetadataMapping = new HashMap<String, CDBJDBCColumnMetadata>();
    protected CDBJDBCConnection m_connection;
    protected Map<String, String> m_correlationNamesMap;
    protected Row m_currentRow;
    protected int m_fetchSize;
    protected String m_filter;
    protected boolean m_isVirtual;
    protected OpenTableType m_openType;
    protected Long m_limit;
    protected ILogger m_logger;
    protected String m_originalQuery;
    protected Set<Integer> m_primaryKeyIndices = new HashSet<Integer>();
    protected List<IColumn> m_projectedColumns;
    protected List<Integer> m_projectionMappings;
    private String m_query;
    protected IResultSet m_resultSet;
    protected String m_schemaName;
    protected Session m_session;
    protected CDBJDBCConnectionSettings m_settings;
    protected ICDBJDBCTableMetadata m_tableMetadata;
    protected String m_tableName;
    protected IWarningListener m_warningListener;

    public CDBJDBCReadTable(CDBJDBCConnection cDBJDBCConnection, ICDBJDBCTableMetadata iCDBJDBCTableMetadata, String string, String string2, String string3, int n, String string4, OpenTableType openTableType, ILogger iLogger) throws ErrorException {
        super(false);
        LogUtilities.logFunctionEntrance(iLogger, iCDBJDBCTableMetadata, string, string2, string3);
        this.m_connection = cDBJDBCConnection;
        this.m_logger = iLogger;
        this.m_session = cDBJDBCConnection.getSession();
        this.m_settings = this.m_connection.getConnectionSettings();
        this.m_tableMetadata = iCDBJDBCTableMetadata;
        this.m_originalQuery = string4;
        this.m_openType = openTableType;
        this.m_catalogName = string;
        this.m_schemaName = string2;
        this.m_tableName = string3;
        this.m_fetchSize = n;
        if (this.m_tableMetadata.isVirtualTable()) {
            CDBJDBCVirtualTableMetadata cDBJDBCVirtualTableMetadata = (CDBJDBCVirtualTableMetadata)this.m_tableMetadata;
            this.m_cassTableName = cDBJDBCVirtualTableMetadata.getParentTable().getName();
            this.m_isVirtual = true;
        } else {
            this.m_cassTableName = this.m_tableMetadata.getName();
        }
        this.m_columnMetadata = this.m_tableMetadata.getColumns(null);
        for (IColumn iColumn : this.m_columnMetadata) {
            this.m_columnNameMetadataMapping.put(iColumn.getName(), (CDBJDBCColumnMetadata)iColumn);
        }
    }

    public void addFilters(String string) {
        this.m_filter = string;
    }

    public void addLimit(long l) {
        this.m_limit = l;
    }

    @Override
    public void appendRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public void close() {
        if (null != this.m_resultSet) {
            this.m_resultSet.close();
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        if (null != this.m_resultSet) {
            this.m_resultSet.closeCursor();
        }
    }

    @Override
    public void deleteRow() throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    @Override
    public String getCatalogName() {
        return this.m_catalogName;
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_resultSet) {
            ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.INVALID_QUERY_ERR.name(), new String[]{this.m_originalQuery, "Unknown reason"});
            throw errorException;
        }
        CDBJDBCColumnMetadata cDBJDBCColumnMetadata = null;
        if (null != this.m_projectionMappings) {
            int n2 = this.m_projectionMappings.get(n);
            cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n2);
        } else {
            cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n);
        }
        String string = null;
        if (this.m_isVirtual || cDBJDBCColumnMetadata.isUDT()) {
            object = cDBJDBCColumnMetadata.unwrap();
            string = ((ColumnMetadata)object).getName();
        } else {
            string = cDBJDBCColumnMetadata.getName();
        }
        object = string;
        if (null != this.m_aliasNamesMap && null != this.m_aliasNamesMap.get(string)) {
            if (null == this.m_aliasToOriginalNamesMap) {
                this.m_aliasToOriginalNamesMap = new HashMap<String, String>();
            }
            this.m_aliasToOriginalNamesMap.put(this.m_aliasNamesMap.get(string), (String)object);
            cDBJDBCColumnMetadata.setName(this.m_aliasNamesMap.get(string));
            cDBJDBCColumnMetadata.setLabel(this.m_aliasNamesMap.get(string));
        }
        if (null != this.m_aliasToOriginalNamesMap && this.m_aliasToOriginalNamesMap.containsKey(object)) {
            object = this.m_aliasToOriginalNamesMap.get(object);
        }
        if (null != this.m_correlationNamesMap && !this.m_correlationNamesMap.isEmpty()) {
            object = this.m_correlationNamesMap.get(object);
        }
        int n3 = n;
        if (this.m_columnNameIndexMapping.containsKey(object)) {
            n3 = this.m_columnNameIndexMapping.get(object);
        }
        if (cDBJDBCColumnMetadata.isCollection() || cDBJDBCColumnMetadata.isUDT()) {
            return ((CDBJDBCNativeResultSet)this.m_resultSet).getData(n3, cDBJDBCColumnMetadata, l, l2, dataWrapper);
        }
        return this.m_resultSet.getData(n3, l, l2, dataWrapper);
    }

    public String getFilter() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_filter;
    }

    public boolean isVirtualTable() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_isVirtual;
    }

    public ICDBJDBCTableMetadata getMetadata() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_tableMetadata;
    }

    @Override
    public long getRowCount() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_resultSet.getRowCount();
    }

    @Override
    public String getSchemaName() {
        return this.m_schemaName;
    }

    @Override
    public ArrayList<? extends IColumn> getSelectColumns() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_projectedColumns) {
            return (ArrayList)this.m_projectedColumns;
        }
        if (null == this.m_columnMetadata) {
            this.m_columnMetadata = this.m_tableMetadata.getColumns(null);
        }
        return (ArrayList)this.m_columnMetadata;
    }

    public Session getSession() {
        return this.m_session;
    }

    @Override
    public String getTableName() {
        return this.m_tableName;
    }

    @Override
    public boolean hasRowCount() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_resultSet.hasRowCount();
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        boolean bl = false;
        if (null == this.m_resultSet) {
            this.initResultSet();
        }
        this.m_currentRow = (bl = this.m_resultSet.moveToNextRow()) ? ((CDBJDBCNativeResultSet)this.m_resultSet).getCurrentRowValue() : null;
        return bl;
    }

    @Override
    public void onFinishRowUpdate() throws ErrorException {
    }

    @Override
    public void onStartRowUpdate() {
    }

    @Override
    public void registerWarningListener(IWarningListener iWarningListener) {
        this.m_warningListener = iWarningListener;
    }

    @Override
    public void reset() throws ErrorException {
    }

    public void setAllowFilteringNeeded() {
        this.m_allowFilteringNeeded = true;
    }

    @Override
    public void setCursorType(CursorType cursorType) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (CursorType.FORWARD_ONLY != cursorType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.CURSOR_NOT_SUPPORTED.name(), String.valueOf((Object)cursorType));
        }
        if (null == this.m_resultSet) {
            this.initResultSet();
        }
    }

    public void setProjectionVariables(Map<String, String> map, Map<String, String> map2, List<IColumn> list, List<Integer> list2) {
        this.m_aliasNamesMap = map;
        this.m_correlationNamesMap = map2;
        this.m_projectedColumns = new ArrayList<IColumn>(list);
        this.m_projectionMappings = list2;
    }

    @Override
    public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) throws ErrorException {
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NOT_IMPLEMENTED.name());
    }

    private void initResultSet() throws ErrorException {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        this.m_columnNameIndexMapping = new HashMap<String, Integer>();
        boolean bl = this.m_settings.m_enableCaseSensitive;
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        String string = null;
        int n = 0;
        IColumn iColumn = null;
        List<IColumn> list = null;
        boolean bl2 = true;
        list = null == this.m_projectedColumns ? this.m_columnMetadata : this.m_projectedColumns;
        for (int i = 0; i < list.size(); ++i) {
            iColumn = list.get(i);
            string = iColumn.getName();
            if (null != this.m_correlationNamesMap && !this.m_correlationNamesMap.isEmpty()) {
                string = this.m_correlationNamesMap.get(string);
            }
            object = this.m_columnNameMetadataMapping.get(string);
            if (this.m_isVirtual || ((CDBJDBCColumnMetadata)object).isUDT()) {
                string = ((CDBJDBCColumnMetadata)object).unwrap().getName();
            }
            if ((this.getDataNeeded(i) || this.m_openType == OpenTableType.READ_WRITE && (this.m_primaryKeyIndices.contains(i) || this.m_isVirtual)) && !this.m_columnNameIndexMapping.containsKey(string)) {
                if (this.m_isVirtual) {
                    ColumnMetadata columnMetadata = ((CDBJDBCColumnMetadata)object).unwrap();
                    if (!((CDBJDBCColumnMetadata)object).isPrimaryKey() || columnMetadata.getType().isCollection()) {
                        bl2 = false;
                    }
                }
                if (0 < stringBuilder2.length()) {
                    stringBuilder2.append(", ");
                }
                stringBuilder2.append(CDBJDBCUtils.cassNameGenerator(string, bl));
                this.m_columnNameIndexMapping.put(string, n);
                ++n;
            }
            if (0 < stringBuilder3.length()) {
                stringBuilder3.append(", ");
            }
            stringBuilder3.append("\"");
            stringBuilder3.append(string);
            stringBuilder3.append("\"");
        }
        stringBuilder.append("SELECT ");
        if (0 < this.m_columnNameIndexMapping.size() && this.m_columnMetadata.size() != this.m_columnNameIndexMapping.size()) {
            if (this.m_tableMetadata.isVirtualTable() && bl2) {
                String string2 = "Projecting the collection for " + this.m_tableName + " as only pk columns are in the select query on the virtual table.";
                LogUtilities.logDebug(string2, this.m_logger);
                object = ((CDBJDBCVirtualTableMetadata)this.m_tableMetadata).getCollectionName();
                stringBuilder2.append(", \"" + (String)object + "\"");
            }
            stringBuilder.append(stringBuilder2.toString());
        } else {
            stringBuilder.append(stringBuilder3.toString());
        }
        stringBuilder.append(" FROM ");
        stringBuilder.append(CDBJDBCUtils.cassNameGenerator(this.m_schemaName, bl));
        stringBuilder.append(".");
        stringBuilder.append(CDBJDBCUtils.cassNameGenerator(this.m_cassTableName, bl));
        if (null != this.m_filter) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(this.m_filter);
        }
        if (null != this.m_limit) {
            stringBuilder.append(" LIMIT ");
            stringBuilder.append(this.m_limit);
        }
        if (this.m_allowFilteringNeeded) {
            stringBuilder.append(" ALLOW FILTERING");
        }
        stringBuilder.append(";");
        this.m_query = stringBuilder.toString();
        LogUtilities.logDebug("Cassandra query = " + this.m_query, this.m_logger);
        ResultSetFuture resultSetFuture = CDBJDBCUtils.executeQuery(this.m_session, this.m_query, this.m_fetchSize);
        this.m_resultSet = this.m_tableMetadata.isVirtualTable() ? new CDBJDBCResultSet(this.m_logger, resultSetFuture, this.m_query, this.m_settings) : new CDBJDBCNativeResultSet(this.m_logger, resultSetFuture, this.m_query, this.m_settings);
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        return false;
    }
}

