/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.cassandra.dataengine.table;

import com.simba.cassandra.cassandra.core.CDBJDBCConnection;
import com.simba.cassandra.cassandra.core.CDBJDBCDriver;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.CDBJDBCColumnMetadata;
import com.simba.cassandra.cassandra.dataengine.metadata.schemamap.ICDBJDBCTableMetadata;
import com.simba.cassandra.cassandra.dataengine.table.CDBJDBCWriteTable;
import com.simba.cassandra.cassandra.dataengine.utils.CDBJDBCUtils;
import com.simba.cassandra.cassandra.exceptions.CDBJDBCMessageKey;
import com.simba.cassandra.cassandra.utils.CDBJDBCDataTypeUtilities;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.DataWrapper;
import com.simba.cassandra.dsi.exceptions.IncorrectTypeException;
import com.simba.cassandra.shaded.datastax.driver.core.AbstractGettableData;
import com.simba.cassandra.shaded.datastax.driver.core.BoundStatement;
import com.simba.cassandra.shaded.datastax.driver.core.CodecRegistry;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.PreparedStatement;
import com.simba.cassandra.shaded.datastax.driver.core.ResultSet;
import com.simba.cassandra.shaded.datastax.driver.core.SimpleStatement;
import com.simba.cassandra.shaded.datastax.driver.core.Statement;
import com.simba.cassandra.shaded.datastax.driver.core.TypeCodec;
import com.simba.cassandra.shaded.datastax.driver.core.UDTValue;
import com.simba.cassandra.shaded.datastax.driver.core.UserType;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Assignment;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.BuiltStatement;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Delete;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Insert;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.QueryBuilder;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Select;
import com.simba.cassandra.shaded.datastax.driver.core.querybuilder.Update;
import com.simba.cassandra.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.simba.cassandra.sqlengine.dsiext.dataengine.OpenTableType;
import com.simba.cassandra.support.ILogger;
import com.simba.cassandra.support.LogUtilities;
import com.simba.cassandra.support.Pair;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CDBJDBCWriteVirtualTable
extends CDBJDBCWriteTable {
    private static final int APPEND_TO_END = -1;
    private static final int PREPEND = 0;
    private Integer m_collectionBindIndex = null;
    private Set<Integer> m_virtualPrimaryKeyIndices = new HashSet<Integer>();
    private CachedListData m_cachedListData = new CachedListData();
    private CollectionInfo m_collectionInfo = null;
    private String m_collectionColumnName = null;
    private Set<Integer> m_collectionValueIndices = new HashSet<Integer>();
    protected List<Long> m_deleteIndexFromList = new Vector<Long>();
    private PreparedStatement m_preparedSelectStatement = null;
    private Set<Pair<PreparedStatement, UpdateType>> m_preparedStatements = null;
    private Object m_previousRowCachedCollectionData;
    private DataWrapper[] m_previousRowCollectionValues;
    private String m_previousRowPrimaryKeyHash = null;
    private ArrayList<String> m_primaryKeyColumnNames = new ArrayList();
    private Map<String, Row> m_rows;
    private DataWrapper[] m_upsertVirtualTableRowValues = null;
    private Set<Integer> m_upsertVirtualPkColumnIndices = null;
    private Set<Integer> m_upsertCollectionColIndices = null;

    public CDBJDBCWriteVirtualTable(CDBJDBCConnection cDBJDBCConnection, ICDBJDBCTableMetadata iCDBJDBCTableMetadata, String string, String string2, String string3, int n, String string4, OpenTableType openTableType, ILogger iLogger) throws ErrorException {
        super(cDBJDBCConnection, iCDBJDBCTableMetadata, string, string2, string3, n, string4, openTableType, iLogger);
    }

    @Override
    public void appendRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_upsertVirtualTableRowValues = new DataWrapper[this.m_columnMetadata.size()];
    }

    @Override
    public void deleteRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.getPrimaryKeys();
        String string = this.primaryKeyHashValue(this.m_upsertVirtualTableRowValues, this.m_DMLType, this.m_primaryKeyIndices);
        if (null != this.m_previousRowPrimaryKeyHash && !string.equals(this.m_previousRowPrimaryKeyHash)) {
            this.m_deleteIndexFromList = new Vector<Long>();
        }
        if (null == this.m_rows.get(string)) {
            this.m_rows.put(string, new Row());
        }
        this.deleteFromCollection(string);
        if (null == this.m_rows.get((Object)string).m_primaryKeys) {
            this.m_rows.get((Object)string).m_primaryKeys = (DataWrapper[])this.m_upsertVirtualTableRowValues.clone();
        }
        this.m_previousRowCachedCollectionData = DataType.Name.LIST == this.m_collectionInfo.m_type ? this.m_cachedListData : this.m_cachedCollectionData;
        this.m_previousRowPrimaryKeyHash = string;
        this.m_previousRowCollectionValues = this.m_upsertVirtualTableRowValues;
    }

    @Override
    public void onFinishDMLBatch() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (DSIExtJResultSet.DMLType.DELETE == this.m_DMLType) {
            LinkedHashSet<Statement> linkedHashSet = new LinkedHashSet<Statement>();
            Pair<PreparedStatement, UpdateType> pair = this.m_preparedStatements.iterator().next();
            for (Map.Entry<String, Row> entry : this.m_rows.entrySet()) {
                this.genearateBoundStatement(entry.getKey(), pair);
                linkedHashSet.add(entry.getValue().m_statement);
            }
            this.flushStatment(linkedHashSet, true);
        } else {
            this.genearateBoundStatements(this.m_collectionInfo.m_boundStatements);
            this.flushStatment(this.m_collectionInfo.m_boundStatements, true);
        }
    }

    @Override
    public void onFinishRowUpdate() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
            this.getPrimaryKeys();
        }
        String string = this.primaryKeyHashValue(this.m_upsertVirtualTableRowValues, this.m_DMLType, this.m_primaryKeyIndices);
        if (null != this.m_previousRowPrimaryKeyHash && !string.equals(this.m_previousRowPrimaryKeyHash)) {
            this.genearateBoundStatements(this.m_collectionInfo.m_boundStatements);
            this.flushStatment(this.m_collectionInfo.m_boundStatements, false);
            this.m_collectionInfo.m_boundStatements = new HashSet<Statement>();
            this.initializeCacheCollection();
            this.m_udtColumns = new HashMap();
        }
        this.insertIntoCollection();
        this.m_previousRowCachedCollectionData = DataType.Name.LIST == this.m_collectionInfo.m_type ? this.m_cachedListData : this.m_cachedCollectionData;
        this.m_previousRowPrimaryKeyHash = string;
        this.m_previousRowCollectionValues = this.m_upsertVirtualTableRowValues;
    }

    @Override
    public void onStartDMLBatch(DSIExtJResultSet.DMLType dMLType, long l) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        super.onStartDMLBatch(dMLType, l);
        if (DSIExtJResultSet.DMLType.DELETE != dMLType) {
            this.m_upsertVirtualPkColumnIndices = new HashSet<Integer>();
            this.m_upsertCollectionColIndices = new HashSet<Integer>();
        } else {
            this.m_rows = new HashMap<String, Row>();
        }
        this.m_upsertVirtualTableRowValues = new DataWrapper[this.m_columnMetadata.size()];
        this.m_udtColumns = new HashMap();
        if (null == this.m_collectionInfo) {
            this.initializeCollectionInfo(this.m_upsertVirtualTableRowValues.length);
        }
        this.buildQueryStatements();
    }

    @Override
    public void onStartRowUpdate() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_upsertVirtualTableRowValues = new DataWrapper[this.m_columnMetadata.size()];
        if (null == this.m_collectionInfo) {
            this.initializeCollectionInfo(this.m_upsertVirtualTableRowValues.length);
        }
    }

    private void bindCollectionToStatement(BoundStatement boundStatement, int n, Object object, UpdateType updateType) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != object) {
            if (DataType.Name.MAP == this.m_collectionInfo.m_type) {
                boundStatement.setMap(n, (Map)object);
            } else if (DataType.Name.LIST == this.m_collectionInfo.m_type) {
                Vector<?> vector = ((CachedListData)object).getCachedData(updateType);
                if (null != this.m_deleteIndexFromList && DSIExtJResultSet.DMLType.DELETE == this.m_DMLType) {
                    Collections.sort(this.m_deleteIndexFromList);
                    for (int i = this.m_deleteIndexFromList.size() - 1; i >= 0; --i) {
                        vector.remove(this.m_deleteIndexFromList.get(i).intValue());
                    }
                }
                try {
                    boundStatement.setList(n, (List)vector.subList(0, vector.size()));
                }
                catch (NullPointerException nullPointerException) {
                    throw this.generateErrorException("Cassandra cannot hold default or NULL values in collections", nullPointerException);
                }
            } else if (DataType.Name.SET == this.m_collectionInfo.m_type) {
                boundStatement.setSet(n, (Set)object);
            }
        }
    }

    private void bindCollectionToDeleteStatement(BoundStatement boundStatement, int n, Object object, UpdateType updateType) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != object) {
            if (DataType.Name.MAP == this.m_collectionInfo.m_type) {
                boundStatement.setMap(n, (Map)object);
            } else if (DataType.Name.LIST == this.m_collectionInfo.m_type) {
                Vector vector = (Vector)object;
                try {
                    boundStatement.setList(n, vector.subList(0, vector.size()));
                }
                catch (NullPointerException nullPointerException) {
                    throw this.generateErrorException("Cassandra cannot hold default or NULL values in collections", nullPointerException);
                }
            } else if (DataType.Name.SET == this.m_collectionInfo.m_type) {
                boundStatement.setSet(n, (Set)object);
            }
        }
    }

    private Statement buildNonBoundSelectStatement(DataWrapper[] dataWrapperArray) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DataWrapper dataWrapper = null;
        for (Integer n2 : this.m_primaryKeyIndices) {
            Object object;
            dataWrapper = dataWrapperArray[n2];
            CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n2);
            String string = cDBJDBCColumnMetadata.unwrap().getName();
            if (cDBJDBCColumnMetadata.isUDT()) {
                this.bindColumnDataToUDTValue(dataWrapper, cDBJDBCColumnMetadata);
                if (null == ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex) {
                    ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex = n;
                } else {
                    n = ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex;
                }
                object = ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_udtValue;
                if (n < arrayList.size()) {
                    arrayList.remove(n);
                }
                arrayList.add(n, object);
            } else if (null != dataWrapper) {
                object = this.m_preparedSelectStatement.getVariables().getType(n);
                Object object2 = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(dataWrapper, dataWrapper.getType(), (DataType)object);
                arrayList.add(n, object2);
            } else {
                arrayList.add(n, null);
            }
            ++n;
        }
        return new SimpleStatement(this.m_preparedSelectStatement.getQueryString(), arrayList.toArray());
    }

    private void bindPrimaryKeysToInsertStatement(BoundStatement boundStatement, DataWrapper[] dataWrapperArray, List<IColumn> list, DSIExtJResultSet.DMLType dMLType, Set<Integer> set, List<ByteBuffer[]> list2, PreparedStatement preparedStatement, PreparedStatement preparedStatement2, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        BoundStatement boundStatement2 = null;
        if (DSIExtJResultSet.DMLType.INSERT == dMLType) {
            boundStatement2 = preparedStatement2.bind();
        }
        int n = 0;
        for (Integer n2 : set) {
            Object object;
            DataWrapper dataWrapper = dataWrapperArray[n2];
            short s = list.get(n2).getTypeMetadata().getType();
            CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)list.get(n2);
            String string = cDBJDBCColumnMetadata.unwrap().getName();
            if (cDBJDBCColumnMetadata.isUDT()) {
                this.bindColumnDataToUDTValue(dataWrapper, cDBJDBCColumnMetadata);
                if (null == ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex) {
                    ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex = n;
                } else {
                    n = ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex;
                }
                object = ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_udtValue;
                boundStatement.setUDTValue(n, (UDTValue)object);
            } else if (null != dataWrapper) {
                object = preparedStatement.getVariables().getType(n);
                CDBJDBCDataTypeUtilities.bindSqlDataToCassValue(boundStatement, n, dataWrapper, s, (DataType)object, iLogger);
                if (DSIExtJResultSet.DMLType.INSERT == dMLType) {
                    CDBJDBCDataTypeUtilities.bindSqlDataToCassValue(boundStatement2, n, dataWrapper, s, (DataType)object, iLogger);
                }
            } else {
                boundStatement.setToNull(n);
                if (DSIExtJResultSet.DMLType.INSERT == dMLType) {
                    boundStatement2.setToNull(n);
                }
            }
            ++n;
        }
    }

    private void bindPrimaryKeysToUpdateStatement(BoundStatement boundStatement, DataWrapper[] dataWrapperArray, DataType.Name name, List<IColumn> list, Set<Integer> set, PreparedStatement preparedStatement, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        int n = 1;
        for (Integer n2 : set) {
            short s = list.get(n2).getTypeMetadata().getType();
            DataWrapper dataWrapper = dataWrapperArray[n2];
            CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)list.get(n2);
            String string = cDBJDBCColumnMetadata.unwrap().getName();
            if (cDBJDBCColumnMetadata.isUDT()) {
                this.bindColumnDataToUDTValue(dataWrapper, cDBJDBCColumnMetadata);
                if (null == ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex) {
                    ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex = n;
                } else {
                    n = ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex;
                }
                UDTValue uDTValue = ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_udtValue;
                boundStatement.setUDTValue(n, uDTValue);
            } else {
                DataType dataType = preparedStatement.getVariables().getType(n);
                CDBJDBCDataTypeUtilities.bindSqlDataToCassValue(boundStatement, n, dataWrapper, s, dataType, iLogger);
            }
            ++n;
        }
    }

    private Object[] convertPrimaryKeyDataToCassValues(DataWrapper[] dataWrapperArray, List<IColumn> list, Set<Integer> set, PreparedStatement preparedStatement, UpdateType updateType, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DataType dataType = null;
        DataWrapper dataWrapper = null;
        int n = 0;
        for (Integer n2 : set) {
            Object object;
            dataWrapper = dataWrapperArray[n2];
            CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n2);
            String string = cDBJDBCColumnMetadata.unwrap().getName();
            if (cDBJDBCColumnMetadata.isUDT()) {
                this.bindColumnDataToUDTValue(dataWrapper, cDBJDBCColumnMetadata);
                if (null == ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex) {
                    ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex = n;
                } else {
                    n = ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex;
                }
                object = ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_udtValue;
                if (n < arrayList.size()) {
                    arrayList.remove(n);
                }
                arrayList.add(n, object);
            } else {
                dataType = cDBJDBCColumnMetadata.unwrap().getType();
                object = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(dataWrapper, dataWrapper.getType(), dataType);
                arrayList.add(n, object);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    private String primaryKeyHashValue(DataWrapper[] dataWrapperArray, DSIExtJResultSet.DMLType dMLType, Set<Integer> set) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (DSIExtJResultSet.DMLType.INSERT == dMLType) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Integer n : set) {
                stringBuilder.append(dataWrapperArray[n].toString());
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < set.size(); ++i) {
            CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(i);
            String string = cDBJDBCColumnMetadata.unwrap().getName();
            if (this.m_columnNameIndexMapping.containsKey(string)) {
                n = (Integer)this.m_columnNameIndexMapping.get(string);
            }
            stringBuilder.append(this.m_currentRow.getBytesUnsafe(n).hashCode());
            ++n;
        }
        return Integer.toHexString(stringBuilder.toString().hashCode());
    }

    private void buildQueryStatements() throws ErrorException {
        Object object2;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = this.m_collectionInfo.m_cassColumnName;
        String string2 = this.m_cassTableName;
        DataType.Name name = this.m_collectionInfo.m_type;
        DSIExtJResultSet.DMLType dMLType = this.m_DMLType;
        Long l = this.m_collectionInfo.m_listIndex;
        String string3 = this.m_schemaName;
        List list = this.m_columnMetadata;
        Set set = this.m_primaryKeyIndices;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : set) {
            String string4 = ((CDBJDBCColumnMetadata)list.get((Integer)object2)).unwrap().getName();
            if (arrayList.contains(string4)) continue;
            arrayList.add(string4);
        }
        this.m_primaryKeyColumnNames = arrayList;
        Object object3 = null;
        for (IColumn iColumn : this.m_columnMetadata) {
            if (!((CDBJDBCColumnMetadata)iColumn).isCollection()) continue;
            object3 = ((CDBJDBCColumnMetadata)iColumn).unwrap().getName();
        }
        this.m_collectionColumnName = object3;
        object2 = null;
        this.m_preparedStatements = new HashSet<Pair<PreparedStatement, UpdateType>>();
        if (DSIExtJResultSet.DMLType.INSERT == dMLType && DataType.Name.LIST == name) {
            l = 0L;
            object2 = this.buildCollectionStatement(name, (String)object3, dMLType, string3, l, arrayList, string2);
            this.m_preparedStatements.add(new Pair<Object, UpdateType>(object2, UpdateType.PREPEND));
            l = -1L;
            object2 = this.buildCollectionStatement(name, (String)object3, dMLType, string3, l, arrayList, string2);
            this.m_preparedStatements.add(new Pair<Object, UpdateType>(object2, UpdateType.APPEND));
            object2 = this.buildInsertStetement(list, (String)object3, string3, arrayList, string2);
            this.m_preparedStatements.add(new Pair<Object, UpdateType>(object2, UpdateType.INSERT));
            this.m_preparedSelectStatement = this.buildSelectStatement(list, string, string3, arrayList, set, string2);
        } else if (this.canMapDMLToCollectionUpdateQuery(name, dMLType)) {
            object2 = this.buildCollectionStatement(name, (String)object3, dMLType, string3, l, arrayList, string2);
            this.m_preparedStatements.add(new Pair<Object, UpdateType>(object2, UpdateType.APPEND));
        } else {
            object2 = this.buildInsertStetement(list, (String)object3, string3, arrayList, string2);
            this.m_preparedStatements.add(new Pair<Object, UpdateType>(object2, UpdateType.INSERT));
            this.m_preparedSelectStatement = this.buildSelectStatement(list, string, string3, arrayList, set, string2);
        }
    }

    private PreparedStatement buildSelectStatement(List<IColumn> list, String string, String string2, ArrayList<String> arrayList, Set<Integer> set, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Select select = QueryBuilder.select(string).from(string2, string3);
        for (String string4 : arrayList) {
            select.where(QueryBuilder.eq(string4, QueryBuilder.bindMarker()));
        }
        String string5 = select.getQueryString();
        LogUtilities.logDebug("Update collection query " + (String)string5, this.m_logger);
        return CDBJDBCUtils.prepareQuery(this.m_session, string5);
    }

    private PreparedStatement buildCollectionDeleteStatement(DataType.Name name, String string, String string2, Long l, ArrayList<String> arrayList, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        BuiltStatement builtStatement = null;
        if (DataType.Name.SET == name || (DataType.Name.MAP == name || DataType.Name.LIST == name) && l.equals(null)) {
            builtStatement = QueryBuilder.update(string2, string3);
            Update.Assignments assignments = ((Update)builtStatement).with();
            assignments.and(QueryBuilder.decr(string, QueryBuilder.bindMarker()));
            Update.Where where = ((Update)builtStatement).where();
            for (String string4 : arrayList) {
                where.and(QueryBuilder.eq(string4, QueryBuilder.bindMarker()));
            }
        } else if (DataType.Name.MAP == name) {
            builtStatement = QueryBuilder.delete().mapElt(string, l).from(this.m_schemaName, this.m_cassTableName);
            Delete.Where where = ((Delete)builtStatement).where();
            for (String string5 : arrayList) {
                where.and(QueryBuilder.eq(string5, QueryBuilder.bindMarker()));
            }
        } else if (DataType.Name.LIST == name) {
            builtStatement = QueryBuilder.delete().listElt(string, l.intValue()).from(this.m_schemaName, this.m_cassTableName).where();
            Delete.Where where = ((Delete)builtStatement).where();
            for (String string6 : arrayList) {
                where.and(QueryBuilder.eq(string6, QueryBuilder.bindMarker()));
            }
        }
        if (null != builtStatement) {
            LogUtilities.logDebug("Delete collection query " + builtStatement.getQueryString(), this.m_logger);
            return CDBJDBCUtils.prepareQuery(this.m_session, builtStatement.getQueryString());
        }
        LogUtilities.logDebug("Delete collection query " + null, this.m_logger);
        return null;
    }

    private PreparedStatement buildCollectionInsertStatement(DataType.Name name, String string, String string2, Long l, ArrayList<String> arrayList, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == string) {
            return null;
        }
        Update update = QueryBuilder.update(string2, string3);
        Update.Assignments assignments = update.with();
        Assignment assignment = null;
        if (name == DataType.Name.SET || DataType.Name.MAP == name || DataType.Name.LIST == name && -1L == l) {
            assignment = QueryBuilder.incr(string, QueryBuilder.bindMarker());
        } else if (DataType.Name.LIST == name && 0L == l) {
            assignment = QueryBuilder.prependAll(string, QueryBuilder.bindMarker());
        } else if (DataType.Name.LIST == name) {
            assignment = QueryBuilder.put(string, QueryBuilder.bindMarker(), QueryBuilder.bindMarker());
        }
        assignments.and(assignment);
        Update.Where where = update.where();
        for (String string4 : arrayList) {
            where.and(QueryBuilder.eq(string4, QueryBuilder.bindMarker()));
        }
        LogUtilities.logDebug("Insert collection query " + update.getQueryString(), this.m_logger);
        return CDBJDBCUtils.prepareQuery(this.m_session, update.getQueryString());
    }

    /*
     * WARNING - void declaration
     */
    private Statement buildNonBoundStatementForEmptyInetValues(DataType.Name name, String string, String string2, UpdateType updateType, ArrayList<String> arrayList, String string3, PreparedStatement preparedStatement, boolean bl, Object object, DataWrapper[] dataWrapperArray) throws ErrorException {
        Object object3;
        Object object4;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Object[] objectArray = this.convertPrimaryKeyDataToCassValues(dataWrapperArray, this.m_columnMetadata, this.m_primaryKeyIndices, preparedStatement, updateType, this.m_logger);
        if (!bl) {
            int n;
            Object[] objectArray2 = new Object[objectArray.length + 1];
            if (UpdateType.INSERT != updateType) {
                n = 0;
                for (int i = 1; i < objectArray2.length; ++i) {
                    objectArray2[i] = objectArray[i - 1];
                }
            } else {
                int n2;
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    objectArray2[n2] = objectArray[n2];
                }
                n = n2;
            }
            if (DataType.Name.MAP == name) {
                Map map = (Map)object;
                objectArray2[n] = map;
            } else if (DataType.Name.LIST == name) {
                void object22;
                if (DSIExtJResultSet.DMLType.DELETE == this.m_DMLType) {
                    List vector = (List)object;
                } else {
                    Vector<?> set = ((CachedListData)object).getCachedData(updateType);
                }
                objectArray2[n] = object22;
            } else if (DataType.Name.SET == name) {
                Set set = (Set)object;
                objectArray2[n] = set;
            }
            return new SimpleStatement(preparedStatement.getQueryString(), objectArray2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (DataType.Name.MAP == name) {
            stringBuilder.append("{");
            object4 = null;
            object3 = null;
            Map map = (Map)object;
            object4 = this.m_collectionInfo.m_typeArgs.get(0).getName();
            object3 = this.m_collectionInfo.m_typeArgs.get(1).getName();
            for (Map.Entry entry : map.entrySet()) {
                Object object2;
                Object k = entry.getKey();
                String string4 = k.toString();
                if (DataType.Name.INET == object4 && !string4.isEmpty()) {
                    string4 = string4.substring(1, string4.length());
                }
                if (DataType.Name.BLOB == object4) {
                    object2 = ((ByteBuffer)k).array();
                    string4 = CDBJDBCDataTypeUtilities.byteArrayToCassString((byte[])object2);
                }
                if (DataType.Name.ASCII == object3 || DataType.Name.DATE == object3 || DataType.Name.INET == object3 || DataType.Name.TEXT == object3 || DataType.Name.TIME == object3 || DataType.Name.TIMESTAMP == object3 || DataType.Name.VARCHAR == object3) {
                    string4 = "'" + string4 + "'";
                }
                stringBuilder.append(string4);
                stringBuilder.append(": ");
                object2 = entry.getValue();
                String string5 = object2.toString();
                if (DataType.Name.INET == object3 && !string5.isEmpty()) {
                    string5 = string5.substring(1, string5.length());
                }
                if (DataType.Name.BLOB == object4) {
                    byte[] byArray = ((ByteBuffer)k).array();
                    string4 = CDBJDBCDataTypeUtilities.byteArrayToCassString(byArray);
                }
                if (DataType.Name.ASCII == object3 || DataType.Name.DATE == object3 || DataType.Name.INET == object3 || DataType.Name.TEXT == object3 || DataType.Name.TIME == object3 || DataType.Name.TIMESTAMP == object3 || DataType.Name.VARCHAR == object3) {
                    string5 = "'" + string5 + "'";
                }
                stringBuilder.append(string5);
                stringBuilder.append(",");
            }
            stringBuilder = new StringBuilder(stringBuilder.substring(0, stringBuilder.toString().length() - 1));
            stringBuilder.append("}");
        } else if (DataType.Name.LIST == name) {
            stringBuilder.append("[");
            object4 = DSIExtJResultSet.DMLType.DELETE == this.m_DMLType ? (List)object : ((CachedListData)object).getCachedData(updateType);
            object3 = object4.iterator();
            while (object3.hasNext()) {
                void var15_27;
                String string6 = object3.next().toString();
                if (!string6.isEmpty()) {
                    String string7 = string6.substring(1, string6.length());
                }
                stringBuilder.append("'");
                stringBuilder.append((String)var15_27);
                stringBuilder.append("'");
                if (!object3.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("]");
        } else if (DataType.Name.SET == name) {
            stringBuilder.append("{");
            object4 = (Set)object;
            object3 = object4.iterator();
            while (object3.hasNext()) {
                void var15_30;
                String string8 = object3.next().toString();
                if (!string8.isEmpty()) {
                    String string9 = string8.substring(1, string8.length());
                }
                stringBuilder.append("'");
                stringBuilder.append((String)var15_30);
                stringBuilder.append("'");
                if (!object3.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
        }
        object4 = new StringBuilder();
        if (UpdateType.INSERT != updateType) {
            ((StringBuilder)object4).append("UPDATE " + string2 + "." + string3 + " SET ");
            if (name == DataType.Name.SET || name == DataType.Name.MAP || name == DataType.Name.LIST && UpdateType.APPEND == updateType) {
                ((StringBuilder)object4).append(string);
                ((StringBuilder)object4).append(" = ");
                ((StringBuilder)object4).append(string);
                ((StringBuilder)object4).append(" + ");
                ((StringBuilder)object4).append((CharSequence)stringBuilder);
            }
            if (name == DataType.Name.LIST && UpdateType.PREPEND == updateType) {
                ((StringBuilder)object4).append(string);
                ((StringBuilder)object4).append(" = ");
                ((StringBuilder)object4).append((CharSequence)stringBuilder);
                ((StringBuilder)object4).append(" + ");
                ((StringBuilder)object4).append(string);
            }
            ((StringBuilder)object4).append(" WHERE ");
            for (int i = 0; i < objectArray.length; ++i) {
                ((StringBuilder)object4).append(arrayList.get(i));
                ((StringBuilder)object4).append(" = ? ");
                if (i == objectArray.length - 1) continue;
                ((StringBuilder)object4).append("AND ");
            }
            return new SimpleStatement(((StringBuilder)object4).toString(), objectArray);
        }
        ((StringBuilder)object4).append("INSERT INTO ");
        ((StringBuilder)object4).append(string2);
        ((StringBuilder)object4).append(".");
        ((StringBuilder)object4).append(string3);
        ((StringBuilder)object4).append(" (");
        for (String string10 : arrayList) {
            ((StringBuilder)object4).append(string10);
            ((StringBuilder)object4).append(",");
        }
        ((StringBuilder)object4).append(string);
        ((StringBuilder)object4).append(") ");
        ((StringBuilder)object4).append("VALUES (");
        for (int i = 0; i < objectArray.length; ++i) {
            ((StringBuilder)object4).append("?");
            ((StringBuilder)object4).append(", ");
        }
        ((StringBuilder)object4).append((CharSequence)stringBuilder);
        ((StringBuilder)object4).append(")");
        return new SimpleStatement(((StringBuilder)object4).toString(), objectArray);
    }

    private PreparedStatement buildCollectionStatement(DataType.Name name, String string, DSIExtJResultSet.DMLType dMLType, String string2, Long l, ArrayList<String> arrayList, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        PreparedStatement preparedStatement = null;
        if (DSIExtJResultSet.DMLType.DELETE == dMLType) {
            preparedStatement = this.buildCollectionDeleteStatement(name, string, string2, l, arrayList, string3);
        } else if (DSIExtJResultSet.DMLType.INSERT == dMLType) {
            preparedStatement = this.buildCollectionInsertStatement(name, string, string2, l, arrayList, string3);
        } else if (DSIExtJResultSet.DMLType.UPDATE == dMLType) {
            preparedStatement = this.buildCollectionUpdateStatement(name, string, string2, l, arrayList, string3);
        }
        if (null != preparedStatement) {
            LogUtilities.logDebug("Update collection query " + preparedStatement.getQueryString(), this.m_logger);
        } else {
            LogUtilities.logDebug("Update collection query " + null, this.m_logger);
        }
        return preparedStatement;
    }

    private PreparedStatement buildCollectionUpdateStatement(DataType.Name name, String string, String string2, Long l, ArrayList<String> arrayList, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Assignment assignment = QueryBuilder.put(string, QueryBuilder.bindMarker(), QueryBuilder.bindMarker());
        Update update = QueryBuilder.update(string2, string3);
        Update.Assignments assignments = update.with();
        assignments.and(assignment);
        Update.Where where = update.where();
        for (String string4 : arrayList) {
            where.and(QueryBuilder.eq(string4, QueryBuilder.bindMarker()));
        }
        LogUtilities.logDebug("Update collection query " + update.getQueryString(), this.m_logger);
        return CDBJDBCUtils.prepareQuery(this.m_session, update.getQueryString());
    }

    private PreparedStatement buildInsertStetement(List<IColumn> list, String string, String string2, ArrayList<String> arrayList, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Insert insert = QueryBuilder.insertInto(string2, string3);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string4 : arrayList) {
            hashSet.add(string4);
            insert.value(string4, QueryBuilder.bindMarker());
        }
        hashSet.add(string);
        insert.value(string, QueryBuilder.bindMarker());
        String string5 = insert.getQueryString();
        LogUtilities.logDebug("Update collection query " + (String)string5, this.m_logger);
        return CDBJDBCUtils.prepareQuery(this.m_session, string5);
    }

    private void cacheCollectionData() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_currentRow) {
            if (DataType.Name.MAP == this.m_collectionInfo.m_type) {
                TypeCodec typeCodec = new CodecRegistry().codecFor(this.m_collectionInfo.m_typeArgs.get(0));
                TypeCodec typeCodec2 = new CodecRegistry().codecFor(this.m_collectionInfo.m_typeArgs.get(1));
                Map map = this.m_currentRow.getMap(this.m_collectionInfo.m_virtualColIndex, typeCodec.getJavaType().getRawType(), typeCodec2.getJavaType().getRawType());
                this.cacheMapData(map);
            } else if (DataType.Name.LIST == this.m_collectionInfo.m_type) {
                TypeCodec typeCodec = new CodecRegistry().codecFor(this.m_collectionInfo.m_typeArgs.get(0));
                List list = this.m_currentRow.getList(this.m_collectionInfo.m_virtualColIndex, typeCodec.getJavaType().getRawType());
                this.cacheListOrSetData(list);
            } else if (DataType.Name.SET == this.m_collectionInfo.m_type) {
                TypeCodec typeCodec = new CodecRegistry().codecFor(this.m_collectionInfo.m_typeArgs.get(0));
                Set set = this.m_currentRow.getSet(this.m_collectionInfo.m_virtualColIndex, typeCodec.getJavaType().getRawType());
                this.cacheListOrSetData(set);
            }
        }
    }

    private void cacheListOrSetData(Collection<?> collection) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        AbstractCollection abstractCollection = null;
        abstractCollection = collection instanceof List ? new Vector() : new HashSet();
        for (Object object : collection) {
            if (DataType.Name.INET == this.m_collectionInfo.m_typeArgs.get(0).getName() && null == object) {
                object = "";
            }
            abstractCollection.add(object);
        }
        this.m_cachedCollectionData = abstractCollection;
        if (collection instanceof List) {
            this.m_cachedListData.addAll((Vector)this.m_cachedCollectionData);
        }
    }

    private void cacheMapData(Map<?, ?> map) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        HashMap hashMap = new HashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object object = entry.getKey();
            Object object2 = entry.getValue();
            if (DataType.Name.INET == this.m_collectionInfo.m_typeArgs.get(0).getName() && null == object) {
                object = "";
            }
            if (DataType.Name.INET == this.m_collectionInfo.m_typeArgs.get(1).getName() && null == object2) {
                object2 = "";
            }
            hashMap.put(object, object2);
        }
        this.m_cachedCollectionData = hashMap;
    }

    private boolean doNotGenerateBoundStatement(DataType.Name name, DSIExtJResultSet.DMLType dMLType, CachedListData cachedListData, UpdateType updateType) {
        if (DSIExtJResultSet.DMLType.INSERT == dMLType && DataType.Name.LIST == name) {
            if (cachedListData.isEmpty()) {
                return true;
            }
            if (UpdateType.APPEND == updateType && cachedListData.m_appendData.isEmpty()) {
                return true;
            }
            if (UpdateType.INSERT == updateType && cachedListData.m_cachedData.isEmpty()) {
                return true;
            }
            if (UpdateType.PREPEND == updateType && cachedListData.m_prependData.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private boolean canMapDMLToCollectionUpdateQuery(DataType.Name name, DSIExtJResultSet.DMLType dMLType) {
        return DSIExtJResultSet.DMLType.INSERT == this.m_DMLType && (DataType.Name.MAP == name || DataType.Name.SET == name);
    }

    private void deleteFromCollection(String string) throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        DataWrapper dataWrapper = null;
        for (int i = 0; i < this.m_primaryKeyIndices.size(); ++i) {
            dataWrapper = new DataWrapper();
            this.getData(i, 0L, -1L, dataWrapper);
            this.m_upsertVirtualTableRowValues[i] = dataWrapper;
        }
        DataWrapper dataWrapper2 = null;
        for (Integer object2 : this.m_virtualPrimaryKeyIndices) {
            dataWrapper2 = new DataWrapper();
            this.getData(object2, 0L, -1L, dataWrapper2);
            this.m_upsertVirtualTableRowValues[object2.intValue()] = dataWrapper2;
        }
        if (DataType.Name.MAP == this.m_collectionInfo.m_type) {
            if (null == this.m_rows.get((Object)string).m_collection) {
                this.cacheCollectionData();
                this.m_rows.get((Object)string).m_collection = (Map)this.m_cachedCollectionData;
            } else {
                this.m_cachedCollectionData = this.m_rows.get((Object)string).m_collection;
            }
            object = this.m_collectionInfo.m_typeArgs.get(0);
            int n = CDBJDBCDataTypeUtilities.toSQLType(((DataType)object).getName());
            Object l = null;
            if (DataType.Name.UDT == ((DataType)object).getName() && this.m_settings.m_flattenUDTColumn) {
                UserType n3 = (UserType)object;
                UDTValue dataWrapper4 = n3.newValue();
                for (Integer n4 : this.m_virtualPrimaryKeyIndices) {
                    CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n4);
                    DataWrapper dataWrapper5 = this.m_upsertVirtualTableRowValues[n4];
                    dataWrapper4 = this.bindColumnDataToCollectionUDT(dataWrapper4, dataWrapper5, cDBJDBCColumnMetadata);
                }
                l = dataWrapper4;
            } else {
                int incorrectTypeException = this.m_primaryKeyIndices.size();
                DataWrapper uDTValue = this.m_upsertVirtualTableRowValues[incorrectTypeException];
                l = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(uDTValue, n, (DataType)object);
            }
            ((Map)this.m_cachedCollectionData).remove(l);
        } else if (DataType.Name.LIST == this.m_collectionInfo.m_type) {
            Long object4;
            if (null == this.m_rows.get((Object)string).m_collection) {
                this.cacheCollectionData();
                this.m_rows.get((Object)string).m_collection = (List)this.m_cachedCollectionData;
            } else {
                this.m_cachedCollectionData = this.m_rows.get((Object)string).m_collection;
            }
            int n = this.m_primaryKeyIndices.size();
            DataWrapper n6 = this.m_upsertVirtualTableRowValues[n];
            try {
                object4 = n6.getInteger();
            }
            catch (IncorrectTypeException userType) {
                throw this.generateErrorException("Incorrect type for list index", userType);
            }
            this.m_deleteIndexFromList.add(object4);
            this.m_rows.get((Object)string).m_deletionIndices.add(object4);
        } else if (DataType.Name.SET == this.m_collectionInfo.m_type) {
            if (null == this.m_rows.get((Object)string).m_collection) {
                this.cacheCollectionData();
                this.m_rows.get((Object)string).m_collection = (Set)this.m_cachedCollectionData;
            } else {
                this.m_cachedCollectionData = this.m_rows.get((Object)string).m_collection;
            }
            object = this.m_collectionInfo.m_typeArgs.get(0);
            int n = CDBJDBCDataTypeUtilities.toSQLType(((DataType)object).getName());
            Object object2 = null;
            if (DataType.Name.UDT == ((DataType)object).getName()) {
                UserType n5 = (UserType)object;
                UDTValue dataWrapper6 = n5.newValue();
                for (Integer n2 : this.m_virtualPrimaryKeyIndices) {
                    CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n2);
                    DataWrapper dataWrapper3 = this.m_upsertVirtualTableRowValues[n2];
                    dataWrapper6 = this.bindColumnDataToCollectionUDT(dataWrapper6, dataWrapper3, cDBJDBCColumnMetadata);
                }
                object2 = dataWrapper6;
            } else {
                int n3 = this.m_primaryKeyIndices.size();
                DataWrapper dataWrapper4 = this.m_upsertVirtualTableRowValues[n3];
                object2 = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(dataWrapper4, n, (DataType)object);
            }
            ((Set)this.m_cachedCollectionData).remove(object2);
        }
    }

    private boolean doesTableContainsInetColumn() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        CDBJDBCColumnMetadata cDBJDBCColumnMetadata = null;
        for (int i = 0; i < this.m_columnMetadata.size(); ++i) {
            cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(i);
            if ((cDBJDBCColumnMetadata.isClusteringKey() || cDBJDBCColumnMetadata.isPartitionKey()) && DataType.Name.INET == cDBJDBCColumnMetadata.unwrap().getType().getName()) {
                return true;
            }
            if (!cDBJDBCColumnMetadata.isCollection()) continue;
            if (DataType.Name.INET == this.m_collectionInfo.m_typeArgs.get(0).getName()) {
                return true;
            }
            if (DataType.Name.MAP != this.m_collectionInfo.m_type || DataType.Name.INET != this.m_collectionInfo.m_typeArgs.get(1).getName()) continue;
            return true;
        }
        return false;
    }

    private void flushStatment(Set<Statement> set, boolean bl) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != set) {
            for (Statement statement : set) {
                if (this.m_settings.m_enableAsynchronousWrites) {
                    this.flushRowAsync(statement);
                    continue;
                }
                this.m_batch.add(statement);
                if (!bl && this.m_batch.size() < this.m_settings.m_batchLimit) continue;
                this.flushBatch();
            }
            if (!this.m_settings.m_enableAsynchronousWrites) {
                set.clear();
            }
        }
        if (this.m_settings.m_enableAsynchronousWrites && bl) {
            this.checkForAsyncCompletion();
        }
    }

    private void genearateBoundStatements(Set<Statement> set) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_previousRowCollectionValues) {
            return;
        }
        for (Pair<PreparedStatement, UpdateType> pair : this.m_preparedStatements) {
            int n;
            PreparedStatement preparedStatement = pair.key();
            UpdateType updateType = pair.value();
            if (this.doNotGenerateBoundStatement(this.m_collectionInfo.m_type, this.m_DMLType, this.m_cachedListData, updateType)) continue;
            if (this.doesTableContainsInetColumn()) {
                boolean bl = this.isInetValueInPrimaryKeysEmpty(this.m_previousRowCollectionValues, this.m_primaryKeyIndices, preparedStatement, updateType, this.m_logger);
                boolean bl2 = this.isInetValueInCollectionEmpty(this.m_previousRowCachedCollectionData, updateType);
                if (bl || bl2) {
                    Statement statement = this.buildNonBoundStatementForEmptyInetValues(this.m_collectionInfo.m_type, this.m_collectionColumnName, this.m_schemaName, updateType, this.m_primaryKeyColumnNames, this.m_cassTableName, preparedStatement, bl2, this.m_previousRowCachedCollectionData, this.m_previousRowCollectionValues);
                    set.add(statement);
                    continue;
                }
            }
            BoundStatement boundStatement = preparedStatement.bind();
            if (UpdateType.INSERT != updateType) {
                this.bindPrimaryKeysToUpdateStatement(boundStatement, this.m_previousRowCollectionValues, this.m_collectionInfo.m_type, this.m_columnMetadata, this.m_primaryKeyIndices, preparedStatement, this.m_logger);
                n = 0;
            } else {
                this.bindPrimaryKeysToInsertStatement(boundStatement, this.m_previousRowCollectionValues, this.m_columnMetadata, this.m_DMLType, this.m_primaryKeyIndices, this.m_primaryKeysValues, preparedStatement, this.m_preparedSelectStatement, this.m_logger);
                n = this.m_collectionBindIndex;
            }
            this.bindCollectionToStatement(boundStatement, n, this.m_previousRowCachedCollectionData, updateType);
            set.add(boundStatement);
        }
    }

    private void genearateBoundStatement(String string, Pair<PreparedStatement, UpdateType> pair) throws ErrorException {
        int n;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null == this.m_previousRowCollectionValues) {
            return;
        }
        PreparedStatement preparedStatement = pair.key();
        UpdateType updateType = pair.value();
        if (this.doNotGenerateBoundStatement(this.m_collectionInfo.m_type, this.m_DMLType, this.m_cachedListData, updateType)) {
            return;
        }
        if (this.doesTableContainsInetColumn()) {
            boolean bl = this.isInetValueInPrimaryKeysEmpty(this.m_previousRowCollectionValues, this.m_primaryKeyIndices, preparedStatement, updateType, this.m_logger);
            boolean bl2 = this.isInetValueInCollectionEmpty(this.m_rows.get((Object)string).m_collection, updateType);
            if (bl || bl2) {
                Statement statement;
                this.m_rows.get(string).removeKeys();
                this.m_rows.get((Object)string).m_statement = statement = this.buildNonBoundStatementForEmptyInetValues(this.m_collectionInfo.m_type, this.m_collectionColumnName, this.m_schemaName, updateType, this.m_primaryKeyColumnNames, this.m_cassTableName, preparedStatement, bl2, this.m_rows.get((Object)string).m_collection, this.m_rows.get((Object)string).m_primaryKeys);
                return;
            }
        }
        BoundStatement boundStatement = preparedStatement.bind();
        if (UpdateType.INSERT != updateType) {
            this.bindPrimaryKeysToUpdateStatement(boundStatement, this.m_rows.get((Object)string).m_primaryKeys, this.m_collectionInfo.m_type, this.m_columnMetadata, this.m_primaryKeyIndices, preparedStatement, this.m_logger);
            n = 0;
        } else {
            this.bindPrimaryKeysToInsertStatement(boundStatement, this.m_rows.get((Object)string).m_primaryKeys, this.m_columnMetadata, this.m_DMLType, this.m_primaryKeyIndices, this.m_primaryKeysValues, preparedStatement, this.m_preparedSelectStatement, this.m_logger);
            n = this.m_collectionBindIndex;
        }
        this.m_rows.get(string).removeKeys();
        this.bindCollectionToDeleteStatement(boundStatement, n, this.m_rows.get((Object)string).m_collection, updateType);
        this.m_rows.get((Object)string).m_statement = boundStatement;
    }

    private ErrorException generateErrorException(String string, Exception exception) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.QUERY_EXECUTION_FAIL_ERR.name(), new String[]{this.m_originalQuery, string});
        if (null != exception) {
            errorException.initCause(exception.getCause());
        }
        return errorException;
    }

    private DataWrapper[][] getUpdatedValues() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        DataWrapper[] dataWrapperArray = new DataWrapper[this.m_virtualPrimaryKeyIndices.size()];
        DataWrapper[] dataWrapperArray2 = new DataWrapper[this.m_collectionValueIndices.size()];
        int n = 0;
        int n2 = 0;
        for (Integer n3 : this.m_virtualPrimaryKeyIndices) {
            dataWrapperArray[n] = this.m_upsertVirtualPkColumnIndices.contains(n3) ? this.m_upsertVirtualTableRowValues[n3] : null;
            ++n;
        }
        for (Integer n3 : this.m_collectionValueIndices) {
            dataWrapperArray2[n2] = this.m_upsertCollectionColIndices.contains(n3) ? this.m_upsertVirtualTableRowValues[n3] : null;
            ++n2;
        }
        return new DataWrapper[][]{dataWrapperArray, dataWrapperArray2};
    }

    private boolean isInetValueInCollectionEmpty(Object object, UpdateType updateType) throws ErrorException {
        boolean bl;
        block5: {
            block7: {
                block6: {
                    LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
                    bl = false;
                    if (null == object) break block5;
                    if (DataType.Name.MAP != this.m_collectionInfo.m_type) break block6;
                    if (DataType.Name.INET != this.m_collectionInfo.m_typeArgs.get(0).getName() && DataType.Name.INET != this.m_collectionInfo.m_typeArgs.get(1).getName()) break block5;
                    Map map = (Map)object;
                    for (Map.Entry entry : map.entrySet()) {
                        String string = entry.getKey().toString();
                        String string2 = entry.getValue().toString();
                        if (DataType.Name.INET == this.m_collectionInfo.m_typeArgs.get(0).getName() && string.isEmpty()) {
                            bl = true;
                        }
                        if (DataType.Name.INET != this.m_collectionInfo.m_typeArgs.get(1).getName() || !string2.isEmpty()) continue;
                        bl = true;
                    }
                    break block5;
                }
                if (DataType.Name.LIST != this.m_collectionInfo.m_type) break block7;
                if (DataType.Name.INET != this.m_collectionInfo.m_typeArgs.get(0).getName()) break block5;
                Vector<?> vector = DSIExtJResultSet.DMLType.DELETE == this.m_DMLType ? (Vector<?>)object : ((CachedListData)object).getCachedData(updateType);
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next().toString();
                    if (!string.isEmpty()) continue;
                    bl = true;
                }
                break block5;
            }
            if (DataType.Name.SET == this.m_collectionInfo.m_type && DataType.Name.INET == this.m_collectionInfo.m_typeArgs.get(0).getName()) {
                Set set = (Set)object;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = iterator.next().toString();
                    if (!string.isEmpty()) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean isInetValueInPrimaryKeysEmpty(DataWrapper[] dataWrapperArray, Set<Integer> set, PreparedStatement preparedStatement, UpdateType updateType, ILogger iLogger) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        boolean bl = false;
        for (Integer n : set) {
            DataType dataType;
            CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n);
            if (cDBJDBCColumnMetadata.isUDT() || DataType.Name.INET != (dataType = cDBJDBCColumnMetadata.unwrap().getType()).getName()) continue;
            DataWrapper dataWrapper = dataWrapperArray[n];
            try {
                String string = dataWrapper.getVarChar();
                if (!string.isEmpty()) continue;
                bl = true;
            }
            catch (IncorrectTypeException incorrectTypeException) {
                ErrorException errorException = CDBJDBCDriver.s_DriverMessages.createGeneralException(CDBJDBCMessageKey.QUERY_EXECUTION_FAIL_ERR.name(), new String[]{this.m_originalQuery, "SQL data type mismatch."});
                errorException.initCause(incorrectTypeException.getCause());
                throw errorException;
            }
        }
        return bl;
    }

    private UDTValue bindColumnDataToCollectionUDT(UDTValue uDTValue, DataWrapper dataWrapper, CDBJDBCColumnMetadata cDBJDBCColumnMetadata) throws ErrorException {
        DataType dataType = null;
        int n = -1;
        dataType = cDBJDBCColumnMetadata.getUDTFieldType();
        n = cDBJDBCColumnMetadata.getUDTFieldIndex();
        short s = cDBJDBCColumnMetadata.getTypeMetadata().getType();
        CDBJDBCDataTypeUtilities.bindSqlDataToCassValue(uDTValue, n, dataWrapper, s, dataType, this.m_logger);
        return uDTValue;
    }

    private void initializeCacheCollection() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (DataType.Name.MAP == this.m_collectionInfo.m_type) {
            this.m_cachedCollectionData = new HashMap();
        } else if (DataType.Name.LIST == this.m_collectionInfo.m_type) {
            this.m_cachedCollectionData = new Vector();
            this.m_cachedListData = new CachedListData();
        } else {
            this.m_cachedCollectionData = new HashSet();
        }
    }

    private void initializeCollectionInfo(int n) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (0 < this.m_virtualPrimaryKeyIndices.size()) {
            int n2 = -1;
            Iterator<Integer> iterator = this.m_virtualPrimaryKeyIndices.iterator();
            if (iterator.hasNext()) {
                Integer n3 = iterator.next();
                n2 = n3;
            }
            iterator = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n2);
            int n4 = DSIExtJResultSet.DMLType.INSERT == this.m_DMLType ? 0 : (Integer)this.m_columnNameIndexMapping.get(((CDBJDBCColumnMetadata)((Object)iterator)).unwrap().getName());
            DataType.Name name = ((CDBJDBCColumnMetadata)((Object)iterator)).getCollectionType().getName();
            List<DataType> list = ((CDBJDBCColumnMetadata)((Object)iterator)).unwrap().getType().getTypeArguments();
            String string = ((CDBJDBCColumnMetadata)((Object)iterator)).unwrap().getName();
            this.m_collectionInfo = new CollectionInfo(n4, name, list, n, string);
            this.initializeCacheCollection();
        } else {
            this.generateErrorException("Unknown cause", null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void insertIntoCollection() throws ErrorException {
        int n;
        int n2;
        Object object;
        Object object2;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        DataWrapper[][] dataWrapperArray = this.getUpdatedValues();
        DataWrapper[] dataWrapperArray2 = dataWrapperArray[0];
        DataWrapper[] dataWrapperArray3 = dataWrapperArray[1];
        DataWrapper[] dataWrapperArray4 = new DataWrapper[this.m_virtualPrimaryKeyIndices.size()];
        if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
            object2 = new DataWrapper();
            for (int i = 0; i < this.m_primaryKeyIndices.size(); ++i) {
                this.getData(i, 0L, -1L, (DataWrapper)object2);
                this.m_upsertVirtualTableRowValues[i] = object2;
                object2 = new DataWrapper();
            }
            object = new DataWrapper();
            for (Integer n3 : this.m_virtualPrimaryKeyIndices) {
                this.getData(n3, 0L, -1L, (DataWrapper)object);
                this.m_upsertVirtualTableRowValues[n3.intValue()] = object;
                object = new DataWrapper();
            }
            n2 = this.m_primaryKeyIndices.size();
            for (n = 0; n < dataWrapperArray2.length; ++n) {
                dataWrapperArray4[n] = this.m_upsertVirtualTableRowValues[n2];
                if (null == dataWrapperArray2[n]) {
                    dataWrapperArray2[n] = dataWrapperArray4[n];
                }
                ++n2;
            }
        }
        if (DataType.Name.MAP == this.m_collectionInfo.m_type) {
            Object object4;
            Object object5;
            object2 = this.m_collectionInfo.m_typeArgs.get(0);
            object = this.m_collectionInfo.m_typeArgs.get(1);
            n2 = CDBJDBCDataTypeUtilities.toSQLType(((DataType)object2).getName());
            n = CDBJDBCDataTypeUtilities.toSQLType(((DataType)object).getName());
            if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType && ((Map)this.m_cachedCollectionData).isEmpty()) {
                this.retrieveCollectionFromDataSource(this.m_upsertVirtualTableRowValues);
            }
            Map map = (Map)this.m_cachedCollectionData;
            if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
                Object object3;
                object5 = null;
                if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == ((DataType)object2).getName()) {
                    void n4;
                    object4 = (UserType)object2;
                    UDTValue uDTValue = ((UserType)object4).newValue();
                    for (Integer n3 : this.m_virtualPrimaryKeyIndices) {
                        CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n3);
                        object3 = this.m_upsertVirtualTableRowValues[n3];
                        UDTValue userType = this.bindColumnDataToCollectionUDT((UDTValue)n4, (DataWrapper)object3, cDBJDBCColumnMetadata);
                    }
                    object5 = n4;
                } else {
                    object5 = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(dataWrapperArray4[0], n2, (DataType)object2);
                }
                if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == ((DataType)object).getName()) {
                    object4 = null;
                    int userType = this.m_primaryKeyIndices.size() + this.m_virtualPrimaryKeyIndices.size();
                    for (int n13 = 0; n13 < dataWrapperArray3.length; ++n13) {
                        void i;
                        if (null == dataWrapperArray3[n13]) {
                            if (null == object4) {
                                object4 = (UDTValue)map.get(object5);
                            }
                            Object object6 = ((AbstractGettableData)object4).getObject(n13);
                            short s = ((CDBJDBCColumnMetadata)this.m_columnMetadata.get((int)i)).getTypeMetadata().getType();
                            object3 = ((CDBJDBCColumnMetadata)this.m_columnMetadata.get((int)i)).getUDTFieldType().getName();
                            dataWrapperArray3[n13] = new DataWrapper();
                            CDBJDBCDataTypeUtilities.convertCassSubValueToSqlData(dataWrapperArray3[n13], 0L, -1L, s, (DataType.Name)((Object)object3), object6);
                        }
                        ++i;
                    }
                } else if (null == dataWrapperArray3[0]) {
                    object4 = map.get(object5);
                    dataWrapperArray3[0] = new DataWrapper();
                    CDBJDBCDataTypeUtilities.convertCassSubValueToSqlData(dataWrapperArray3[0], 0L, -1L, (short)n, ((DataType)object).getName(), object4);
                }
                if (null != object5) {
                    map.remove(object5);
                }
            }
            object5 = null;
            object4 = null;
            if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == ((DataType)object2).getName()) {
                UserType dataWrapper = (UserType)object2;
                UDTValue uDTValue = dataWrapper.newValue();
                int n4 = 0;
                for (Integer n5 : this.m_virtualPrimaryKeyIndices) {
                    CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n5);
                    DataWrapper dataWrapper2 = dataWrapperArray2[n4];
                    uDTValue = this.bindColumnDataToCollectionUDT(uDTValue, dataWrapper2, cDBJDBCColumnMetadata);
                    ++n4;
                }
                object5 = uDTValue;
            } else if (dataWrapperArray2[0] != null) {
                object5 = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(dataWrapperArray2[0], n2, (DataType)object2);
            }
            if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == ((DataType)object).getName()) {
                UserType object10 = (UserType)object;
                UDTValue uDTValue = object10.newValue();
                int n6 = this.m_primaryKeyIndices.size() + this.m_virtualPrimaryKeyIndices.size();
                for (int i = 0; i < dataWrapperArray3.length; ++i) {
                    DataWrapper dataWrapper = dataWrapperArray3[i];
                    CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n6);
                    uDTValue = this.bindColumnDataToCollectionUDT(uDTValue, dataWrapper, cDBJDBCColumnMetadata);
                    ++n6;
                }
                object4 = uDTValue;
            } else if (dataWrapperArray3[0] != null) {
                object4 = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(dataWrapperArray3[0], n, (DataType)object);
            }
            if (null != object5 && null != object4) {
                map.put(object5, object4);
            }
        } else if (DataType.Name.LIST == this.m_collectionInfo.m_type) {
            Object object7;
            Object object8;
            object2 = this.m_collectionInfo.m_typeArgs.get(0);
            int n8 = CDBJDBCDataTypeUtilities.toSQLType(((DataType)object2).getName());
            try {
                n2 = dataWrapperArray2[0].getInteger().intValue();
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw this.generateErrorException("Incorrect type for list index", incorrectTypeException);
            }
            if (((Vector)this.m_cachedCollectionData).isEmpty() && this.m_cachedListData.isEmpty() && -1 != n2 && 0 != n2 || ((Vector)this.m_cachedCollectionData).isEmpty() && this.m_cachedListData.isEmpty() && DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
                this.retrieveCollectionFromDataSource(this.m_upsertVirtualTableRowValues);
            }
            Vector vector = (Vector)this.m_cachedCollectionData;
            if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
                if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == ((DataType)object2).getName()) {
                    void var12_42;
                    object8 = null;
                    int n9 = this.m_primaryKeyIndices.size() + this.m_virtualPrimaryKeyIndices.size();
                    boolean bl = false;
                    while (var12_42 < dataWrapperArray3.length) {
                        if (null == dataWrapperArray3[var12_42]) {
                            try {
                                if (null == object8) {
                                    object8 = (UDTValue)vector.get(dataWrapperArray4[0].getInteger().intValue());
                                }
                                object7 = ((AbstractGettableData)object8).getObject((int)var12_42);
                                short s = ((CDBJDBCColumnMetadata)this.m_columnMetadata.get(n9)).getTypeMetadata().getType();
                                DataType.Name name = ((CDBJDBCColumnMetadata)this.m_columnMetadata.get(n9)).getUDTFieldType().getName();
                                dataWrapperArray3[var12_42] = new DataWrapper();
                                CDBJDBCDataTypeUtilities.convertCassSubValueToSqlData(dataWrapperArray3[var12_42], 0L, -1L, s, name, object7);
                            }
                            catch (IncorrectTypeException incorrectTypeException) {
                                throw this.generateErrorException("Incorrect type for list value", incorrectTypeException);
                            }
                        }
                        ++n9;
                        ++var12_42;
                    }
                } else if (null == dataWrapperArray3[0]) {
                    try {
                        object8 = vector.get(dataWrapperArray4[0].getInteger().intValue());
                        dataWrapperArray3[0] = new DataWrapper();
                        CDBJDBCDataTypeUtilities.convertCassSubValueToSqlData(dataWrapperArray3[0], 0L, -1L, (short)n8, ((DataType)object2).getName(), object8);
                    }
                    catch (IncorrectTypeException incorrectTypeException) {
                        throw this.generateErrorException("Incorrect type for list value", incorrectTypeException);
                    }
                }
            }
            object8 = null;
            if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == ((DataType)object2).getName()) {
                UserType userType = (UserType)object2;
                UDTValue uDTValue = userType.newValue();
                int n7 = this.m_primaryKeyIndices.size() + this.m_virtualPrimaryKeyIndices.size();
                for (int i = 0; i < dataWrapperArray3.length; ++i) {
                    void var14_64;
                    DataWrapper dataWrapper = dataWrapperArray3[i];
                    object7 = (CDBJDBCColumnMetadata)this.m_columnMetadata.get((int)var14_64);
                    uDTValue = this.bindColumnDataToCollectionUDT(uDTValue, dataWrapper, (CDBJDBCColumnMetadata)object7);
                    ++var14_64;
                }
                object8 = uDTValue;
            } else if (null != dataWrapperArray3[0]) {
                object8 = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(dataWrapperArray3[0], n8, (DataType)object2);
            }
            if (null != object8) {
                try {
                    if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
                        this.m_cachedListData.set(n2, object8);
                    }
                    this.m_cachedListData.add(object8, n2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw this.generateErrorException("Incorrect list index", arrayIndexOutOfBoundsException);
                }
            }
        } else if (DataType.Name.SET == this.m_collectionInfo.m_type) {
            UDTValue uDTValue;
            object2 = this.m_collectionInfo.m_typeArgs.get(0);
            int n11 = CDBJDBCDataTypeUtilities.toSQLType(((DataType)object2).getName());
            Set set = (Set)this.m_cachedCollectionData;
            if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType) {
                Object object9 = null;
                if (((Set)this.m_cachedCollectionData).isEmpty()) {
                    this.retrieveCollectionFromDataSource(this.m_upsertVirtualTableRowValues);
                    set = (Set)this.m_cachedCollectionData;
                }
                if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == ((DataType)object2).getName()) {
                    UserType userType = (UserType)object2;
                    uDTValue = userType.newValue();
                    for (Integer n8 : this.m_virtualPrimaryKeyIndices) {
                        CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n8);
                        DataWrapper dataWrapper = this.m_upsertVirtualTableRowValues[n8];
                        uDTValue = this.bindColumnDataToCollectionUDT(uDTValue, dataWrapper, cDBJDBCColumnMetadata);
                    }
                    object9 = uDTValue;
                } else {
                    int n12 = this.m_primaryKeyIndices.size();
                    object9 = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(this.m_upsertVirtualTableRowValues[n12], n11, (DataType)object2);
                }
                if (null != object9) {
                    set.remove(object9);
                }
            }
            Object object11 = null;
            if (this.m_settings.m_flattenUDTColumn && DataType.Name.UDT == ((DataType)object2).getName()) {
                UserType userType = (UserType)object2;
                uDTValue = userType.newValue();
                int n9 = 0;
                for (Integer n10 : this.m_virtualPrimaryKeyIndices) {
                    CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n10);
                    DataWrapper dataWrapper = dataWrapperArray2[n9];
                    uDTValue = this.bindColumnDataToCollectionUDT(uDTValue, dataWrapper, cDBJDBCColumnMetadata);
                    ++n9;
                }
                object11 = uDTValue;
            } else if (null != dataWrapperArray2[0]) {
                object11 = CDBJDBCDataTypeUtilities.convertSqlDataToCassValue(dataWrapperArray2[0], n11, (DataType)object2);
            }
            if (null != object11) {
                set.add(object11);
            }
        }
    }

    private void retrieveCollectionFromDataSource(DataWrapper[] dataWrapperArray) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Statement statement = null;
        BoundStatement boundStatement = this.m_preparedSelectStatement.bind();
        DataWrapper dataWrapper = null;
        int n = 0;
        for (Integer n2 : this.m_primaryKeyIndices) {
            Object object;
            dataWrapper = dataWrapperArray[n2];
            CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n2);
            String string = cDBJDBCColumnMetadata.unwrap().getName();
            if (cDBJDBCColumnMetadata.isUDT()) {
                this.bindColumnDataToUDTValue(dataWrapper, cDBJDBCColumnMetadata);
                if (null == ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex) {
                    ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex = n;
                } else {
                    n = ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_bindIndex;
                }
                object = ((CDBJDBCWriteTable.UDTColumn)this.m_udtColumns.get((Object)string)).m_udtValue;
                boundStatement.setUDTValue(n, (UDTValue)object);
            } else if (null != dataWrapper) {
                object = this.m_preparedSelectStatement.getVariables().getType(n);
                short s = ((IColumn)this.m_columnMetadata.get(n2)).getTypeMetadata().getType();
                if (DataType.Name.INET == ((DataType)object).getName()) {
                    String string2 = null;
                    try {
                        string2 = dataWrapper.getVarChar();
                        if (string2.isEmpty()) {
                            statement = this.buildNonBoundSelectStatement(dataWrapperArray);
                            break;
                        }
                    }
                    catch (IncorrectTypeException incorrectTypeException) {
                        // empty catch block
                    }
                }
                CDBJDBCDataTypeUtilities.bindSqlDataToCassValue(boundStatement, n, dataWrapper, s, (DataType)object, this.m_logger);
            } else {
                boundStatement.setToNull(n);
            }
            ++n;
        }
        if (DSIExtJResultSet.DMLType.INSERT == this.m_DMLType) {
            if (null != statement) {
                this.retrieveExistingCollectionContent(statement);
            } else {
                this.retrieveExistingCollectionContent(boundStatement);
            }
        }
        this.cacheCollectionData();
    }

    private void retrieveExistingCollectionContent(Statement statement) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ResultSet resultSet = this.m_session.execute(statement);
        if (!resultSet.isExhausted()) {
            this.m_currentRow = resultSet.one();
        }
    }

    @Override
    protected void initializeKeyIndexes() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        CDBJDBCColumnMetadata cDBJDBCColumnMetadata = null;
        for (int i = 0; i < this.m_columnMetadata.size(); ++i) {
            cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(i);
            if (cDBJDBCColumnMetadata.isClusteringKey() || cDBJDBCColumnMetadata.isPartitionKey()) {
                this.m_primaryKeyIndices.add(i);
                continue;
            }
            if (cDBJDBCColumnMetadata.isVirtualPrimaryKey()) {
                this.m_virtualPrimaryKeyIndices.add(i);
                this.m_collectionBindIndex = (Integer)this.m_columnNameIndexMapping.get(cDBJDBCColumnMetadata.unwrap().getName());
                continue;
            }
            this.m_collectionValueIndices.add(i);
        }
    }

    @Override
    protected void manageCurrentData(int n, DataWrapper dataWrapper, boolean bl) {
        CDBJDBCColumnMetadata cDBJDBCColumnMetadata = (CDBJDBCColumnMetadata)this.m_columnMetadata.get(n);
        this.m_upsertVirtualTableRowValues[n] = dataWrapper;
        if (cDBJDBCColumnMetadata.isCollection()) {
            if (cDBJDBCColumnMetadata.isVirtualPrimaryKey()) {
                this.m_upsertVirtualPkColumnIndices.add(n);
            } else {
                this.m_upsertCollectionColIndices.add(n);
            }
        } else {
            this.m_primaryKeyIndices.add(n);
        }
    }

    @Override
    protected String validateData(CDBJDBCColumnMetadata cDBJDBCColumnMetadata, DataWrapper dataWrapper, boolean bl) {
        String string = super.validateData(cDBJDBCColumnMetadata, dataWrapper, bl);
        if (null == string) {
            if ((bl || dataWrapper.isNull()) && cDBJDBCColumnMetadata.isCollection()) {
                string = "Cassandra cannot hold default or NULL values in collections";
            } else if (DSIExtJResultSet.DMLType.UPDATE == this.m_DMLType && cDBJDBCColumnMetadata.isVirtualPrimaryKey() && DataType.Name.LIST == cDBJDBCColumnMetadata.getCollectionType().getName()) {
                string = "List indexes modification is not allowed";
            }
        }
        return string;
    }

    public static enum UpdateType {
        APPEND,
        PREPEND,
        INSERT;

    }

    private class Row {
        public Object m_collection = null;
        public List<Long> m_deletionIndices = new ArrayList<Long>();
        public DataWrapper[] m_primaryKeys = null;
        public Statement m_statement = null;

        private Row() {
        }

        public void removeKeys() {
            if (this.m_collection instanceof List) {
                Collections.sort(this.m_deletionIndices);
                Collections.reverse(this.m_deletionIndices);
                for (Long l : this.m_deletionIndices) {
                    ((Vector)this.m_collection).remove(l.intValue());
                }
            }
        }
    }

    private class CollectionInfo {
        public int m_virtualColIndex;
        public DataType.Name m_type;
        public List<DataType> m_typeArgs;
        public Set<Statement> m_boundStatements = new HashSet<Statement>();
        public String m_cassColumnName;
        public Long m_listIndex = null;

        public CollectionInfo(int n, DataType.Name name, List<DataType> list, int n2, String string) {
            this.m_virtualColIndex = n;
            this.m_type = name;
            this.m_typeArgs = list;
            this.m_cassColumnName = string;
        }
    }

    private class CachedListData {
        public Vector m_appendData = new Vector();
        public Vector m_cachedData = new Vector();
        public Vector m_prependData = new Vector();

        private CachedListData() {
        }

        public void add(Object object, int n) throws ErrorException {
            if (0 == n) {
                if (this.m_cachedData.isEmpty()) {
                    this.m_prependData.add(0, object);
                } else {
                    this.m_cachedData.add(0, object);
                }
            } else if (-1 == n) {
                if (this.m_cachedData.isEmpty()) {
                    this.m_appendData.add(object);
                } else {
                    this.m_cachedData.add(object);
                }
            } else {
                if (!this.m_prependData.isEmpty()) {
                    this.m_cachedData.addAll(0, this.m_prependData);
                    this.m_prependData.clear();
                }
                if (!this.m_appendData.isEmpty()) {
                    this.m_cachedData.addAll(this.m_appendData);
                    this.m_appendData.clear();
                }
                this.m_cachedData.add(n, object);
            }
        }

        public Vector<?> getCachedData(UpdateType updateType) {
            if (UpdateType.APPEND == updateType) {
                return this.m_appendData;
            }
            if (UpdateType.PREPEND == updateType) {
                return this.m_prependData;
            }
            return this.m_cachedData;
        }

        public boolean isEmpty() {
            return this.m_appendData.isEmpty() && this.m_cachedData.isEmpty() && this.m_prependData.isEmpty();
        }

        public void set(int n, Object object) throws ErrorException {
            if (!this.m_prependData.isEmpty()) {
                this.m_cachedData.addAll(0, this.m_prependData);
                this.m_prependData.clear();
            }
            if (!this.m_appendData.isEmpty()) {
                this.m_cachedData.addAll(this.m_appendData);
                this.m_appendData.clear();
            }
            this.m_cachedData.set(n, object);
        }

        public void addAll(Vector vector) {
            if (null != vector) {
                this.m_cachedData = new Vector();
                this.m_cachedData.addAll(vector);
            }
        }
    }
}

