/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.dsi.dataengine.impl;

import com.simba.cassandra.dsi.dataengine.impl.DSIArray;
import com.simba.cassandra.dsi.dataengine.interfaces.IArray;
import com.simba.cassandra.dsi.dataengine.interfaces.IColumn;
import com.simba.cassandra.dsi.dataengine.utilities.ColumnMetadata;
import com.simba.cassandra.dsi.dataengine.utilities.TypeMetadata;
import com.simba.cassandra.dsi.dataengine.utilities.TypeUtilities;
import com.simba.cassandra.support.exceptions.ErrorException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DSISimpleArray
extends DSIArray {
    protected Object m_array;
    protected int m_length;
    private IColumn m_arrayMetadata;
    private IColumn m_nestedMetadata;

    @Deprecated
    public DSISimpleArray(Object object, IColumn iColumn, IColumn iColumn2) {
        this(object, DSISimpleArray.createNestedMetadata(iColumn, iColumn2));
    }

    public DSISimpleArray(Object object, IColumn iColumn) throws ClassCastException {
        this.CreateSimpleArray(object, iColumn);
    }

    protected void CreateSimpleArray(Object object, IColumn iColumn) {
        if (!object.getClass().isArray()) {
            throw new ClassCastException("Not an array: " + object.getClass());
        }
        short s = iColumn.getTypeMetadata().getType();
        if (s != 2003) {
            throw new ClassCastException("ArrayMetadata mismatch expected 2003 received " + s);
        }
        this.m_arrayMetadata = iColumn;
        this.m_array = object;
        this.m_length = Array.getLength(object);
        this.m_nestedMetadata = iColumn.getTypeMetadata().getNestedColumnList().get(0);
        int n = 0;
        TypeMetadata typeMetadata = this.m_nestedMetadata.getTypeMetadata();
        short s2 = typeMetadata.getType();
        while (s2 == 2003) {
            ++n;
            this.m_nestedMetadata = typeMetadata.getNestedColumnList().get(0);
            typeMetadata = this.m_nestedMetadata.getTypeMetadata();
            s2 = typeMetadata.getType();
        }
        boolean bl = this.verifyArray(object, n, s2);
        if (!bl) {
            throw new ClassCastException("Array is not valid");
        }
    }

    protected boolean verifyArray(Object object, int n, int n2) {
        if (object == null) {
            return true;
        }
        int n3 = Array.getLength(object);
        boolean bl = true;
        if (n > 0) {
            for (int i = 0; i < n3 && (bl = this.verifyArray(Array.get(object, i), n - 1, n2)); ++i) {
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                Object object2 = Array.get(object, i);
                if (object2 != null) {
                    bl = TypeUtilities.verifySQLTypeMapping(n2, object2.getClass());
                }
                if (bl) {
                    continue;
                }
                break;
            }
        }
        return bl;
    }

    @Override
    public Object createArray(long l, int n) throws ErrorException {
        if (0L > l) {
            throw new IndexOutOfBoundsException(String.valueOf(l));
        }
        int n2 = this.m_length;
        if (l >= (long)n2) {
            if (this.isMultidimensional()) {
                return new DSISimpleArray[0];
            }
            return Array.newInstance(this.m_array.getClass().getComponentType(), 0);
        }
        int n3 = (int)l;
        int n4 = n2 - n3;
        if (-1L != (long)n && n < n4) {
            n4 = n;
        }
        Object object = this.m_array;
        if (this.isMultidimensional()) {
            DSISimpleArray[] dSISimpleArrayArray = new DSISimpleArray[n4];
            IColumn iColumn = this.getArrayColumn().getTypeMetadata().getNestedColumnList().get(0);
            for (int i = 0; i < n4; ++i) {
                Object object2 = Array.get(object, n3 + i);
                dSISimpleArrayArray[i] = new DSISimpleArray(object2, iColumn);
            }
            return dSISimpleArrayArray;
        }
        Class<?> clazz = object.getClass().getComponentType();
        Object object3 = Array.newInstance(clazz, n4);
        System.arraycopy(object, n3, object3, 0, n4);
        return object3;
    }

    @Override
    public IColumn getBaseColumn() {
        return this.getArrayColumn().getTypeMetadata().getNestedColumnList().get(0);
    }

    @Override
    protected Iterator<?> createIterator(long l, int n) {
        int n2 = this.m_length;
        if (l >= (long)n2) {
            return Collections.emptyList().iterator();
        }
        int n3 = (int)l;
        int n4 = n2 - n3;
        if (-1L != (long)n && n < n4) {
            n4 = n;
        }
        return new DSISimpleArrayIterator(this.m_array, n3, n4);
    }

    protected IColumn getArrayColumn() {
        return this.m_arrayMetadata;
    }

    protected IColumn getNestedColumn() {
        return this.m_nestedMetadata;
    }

    protected boolean isMultidimensional() {
        short s = this.m_arrayMetadata.getTypeMetadata().getNestedColumnList().get(0).getTypeMetadata().getType();
        return s == 2003;
    }

    @Override
    public String getStringRepresentation() {
        if (!this.isMultidimensional()) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = ", ";
            for (int i = 0; i < this.m_length; ++i) {
                Object object = Array.get(this.m_array, i);
                if (object != null) {
                    stringBuilder.append(object.toString());
                } else {
                    stringBuilder.append("null");
                }
                if (i == this.m_length - 1) {
                    string = "";
                }
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }
        return this.toString();
    }

    private static IColumn createNestedMetadata(IColumn iColumn, IColumn iColumn2) {
        ColumnMetadata columnMetadata = ColumnMetadata.copyOf(iColumn);
        ArrayList<IColumn> arrayList = new ArrayList<IColumn>(1);
        arrayList.add(iColumn2);
        columnMetadata.getTypeMetadata().setNestedColumnList(arrayList);
        return columnMetadata;
    }

    protected final class DSISimpleArrayIterator
    implements Iterator<Object> {
        private int m_offset;
        private int m_count;
        private Object m_data;
        private boolean m_isNested;

        public DSISimpleArrayIterator(Object object, int n, int n2) {
            this.m_data = object;
            this.m_offset = n;
            this.m_count = n2;
            this.m_isNested = DSISimpleArray.this.isMultidimensional();
        }

        @Override
        public boolean hasNext() {
            return 0 < this.m_count;
        }

        @Override
        public Object next() {
            if (0 >= this.m_count) {
                throw new NoSuchElementException();
            }
            --this.m_count;
            Object object = Array.get(this.m_data, this.m_offset++);
            assert (!(object instanceof IArray)) : "IArray provided.";
            assert (!(object instanceof java.sql.Array)) : "java.sql.Array provided.";
            if (!this.m_isNested) {
                return object;
            }
            return new DSISimpleArray(object, DSISimpleArray.this.getArrayColumn().getTypeMetadata().getNestedColumnList().get(0));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove()");
        }
    }
}

