/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.AbstractGettableData;
import com.simba.cassandra.shaded.datastax.driver.core.CodecRegistry;
import com.simba.cassandra.shaded.datastax.driver.core.ColumnDefinitions;
import com.simba.cassandra.shaded.datastax.driver.core.DataType;
import com.simba.cassandra.shaded.datastax.driver.core.ProtocolVersion;
import com.simba.cassandra.shaded.datastax.driver.core.Row;
import com.simba.cassandra.shaded.datastax.driver.core.Token;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.DriverInternalError;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.regex.Pattern;

class ArrayBackedRow
extends AbstractGettableData
implements Row {
    private static final Pattern TOKEN_COLUMN_NAME = Pattern.compile("(system\\.)?token(.*)");
    private final ColumnDefinitions metadata;
    private final Token.Factory tokenFactory;
    private final List<ByteBuffer> data;

    private ArrayBackedRow(ColumnDefinitions metadata, Token.Factory tokenFactory, ProtocolVersion protocolVersion, List<ByteBuffer> data) {
        super(protocolVersion);
        this.metadata = metadata;
        this.tokenFactory = tokenFactory;
        this.data = data;
    }

    static Row fromData(ColumnDefinitions metadata, Token.Factory tokenFactory, ProtocolVersion protocolVersion, List<ByteBuffer> data) {
        if (data == null) {
            return null;
        }
        return new ArrayBackedRow(metadata, tokenFactory, protocolVersion, data);
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    @Override
    protected DataType getType(int i) {
        return this.metadata.getType(i);
    }

    @Override
    protected String getName(int i) {
        return this.metadata.getName(i);
    }

    @Override
    protected ByteBuffer getValue(int i) {
        return this.data.get(i);
    }

    @Override
    protected CodecRegistry getCodecRegistry() {
        return this.metadata.codecRegistry;
    }

    @Override
    protected int getIndexOf(String name) {
        return this.metadata.getFirstIdx(name);
    }

    @Override
    public Token getToken(int i) {
        if (this.tokenFactory == null) {
            throw new DriverInternalError("Token factory not set. This should only happen at initialization time");
        }
        this.checkType(i, this.tokenFactory.getTokenType().getName());
        ByteBuffer value = this.data.get(i);
        if (value == null || value.remaining() == 0) {
            return null;
        }
        return this.tokenFactory.deserialize(value, this.protocolVersion);
    }

    @Override
    public Token getToken(String name) {
        return this.getToken(this.metadata.getFirstIdx(name));
    }

    @Override
    public Token getPartitionKeyToken() {
        int i = 0;
        for (ColumnDefinitions.Definition column : this.metadata) {
            if (TOKEN_COLUMN_NAME.matcher(column.getName()).matches()) {
                return this.getToken(i);
            }
            ++i;
        }
        throw new IllegalStateException("Found no column named 'token(...)'. If the column is aliased, use getToken(String).");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Row[");
        for (int i = 0; i < this.metadata.size(); ++i) {
            ByteBuffer bb;
            if (i != 0) {
                sb.append(", ");
            }
            if ((bb = this.data.get(i)) == null) {
                sb.append("NULL");
                continue;
            }
            Object o = this.getCodecRegistry().codecFor(this.metadata.getType(i)).deserialize(bb, this.protocolVersion);
            if (o == null) {
                sb.append("NULL");
                continue;
            }
            sb.append(o.toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

