/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core;

import com.simba.cassandra.shaded.datastax.driver.core.Frame;
import com.simba.cassandra.shaded.datastax.driver.core.FrameCompressor;
import com.simba.cassandra.shaded.io.netty.buffer.ByteBuf;
import com.simba.cassandra.shaded.net.jpountz.lz4.LZ4Factory;
import com.simba.cassandra.shaded.net.jpountz.lz4.LZ4FastDecompressor;
import com.simba.cassandra.shaded.slf4j.Logger;
import com.simba.cassandra.shaded.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;

class LZ4Compressor
extends FrameCompressor {
    private static final Logger logger;
    static final LZ4Compressor instance;
    private static final int INTEGER_BYTES = 4;
    private final com.simba.cassandra.shaded.net.jpountz.lz4.LZ4Compressor compressor;
    private final LZ4FastDecompressor decompressor;

    private LZ4Compressor() {
        LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
        logger.info("Using {}", (Object)lz4Factory.toString());
        this.compressor = lz4Factory.fastCompressor();
        this.decompressor = lz4Factory.fastDecompressor();
    }

    @Override
    Frame compress(Frame frame) throws IOException {
        ByteBuf input = frame.body;
        ByteBuf frameBody = input.isDirect() ? this.compressDirect(input) : this.compressHeap(input);
        return frame.with(frameBody);
    }

    private ByteBuf compressDirect(ByteBuf input) throws IOException {
        int maxCompressedLength = this.compressor.maxCompressedLength(input.readableBytes());
        ByteBuf output = input.alloc().directBuffer(4 + maxCompressedLength);
        try {
            ByteBuffer in = LZ4Compressor.inputNioBuffer(input);
            input.readerIndex(input.writerIndex());
            output.writeInt(in.remaining());
            ByteBuffer out = LZ4Compressor.outputNioBuffer(output);
            int written = this.compressor.compress(in, in.position(), in.remaining(), out, out.position(), out.remaining());
            output.writerIndex(output.writerIndex() + written);
        }
        catch (Exception e) {
            output.release();
            throw new IOException(e);
        }
        return output;
    }

    private ByteBuf compressHeap(ByteBuf input) throws IOException {
        int maxCompressedLength = this.compressor.maxCompressedLength(input.readableBytes());
        int inOffset = input.arrayOffset() + input.readerIndex();
        byte[] in = input.array();
        int len = input.readableBytes();
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().heapBuffer(4 + maxCompressedLength);
        try {
            output.writeInt(len);
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int written = this.compressor.compress(in, inOffset, len, out, offset);
            output.writerIndex(output.writerIndex() + written);
        }
        catch (Exception e) {
            output.release();
            throw new IOException(e);
        }
        return output;
    }

    @Override
    Frame decompress(Frame frame) throws IOException {
        ByteBuf input = frame.body;
        ByteBuf frameBody = input.isDirect() ? this.decompressDirect(input) : this.decompressHeap(input);
        return frame.with(frameBody);
    }

    private ByteBuf decompressDirect(ByteBuf input) throws IOException {
        int readable = input.readableBytes();
        int uncompressedLength = input.readInt();
        ByteBuffer in = LZ4Compressor.inputNioBuffer(input);
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().directBuffer(uncompressedLength);
        try {
            ByteBuffer out = LZ4Compressor.outputNioBuffer(output);
            int read = this.decompressor.decompress(in, in.position(), out, out.position(), out.remaining());
            if (read != readable - 4) {
                throw new IOException("Compressed lengths mismatch");
            }
            output.writerIndex(output.writerIndex() + uncompressedLength);
        }
        catch (Exception e) {
            output.release();
            throw new IOException(e);
        }
        return output;
    }

    private ByteBuf decompressHeap(ByteBuf input) throws IOException {
        byte[] in = input.array();
        int len = input.readableBytes();
        int uncompressedLength = input.readInt();
        int inOffset = input.arrayOffset() + input.readerIndex();
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().heapBuffer(uncompressedLength);
        try {
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int read = this.decompressor.decompress(in, inOffset, out, offset, uncompressedLength);
            if (read != len - 4) {
                throw new IOException("Compressed lengths mismatch");
            }
            output.writerIndex(output.writerIndex() + uncompressedLength);
        }
        catch (Exception e) {
            output.release();
            throw new IOException(e);
        }
        return output;
    }

    static {
        LZ4Compressor i;
        logger = LoggerFactory.getLogger(LZ4Compressor.class);
        try {
            i = new LZ4Compressor();
        }
        catch (NoClassDefFoundError e) {
            i = null;
            logger.warn("Cannot find LZ4 class, you should make sure the LZ4 library is in the classpath if you intend to use it. LZ4 compression will not be available for the protocol.");
        }
        catch (Throwable e) {
            i = null;
            logger.warn("Error loading LZ4 library ({}). LZ4 compression will not be available for the protocol.", (Object)e.toString());
        }
        instance = i;
    }
}

