/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core.exceptions;

import com.simba.cassandra.shaded.datastax.driver.core.EndPoint;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.CoordinatorException;
import com.simba.cassandra.shaded.datastax.driver.core.exceptions.DriverException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class BusyConnectionException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;

    public BusyConnectionException(EndPoint endPoint) {
        super(String.format("[%s] Connection has run out of stream IDs", endPoint));
        this.endPoint = endPoint;
    }

    public BusyConnectionException(EndPoint endPoint, Throwable cause) {
        super(String.format("[%s] Connection has run out of stream IDs", endPoint), cause);
        this.endPoint = endPoint;
    }

    @Override
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    @Deprecated
    public InetSocketAddress getAddress() {
        return this.endPoint == null ? null : this.endPoint.resolve();
    }

    @Override
    @Deprecated
    public InetAddress getHost() {
        return this.endPoint == null ? null : this.endPoint.resolve().getAddress();
    }

    @Override
    public BusyConnectionException copy() {
        return new BusyConnectionException(this.endPoint, (Throwable)this);
    }
}

