/*
 * Decompiled with CFR 0.152.
 */
package com.simba.cassandra.shaded.datastax.driver.core.schemabuilder;

import com.simba.cassandra.shaded.datastax.driver.core.schemabuilder.SchemaStatement;
import com.simba.cassandra.shaded.google.common.base.Optional;
import java.util.Map;

public class KeyspaceOptions
extends SchemaStatement {
    private Optional<Map<String, Object>> replication = Optional.absent();
    private Optional<Boolean> durableWrites = Optional.absent();
    private final String command;
    private final String keyspaceName;

    public KeyspaceOptions(String command, String keyspaceName) {
        KeyspaceOptions.validateNotEmpty(keyspaceName, "Keyspace name");
        KeyspaceOptions.validateNotKeyWord(keyspaceName, String.format("The keyspace name '%s' is not allowed because it is a reserved keyword", keyspaceName));
        this.command = command;
        this.keyspaceName = keyspaceName;
    }

    public KeyspaceOptions replication(Map<String, Object> replication) {
        KeyspaceOptions.validateReplicationOptions(replication);
        this.replication = Optional.fromNullable(replication);
        return this;
    }

    public KeyspaceOptions durableWrites(Boolean durableWrites) {
        this.durableWrites = Optional.fromNullable(durableWrites);
        return this;
    }

    @Override
    String buildInternal() {
        StringBuilder builtStatement = new StringBuilder("\n\t");
        builtStatement.append(this.command);
        builtStatement.append(" ");
        builtStatement.append(this.keyspaceName);
        builtStatement.append("\n\tWITH\n\t\t");
        boolean putSeparator = false;
        if (this.replication.isPresent()) {
            builtStatement.append("REPLICATION = {");
            int l = this.replication.get().entrySet().size();
            for (Map.Entry<String, Object> e : this.replication.get().entrySet()) {
                builtStatement.append("'").append(e.getKey()).append("'").append(": ");
                if (e.getValue() instanceof String) {
                    builtStatement.append("'").append(e.getValue()).append("'");
                } else {
                    builtStatement.append(e.getValue());
                }
                if (--l <= 0) continue;
                builtStatement.append(", ");
            }
            builtStatement.append('}');
            builtStatement.append("\n\t\t");
            putSeparator = true;
        }
        if (this.durableWrites.isPresent()) {
            if (putSeparator) {
                builtStatement.append("AND ");
            }
            builtStatement.append("DURABLE_WRITES = " + this.durableWrites.get().toString());
        }
        return builtStatement.toString();
    }

    static void validateReplicationOptions(Map<String, Object> replicationOptions) {
        if (replicationOptions != null && !replicationOptions.containsKey("class")) {
            throw new IllegalArgumentException("Replication Strategy 'class' should be provided");
        }
        if (replicationOptions != null && !(replicationOptions.get("class") instanceof String)) {
            throw new IllegalArgumentException("Replication Strategy should be of type String");
        }
    }
}

